"""Finds the minimum cost for veto voting circuits for different prime moduli."""

from sympy import sieve

from oraqle.compiler.boolean.bool_and import _minimum_cost

exponentiation_results = {
    2: ([(0, 0.0)], 8.633400000002123e-05),
    3: ([(1, 0.75)], 4.6670000000137435e-06),
    5: ([(2, 1.5)], 7.695799999996034e-05),
    7: ([(3, 2.5)], 0.0053472920000000035),
    11: ([(4, 3.25)], 0.007671625000000015),
    13: ([(4, 3.25)], 0.002812749999999975),
    17: ([(4, 3.0)], 7.891700000001167e-05),
    19: ([(5, 4.0)], 0.012155541999999964),
    23: ([(5, 5.0)], 0.03937258299999996),
    29: ([(5, 5.0)], 0.018942542000000007),
    31: ([(5, 6.0), (6, 5.0)], 0.064326),
    37: ([(6, 4.75)], 0.019883207999999986),
    41: ([(6, 4.75)], 0.02284237499999997),
    43: ([(6, 5.75)], 0.03223737499999996),
    47: ([(6, 6.75), (7, 6.0)], 0.607119292),
    53: ([(6, 5.75)], 0.03940958299999997),
    59: ([(6, 6.75)], 1.243811584),
    61: ([(6, 6.75), (7, 5.75)], 0.446000167),
    67: ([(7, 5.5)], 0.051902208000000005),
    71: ([(7, 6.5)], 0.18221370799999997),
    73: ([(7, 5.5)], 0.044685417000000005),
    79: ([(7, 6.75)], 0.362901958),
    83: ([(7, 6.5)], 0.121000375),
    89: ([(7, 6.5)], 0.182695375),
    97: ([(7, 5.5)], 0.06858350000000002),
    101: ([(7, 6.5)], 0.38408749999999997),
    103: ([(7, 7.5), (8, 6.5)], 3.3626029170000002),
    107: ([(7, 7.5)], 8.891771667),
    109: ([(7, 7.5), (8, 6.5)], 4.596561917),
    113: ([(7, 6.5)], 0.1859389579999995),
    127: ([(7, 9.5), (8, 7.5)], 1619.89318625),
    131: ([(8, 6.25)], 0.05858354099996177),
    137: ([(8, 6.25)], 0.10623299999999991),
    139: ([(8, 7.25)], 1.2351711669999998),
    149: ([(8, 7.25)], 0.48292875),
    151: ([(8, 7.5)], 4.641820375),
    157: ([(8, 7.5)], 2.49218775),
    163: ([(8, 7.25)], 0.5001321249999999),
    167: ([(8, 8.25), (9, 7.5)], 48.444338791),
    173: ([(8, 8.25), (9, 7.5)], 37.677076833),
    179: ([(8, 8.25)], 132.232723375),
    181: ([(8, 8.25), (9, 7.25)], 53.822612083999985),
    191: ([(8, 9.25), (9, 8.25)], 907.7980847910001),
    193: ([(8, 6.25)], 0.12370429100008096),
    197: ([(8, 7.25)], 0.6496936670000002),
    199: ([(8, 8.25), (9, 7.25)], 50.102889333),
    211: ([(8, 8.25)], 83.20584475),
    223: ([(8, 10.0), (9, 8.25)], 6772.927301542),
    227: ([(8, 8.25)], 50.801469917),
    229: ([(8, 8.25)], 39.942074416000004),
}


def run_experiments():
    """Run the experiments and prints the results."""
    max_k = 50
    best_costs = [100000000.0] * (max_k + 1)
    best_ps = [None] * (max_k + 1)

    # This is for sqr = 0.75 mul
    primes = list(sieve.primerange(300))[1:50]
    for p in primes:
        print(f"------ p = {p} ------")
        for k in range(2, max_k + 1):
            cost = _minimum_cost(k, exponentiation_results[p][0][0][1], p)
            if cost < best_costs[k - 2]:
                best_costs[k - 2] = cost
                best_ps[k - 2] = p

    for k, cost, p in zip(range(2, max_k + 1), best_costs, best_ps):
        print(k, cost, p)


if __name__ == "__main__":
    run_experiments()
