# type: ignore

from copy import deepcopy
import itertools

import numpy as np

from complexity.constants import *
from complexity.supporting_functions import *
from complexity.models.macro_ctm import TriangularFD

reds = get_colors_from_cmap('Reds', 5, 0.30, 0.0)
blues = get_colors_from_cmap('Blues', 5, 0.27, 0.03)
greens = get_colors_from_cmap('Greens', 5, 0.24, 0.06)

divider_config = {
    LEFT: 0.8,
    RIGHT: 0.1,
    BOTTOM: 0.54,
    TOP: 0.2,
    GAP_HOR: 0.8,
    GAP_VER: 0.7,  #SHARE_Y:True
}

mpl_config = {
    FIGURE: {
        'figsize': (6.8, 4.4), TITLE: 'Social force empirical'
    },
    AXES: {
        GRID: {
            'visible': True
        },
        Y_LABEL_CONFIG: {
            'fontsize': 8
        },
        X_LABEL_CONFIG: {
            'fontsize': 8
        },
        Y_TICK_LABELS_CONFIG: {
            'labelsize': 8
        },
        X_TICK_LABELS_CONFIG: {
            'labelsize': 8
        },
        TITLE_CONFIG: {
            'fontsize': 9
        },
        TICK_LABEL_FORMAT: {
            'axis': 'y', 'style': 'sci', 'scilimits': (0, 0)
        }
    },
    LEGEND: {
        'fontsize': 8
    },
    LINE: {},
}

base_plots_config: dict = {
    DATA_TYPE: EMPIRICAL_DATA,
    PLOT_TYPE: MULTI_LINE,
    TIME_STEPS_PER_SEC_PER_MODEL: {
        'simple_social_force': 0.1
    },
    RUN_TIME_UNIT: RunTimeUnit.MILI_SEC,
    MODEL_TAG: ['simple_social_force'],
    X_DATA_VAR: None,
    AX_CONFIG: deepcopy(mpl_config[AXES]),
    ARTIST_CONFIG: {
        LINE: {
            LINE_WIDTH: 2
        }, TEXT: {
            'color': 'w', 'fontsize': 8
        }
    },
    COLORS: {},
    STYLES: {},
    LINE_WIDTHS: {},
}
base_plots_config[AX_CONFIG][Y_LABEL] = f'run time/simulated second [{base_plots_config[RUN_TIME_UNIT]}/s]'
base_plots_config[AX_CONFIG]['grid'] = {'visible': 'on'}

ped_cnt_config: dict = deepcopy(base_plots_config)
ped_cnt_config.update({LINES: [
    {CONFIG_NAME: 'ssf_ped_count', X_DATA_VAR:PED_COUNT, KWARGS: {OBSTACLE_COUNT:  2}, LEGEND_LABEL: '2 obstacles', LINE_CONFIG:{STYLE:'-', COLOR:reds[-1]}},
    {CONFIG_NAME: 'ssf_ped_count', X_DATA_VAR:PED_COUNT, KWARGS: {OBSTACLE_COUNT:  10}, LEGEND_LABEL: '10 obstacles', LINE_CONFIG:{STYLE:'-', COLOR:reds[-3]}},
    {CONFIG_NAME: 'ssf_ped_count', X_DATA_VAR:PED_COUNT, KWARGS: {OBSTACLE_COUNT: 50}, LEGEND_LABEL: '50 obstacles', LINE_CONFIG:{STYLE:'-', COLOR:reds[-2]}},
    ], 
AX_LOC: [0, 0]})
ped_cnt_config[AX_CONFIG][TITLE] = 'Pedestrian count'
ped_cnt_config[AX_CONFIG][X_LABEL] = 'Pedestrian count'


obs_cnt_config: dict = deepcopy(base_plots_config)
obs_cnt_config.update({LINES: [
    {CONFIG_NAME: 'ssf_obs_count', X_DATA_VAR:OBSTACLE_COUNT, KWARGS: {PED_COUNT:  1}, LEGEND_LABEL: '1 pedestrian', LINE_CONFIG:{STYLE:'-', COLOR:reds[-1]}},
    {CONFIG_NAME: 'ssf_obs_count', X_DATA_VAR:OBSTACLE_COUNT, KWARGS: {PED_COUNT:  10}, LEGEND_LABEL: '10 pedestrians', LINE_CONFIG:{STYLE:'-', COLOR:reds[-4]}},
    {CONFIG_NAME: 'ssf_obs_count', X_DATA_VAR:OBSTACLE_COUNT, KWARGS: {PED_COUNT: 100}, LEGEND_LABEL: '100 pedestrians', LINE_CONFIG:{STYLE:'-', COLOR:reds[-2]}},    
], 
AX_LOC: [0, 1]})
obs_cnt_config[AX_CONFIG][TITLE] = 'Obstacle count'
obs_cnt_config[AX_CONFIG][X_LABEL] = 'Obstacle count'

plot_configs = [ped_cnt_config, obs_cnt_config]


def get_config() -> tuple[dict, dict, list[dict]]:
  return mpl_config, divider_config, plot_configs  # type: ignore
