from complexity.infrastructures.unidirectional_corridor import RectangularCorridor, UnidirectionalCorridor
from complexity.constants import *

jam_density = 1/(0.4*0.4)
ped_radius = 0.2

def test_single_ped_placement():
    unidir_corridor = RectangularCorridor(20,6,2)

    ped_count = 1
    local_density = DistrType.HOMOGENEOUS

    pos_per_ped, density = unidir_corridor.get_ped_pos_continuous(ped_count, jam_density, local_density)    
    assert len(pos_per_ped) == 1

def test_double_ped_placement():
    unidir_corridor = RectangularCorridor(20,6,2)
    mean_density = 2/unidir_corridor.area    
    density_distr_factor = 0

    pos_per_ped, _ = unidir_corridor.get_ped_pos_continuous(mean_density, jam_density, density_distr_factor)
    
    assert len(pos_per_ped) == 2
    pos_ped_1 = pos_per_ped[0]
    pos_ped_2 = pos_per_ped[1]

    assert val_is_between(pos_ped_1[0], 0, 1.2) or val_is_between(pos_ped_1[0], 0.8, 2)
    if val_is_between(pos_ped_1[0], 0, 1.2):
        assert val_is_between(pos_ped_2[0], 0.8, 2)
    else:
        assert val_is_between(pos_ped_2[0], 0, 1.2)

def test_triple_ped_placement():
    unidir_corridor = RectangularCorridor(20,6,2)
    mean_density = 3/unidir_corridor.area    
    density_distr_factor = 0
    for _ in range(10):
        pos_per_ped, _ = unidir_corridor.get_ped_pos_continuous(mean_density, jam_density, density_distr_factor)
        
        assert len(pos_per_ped) == 3
        pos_ped_1 = pos_per_ped[0]
        pos_ped_2 = pos_per_ped[1]
        pos_ped_3 = pos_per_ped[2]

        assert val_is_between(pos_ped_1[0], 0, 0.8) or val_is_between(pos_ped_1[0], 1.2, 2)
        if val_is_between(pos_ped_1[0], 0, 0.8):
            assert val_is_between(pos_ped_2[0], 0.4, 1.6)
            assert val_is_between(pos_ped_3[0], 1.2, 2.0)
        else:
            assert val_is_between(pos_ped_2[0], 0.4, 1.6)
            assert val_is_between(pos_ped_3[0], 0, 0.8)

def test_3_ped_dff_1():
    unidir_corridor = RectangularCorridor(20,6,2)
    mean_density = 3/unidir_corridor.area    
    density_distr_factor = 1
    for _ in range(10):
        pos_per_ped, _ = unidir_corridor.get_ped_pos_continuous(mean_density, jam_density, density_distr_factor)
        assert len(pos_per_ped) == 3
        assert len(pos_per_ped) == len(set(pos_per_ped))
        pos_ped_1 = pos_per_ped[0]
        pos_ped_2 = pos_per_ped[1]
        pos_ped_3 = pos_per_ped[2]

        assert value_is_either_or(pos_ped_1[0], 0.2, 1.8)
        if pos_ped_1[0] == 0.2:
            assert pos_ped_2[0] == 0.2
            assert pos_ped_3[0] == 0.2
        else:
            assert pos_ped_2[0] == 1.8
            assert pos_ped_3[0] == 1.8

def test_3_ped_dff_0_5():
    unidir_corridor = RectangularCorridor(20,6,2)
    mean_density = 3/unidir_corridor.area    
    density_distr_factor = 0.5
    for _ in range(10):
        pos_per_ped, _ = unidir_corridor.get_ped_pos_continuous(mean_density, jam_density, density_distr_factor)
        assert len(pos_per_ped) == 3
        assert len(pos_per_ped) == len(set(pos_per_ped))
        pos_ped_1 = pos_per_ped[0]
        pos_ped_2 = pos_per_ped[1]
        pos_ped_3 = pos_per_ped[2]

        assert value_is_either_or(pos_ped_1[0], 0.2, 1.8)
        if pos_ped_1[0] == 0.2:
            assert value_is_either_or(pos_ped_2[0], 0.2,0.6)
            assert pos_ped_3[0] == 0.6
        else:
            assert value_is_either_or(pos_ped_2[0], 1.8,1.4)
            assert pos_ped_3[0] == 1.4

def val_is_between(value, lower_bound, upper_bound):
    return value >= lower_bound and value <= upper_bound

def value_is_either_or(value, value_either, value_or):
    return value == value_either or value == value_or