from pathlib import Path
from base_classes import PedModel
from complexity.models.macro_ctm import MacroContGodunov
from complexity.infrastructures.unidirectional_corridor import RectangularCorridor
from complexity.computational_complexity import compute_complexity, Experiment
from complexity.constants import DistrType


def test_ped_call_model(ped_count:int, local_density:DistrType|float, ped_class_count:int, class_distribution:DistrType) -> None:
    infra = RectangularCorridor.get_instance(2,2,2)
    ped_model = MacroContGodunov(infra)
    experiment = Experiment(ped_model.tag, infra.tag, ped_count, None, None, local_density, ped_class_count, class_distribution, 0) #type:ignore
    ped_model.initialize()
    ped_model.set_state(experiment)

def test_ped_class_hmgns() -> None:
    test_ped_call_model(4, DistrType.HOMOGENEOUS, 2, DistrType.HOMOGENEOUS)

def test_ped_class_cntrd() -> None:
    test_ped_call_model(4, DistrType.CONCENTRATED, 2, DistrType.CONCENTRATED)

def test_ped_class_hmgns_cntrd() -> None:
    test_ped_call_model(16, DistrType.HOMOGENEOUS, 8, DistrType.CONCENTRATED)


def test_full_run() -> None:
    input_file = Path(r'C:\Users\martijnsparnaa\surfdrive\PhD\Complexity, Scalability & Validity\data\test\test_experiments.txt')
    output_dir = Path(r'C:\Users\martijnsparnaa\surfdrive\PhD\Complexity, Scalability & Validity\data\test')
    basename = 'macro_test'

    compute_complexity(input_file, basename, output_dir)

if __name__ == '__main__':
    #test_creation()
    test_ped_class_hmgns()
    test_ped_class_cntrd()
    test_ped_class_hmgns_cntrd()