
from pathlib import Path
from pydoc import resolve

import numpy as np

from complexity.computational_complexity import ConvergenceConfig, ExpSetsFile, InputFile, OutputFile, ResultsFile, TempStateFile
from complexity.models.social_force import SocialForceModel
from complexity.infrastructures.unidirectional_corridor import UnidirectionalCorridor

directory = Path('..').joinpath('__work')
run_id = 'test'

models = [SocialForceModel]

rng = np.random.default_rng()

def test_input_file_write() -> None:
    input_file = InputFile(directory, run_id)
   
    convergence_config = ConvergenceConfig()
    
    seeds = list(rng.integers(1, np.iinfo(np.int32).max, size=1000))
    input_file.write_data_to_file(experiments, convergence_config, seeds)
    print(f'{input_file.filename.resolve()}')

def test_temp_files() -> None:
    temp_state_file = TempStateFile(directory, run_id)

    run_times_per_exp = {experiment:list(rng.integers(0,10, 4)) for experiment in experiments}

    convergence_config = ConvergenceConfig()
    convergence_config.increment_step()
    convergence_config.converged_experiments.add(experiments.pop())
    seed_ind = 10

    temp_state_file.write_data_to_file(run_times_per_exp, convergence_config, seed_ind)
    print(f'{temp_state_file.temp_output_file.filename.resolve()}')
    print(f'{temp_state_file.temp_state_filename.resolve()}')

def test_read_input_file() -> None:
    input_file = InputFile(directory, 'input_test')
    print(input_file.filename.resolve())
    experiments, convergence_config, seeds = input_file.read_data_from_file()
    print(experiments)
    print(convergence_config)
    print(seeds)

def test_read_exp_sets_file() -> None:
    ExpSetsFile(Path(r'C:\Users\martijnsparnaa\surfdrive\PhD\Complexity, Scalability & Validity\data\test'), 'test_20220908154545').read_data_from_file()

def test_convert_to_res() -> None:
    output_file = OutputFile(Path(r'C:\Users\martijnsparnaa\surfdrive\PhD\Complexity, Scalability & Validity\data\all_three_mods'), 'all_three_mods_full_15_09_20220916130547')
    ResultsFile.create_from_output(output_file)

if __name__ == "__main__":
    #test_input_file_write()
    #test_temp_files()
    #test_read_input_file()
    #test_read_exp_sets_file()
    test_convert_to_res()