from complexity.infrastructures.unidirectional_corridor import RectangularCorridor, UnidirectionalCorridor
from complexity.constants import *

import numpy as np

from complexity.models.social_force import SPATIAL_GRID_SIZE, get_spatial_grid_pos

jam_density = 1/(0.4*0.4)
ped_radius = 0.2

def homogeneous_v_concentrated_placement():
    unidir_corridor = RectangularCorridor(20,6,2)

    ped_count = 100
    
    pos_per_ped_h, density_h = unidir_corridor.get_ped_pos_continuous(ped_count, jam_density, local_density = DistrType.HOMOGENEOUS)   
    dens_per_cell_h, x_count, y_count = get_density_per_grid_cell(unidir_corridor, pos_per_ped_h) 

    pos_per_ped_c, density_c = unidir_corridor.get_ped_pos_continuous(ped_count, jam_density, local_density = DistrType.CONCENTRATED)   
    dens_per_cell_c, x_count, y_count = get_density_per_grid_cell(unidir_corridor, pos_per_ped_c) 


    print('\n Homogeneous v concentrated placement')
    print(f'Density = {density_h} - {density_c}')
    for x in range(x_count):
        for y in range(y_count):
            print(f'({x:02d},{y:02d}) = {dens_per_cell_h[x,y]:.3f} - {dens_per_cell_c[x,y]:.3f}')


def concentrated_placement():
    unidir_corridor = RectangularCorridor(20,6,2)

    ped_count = 100
    local_density = DistrType.CONCENTRATED

    pos_per_ped, density = unidir_corridor.get_ped_pos_continuous(ped_count, jam_density, local_density)   
    dens_per_cell, x_count, y_count = get_density_per_grid_cell(unidir_corridor, pos_per_ped) 

    print('\n Concentrated placement')
    print(f'Density = {density}')
    for x in range(x_count):
        for y in range(y_count):
            print(f'({x:02d},{y:02d}) = {dens_per_cell[x,y]}')


def get_density_per_grid_cell(unidir_corridor:UnidirectionalCorridor, pos_per_ped):
    x_count = int(np.ceil(unidir_corridor.length/SPATIAL_GRID_SIZE))
    y_count = int(np.ceil(unidir_corridor.width/SPATIAL_GRID_SIZE))
    dens_array = np.zeros((x_count, y_count))
    for ped_pos in pos_per_ped:
        x, y = get_spatial_grid_pos(ped_pos[0], ped_pos[1], SPATIAL_GRID_SIZE)
        dens_array[x,y] += 1

    dens_array = dens_array/(SPATIAL_GRID_SIZE*SPATIAL_GRID_SIZE)

    return dens_array, x_count, y_count
    

if __name__ == '__main__':
    homogeneous_v_concentrated_placement()
