import argparse
import pathlib

from complexity.computational_complexity import valid_base_name, valid_input_file, valid_output_dir


def parse_sys_input() -> None:
    parser = argparse.ArgumentParser(
        description=
        'Compute the computational complexity using a specific configuration')
    parser.add_argument('input file',
                        type=valid_input_file,
                        help="The path to the configuration file")
    parser.add_argument('basename',
                        type=valid_base_name,
                        help="The basename for all output files")
    parser.add_argument('output_dir',
                        type=valid_output_dir,
                        help="The path to the output file")

    args = parser.parse_args()
    print(args)

if __name__ == '__main__':
    parse_sys_input()