# Computational complexity of pedestrian models
This Python package contains the Python implementation of the empirical method from the Asses Pedestrian model Speed (APS) framework.

## How to install APS

Clone or download APS from the repository. You can then either install APS as a local package using `pip install -e <path to APS>`. The path should be to the folder that contains the setup.cfg file. Alternatively, you can install the required packages using the requirements.txt file via `pip install -r requirements.txt` (make sure your current directory is set to the folder that contains the requirements.txt file).

## How to run a complexity analysis for a given set of models and test cases

Run a set of simulations and measure the run time:    

    python cc.py [input file] [basename] [output directory]

- The input file: The file which contains the configuration of the analysis (i.e. which models and test cases to run)
- The basename: The name used for the files that store the output
- The output directory: The path to the directory where the output will be stored.

## The input file
The input file uses a simple configuration format. That is:

    [Section name]
    key = value

The configuration has the following sections:

### Models
The model section defines the models that are used in the experiment. This section is compulsory. The key is a name you can choose freely. In the example below this is "social_force". The value is the module name and the class name. The module is one of the modules located in the models package. So in the example below, the module is "social_force" and the class is "SocialForceModel".

    [models]
    # Define which models to use based on the module (in the models package) and class name
    social_force = social_force.SocialForceModel

### Infrastucture
The infrastructure section defines the infrastructures that are used in the experiment. This section is compulsory. The key is a name you can choose freely. In the example below this is "unidirectional_corridor". The value is the module name and the class name. The module is one of the modules located in the models package. So in the example below, the module is "unidirectional_corridor" and the class is "UnidirectionalCorridor".

    [infrastructures]
    # Define which infrastructures to use based on the module (in the infrastructures package) and class name
    unidirectional_corridor = unidirectional_corridor.UnidirectionalCorridor

### Convergence setup
The convergence section contains the convergence configuration. This section is optional. All fields in this section are alos optional. For any field for which no value is provided, the default value will be used. The values shown in the example below are the default values.

    [convergence_setup]
    init_step_count = 30
    allowable_err = 0.005
    step_size = 10
    max_step_count = 3000

### Experiments
The experiments can be defined using a section per set of experiments. These sets are then listed (comma-seperated) in the experiments section.

    [experiments]
    experiments = sf_ped_count, sf_obs_count

Each individual experiment is defined by the model, infrastructure and the other experiment variables.

    [sf_ped_count]
    model_tags = social_force
    infra_tags = unidirectional_corridor
    ped_counts = 1:1:10, 20:10:200
    obstacle_counts = 2, 10, 100, 1000
    infrastructure_args = (20, 6)
    ped_class_counts = None
    local_densities = homogeneous
    class_distributions = None
    non_comb = None
    base_var = ped_counts

    [sf_obs_count]
    model_tags = social_force
    infra_tags = unidirectional_corridor
    ped_counts = 1, 100, 750
    obstacle_counts = 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 200, 300, 400, 500, 600, 700, 800, 900, 1000
    infrastructure_args = (20, 6)
    ped_class_counts = None
    local_densities = homogeneous
    class_distributions = None
    non_comb = None
    base_var = obstacle_counts


## How to run visualize the results

Plot empirical data

    python vis.py e [output dir] [run id] [plot config file]

Plot atomic counting equations

    python vis.py t [equation file dir] [plot config_file]

Plot both

    python vis.py b [equation file dir] [output dir] [run id] [plot config file]


## Acknowledgements

Technische Universiteit Delft hereby disclaims all copyright interest in the
program "NOMAD" A microscopic pedestrian simulation model
written by the Author(s).
Stefan Aarninkhof, Dean of Civil Engineering and Geosciences 
