## Overview

This directory provides input data for the project. As the input data are sensetive, they will not be shared publically. In case one needs to run the project, this directory should contain the required raw input data.


│-- /outputs # the output directory of the project to write the results in. By running the project from scratch, this folder will be populated but initially, it is empty in the repository. 
│
│-- /tables # The directory containing the overall statitics on accuracy of the trip production prediction for the three spatial scales.
|
|-- _0_ProdPred_visualizations.ipynb        # 0) This python notebook performs data pre-processing and making the LSTM and GCN+LSTM prediction on the preprocessed trip production in the Netherlands
|-- _1_worstPred+locations.ipynb            # 1) This python notebook analyses the prediction result to find the relation between prediction accuracy and location of the zone.
|-- _2_demographicData.ipynb                # 2) This python notebook performs the data-preprocessing of the CBS socio-demoraphic data. Then a feature engineering step is applied on the socio-demographic feature vector of each zone to perform k-means clustering of these identified features. The output of this steps is the distribution of each feature vector across the 5 identified clusters under the postal code zones spatial scale.  
|-- _3_Clustering&Analysis_gemScale.ipynb   # 3) This python notebook performs the clustering same as the previous step for the municipality spatial scale. Subsequently, the clustering analysis is performed. 
|-- _4_Clustering&Analysis_provScale.ipynb  # 4) This python notebook performs the clustering same as the previous step for the province spatial scale. Subsequently, the clustering analysis is performed.
│-- README.md                            # This README file
│-- requirements.txt                     # Python dependencies
```
## Installation
### Prerequisites
- Python >=3.7
- Git
- Jupyter Notebook (if you wish to run the notebooks)
### Setting Up the Environment
- Clone the repository:
  
```bash
# Clone the repository
git clone <repository-url>
# Navigate to the project directory
cd <repository-directory>
```

- Install the required Python packages:
```bash
pip install -r requirements.txt
```
# Usage
To run the code provided in this repository, run the python notebooks acording to the order provided in the naming convention. Please make sure the input data is included in the data directory.
# Datasets
The input datasets used in this study should be included in the /data directory. As the project's datasets are either sensitve or too large to include directly in the repository, they can be accessed via TUDelft Research Drive link, or you may need to contact the associated point of contact at the time.

# Acknowledgments
This research is sponsored by the NWO/TTW project MiRRORS under grant agreement 16270.
