## Overview
This repository contains the code, and supplementary materials associated with the research paper titled "The Role of Spatial Features and Adjacency in Data-driven Short-term Prediction of Trip Production: An Exploratory Study in the Netherlands". The paper is currently under review for publication in the IEEE Transactions on Intelligent Transportation Systems.

## Table of Contents

- [Introduction](#introduction)
- [Repository Structure](#repository-structure)
- [Installation](#installation)
  - [Prerequisites](#prerequisites)
  - [Setting Up the Environment](#setting-up-the-environment)
- [Usage](#usage)
- [Datasets](#datasets)
- [License](#license)
- [Contact Information](#contact-information)
- [Reproducing Results](#reproducing-results)
- [License](#license)
- [Contact Information](#contact-information)
- [Acknowledgments](#acknowledgments)

## Introduction
This repository includes the implementation of models and analyses presented in the study, which investigates the role of spatial features and adjacency in improving the accuracy of short-term trip production predictions. The study focuses on a case in the Netherlands and explores various data-driven approaches.

## Repository Structure
The repository is organized as follows:
```bash
/project-root
│-- /data                                   # input data for the project. As the input data are sensetive, they will not be shared publically
│   │
│-- /outputs                                # the output directory of the project to write the results in. By running the project from scratch, this folder will be populated but initially, it is empty in the repository. 
│
│-- /tables                                 # The directory containing the overall statitics on accuracy of the trip production prediction for the three spatial scales.
|
|-- _0_ProdPred_visualizations.ipynb        # 0) This python notebook performs data pre-processing and making the LSTM and GCN+LSTM prediction on the preprocessed trip production in the Netherlands
|-- _1_worstPred+locations.ipynb            # 1) This python notebook analyses the prediction result to find the relation between prediction accuracy and location of the zone.
|-- _2_demographicData.ipynb                # 2) This python notebook performs the data-preprocessing of the CBS socio-demoraphic data. Then a feature engineering step is applied on the socio-demographic feature vector of each zone to perform k-means clustering of these identified features. The output of this steps is the distribution of each feature vector across the 5 identified clusters under the postal code zones spatial scale.  
|-- _3_Clustering&Analysis_gemScale.ipynb   # 3) This python notebook performs the clustering same as the previous step for the municipality spatial scale. Subsequently, the clustering analysis is performed. 
|-- _4_Clustering&Analysis_provScale.ipynb  # 4) This python notebook performs the clustering same as the previous step for the province spatial scale. Subsequently, the clustering analysis is performed.
│-- README.md                               # This README file
|-- LICENSE                                 # This the project LICENSE file            

│-- requirements.txt                        # Python dependencies
```
## Installation
### Prerequisites
- Python >=3.7
- Git
- Jupyter Notebook (if you wish to run the notebooks)
### Setting Up the Environment
- Clone the repository:
  
```bash
# Clone the repository
git clone <repository-url>
# Navigate to the project directory
cd <repository-directory>
```

- Install the required Python packages:
```bash
pip install -r requirements.txt
```
# Usage
To run the code provided in this repository, run the python notebooks acording to the order provided in the naming convention. Please make sure the input data is included in the data directory.
# Datasets
The input datasets used in this study should be included in the /data directory. As the project's datasets are either sensitve or too large to include directly in the repository, they can be accessed via TUDelft Research Drive link, or you may need to contact the associated point of contact at the time.

# License
This project is licensed under the MIT License - see the LICENSE file for details.

# Contact Information
For any inquiries, please contact the corresponding author of the paper, [Zahra Eftekhar](mailto: z.eftekhar2016@gmail.com)

# Acknowledgments
This research is sponsored by the NWO/TTW project MiRRORS under grant agreement 16270.
