# Bachelor Thesis 
### Creating Robust Train Unit Shunting Plans using Probabilistic Inference

This repository contains all the code related to the Bachelor thesis [Creating Robust Train Unit Shunting Plans using Probabilistic Programming](https://repository.tudelft.nl/) for the Bachelor of Computer Science and Engineering at Delft University Of Technology. This research is part of the course [Research Project CSE3000](https://github.com/TU-Delft-CSE/Research-Project) (2025/Q4) of the [TU Delft](https://github.com/TU-Delft-CSE).

Author: G.B.J. van Zwienen<br>
Supervisors: S. Dumančić, I.K. Hanou, R.J. Gardos Reid<br>
EEMCS, Delft University Of Technology; The Netherlands; June 21, 2025<br>

### Setup and running experiments
Run the devcontainer in `/workspace/.devcontainer`, follow the README.md files in the submodules (don't forget to create and activate the conda environments).
Install and run julia:
```sh
curl -fsSL https://install.julialang.org | sh

julia --project=.

pkg> instantiate

julia> include("planner.jl")
```

#### [Planner.jl](planner.jl)
`get_random_values_from_normal()` contains a variable STD, which changes the standard deviation of the normal distribution where the random variables are sampled from and consequently the degree of the uncertainty.

`generate_scenario_and_run_planner()` contains code to sample uncertain cleaning times. Uncomment the code to toggle this.

`main()` contains a variable `ITERATIONS` which defines the amount of iterations done by the importance sampling process.

To start the inference, run `main()`

#### [Solver configuration](algorithm-files/solver-config.yaml)
In order to change scenarios, change the `scenario_config_path` variable in `main()`, and change the location in the solver config file: [algorithm-files/solver-config.yaml](algorithm-files/solver-config.yaml)

[solver-config.yaml](algorithm-files/solver-config.yaml) contains the settings for Tabu Search and Simulated Annealing which are explained in the [README](robust-rail-solver/README.md)  in the solver submodule.

#### [Generation configuration files](algorithm-files/generation-config/cleaning_configuration.json)
In the generation configuration files, it is important to define the trains in the order when they arrive, and the trains should also depart in the order as defined. This is because the ID of the outgoing trains defined in the configuration file is different than the ID of the trains in the final plan.<br>
So INCORRECT:
```json
"custom_trains": [
    {
        "arrival_time": 200,
    },
    {
        "arrival_time": 50,
    },
    {
        "departure_time": 900,
    },
    {
        "departure_time": 600,
    }
]
```
CORRECT:
```json
"custom_trains": [
    {
        "arrival_time": 50,
    },
    {
        "arrival_time": 200,
    },
    {
        "departure_time": 600,
    },
    {
        "departure_time": 900,
    }
]
```

### Contents
- planner.jl: code for modelling, solving and probabilistic inference
- algorithm-files
    - generation-config: contains configuration files which can be used by the robust-rail-generator to create a scenario file
    - locations: Kleine Binckhorst shunting yard used in the first graph in the results section of the thesis.
    - locations-simple: shunting yard used in the simple routing example in the thesis
    - locations-cleaning-task: shunting yard used in the cleaning example in the thesis

    - plans: output plan location
    - scenarios: contains scenarios. Output of the robust-rail-generator, input to the robust-rail-solver

Robust Rail submodules
- robust-rail-evaluator
- robust-rail-generator
- robust-rail-solver

### Overview of submodules
The Robust Rail solver for the Train Unit Shunting Problem consists of three components (from the [Robust RAIL organization](https://github.com/orgs/Robust-Rail-NL/)): 
- the solver is a local search solver that takes a location file and a scenario file and outputs a plan for that scenario
- the evaluator is a very simple simulator that takes a location and scenario file along with a plan file and checks whether the plan is valid (not used in this code)
- the generator creates a scenario file for a given location file, based on a specified configuration.

### Experiments in the paper
This section shows the configuration files used for the experiments in the thesis. 

#### Experiment 4.1
Location: [algorithm-files/locations/location.json](algorithm-files/locations/location.json)<br>
Scenario generation configuration file: [algorithm-files/generation-config/three-three-configuration.json](algorithm-files/generation-config/three-three-configuration.json)

#### Experiment 4.2
Location: [algorithm-files/locations-simple/location_hip.json](algorithm-files/locations-simple/location_hip.json)<br>
Scenario generation configuration file: [algorithm-files/generation-config/simple-configuration.json](algorithm-files/generation-config/simple-configuration.json)

#### Experiment 4.3
Location: [algorithm-files/locations-cleaning-task/location_hip.json](algorithm-files/locations-cleaning-task/location_hip.json)<br>
Scenario generation configuration file: [algorithm-files/generation-config/cleaning_configuration.json](algorithm-files/generation-config/cleaning_configuration.json)

The cleaning uncertainty can be toggled by uncommenting the code in [planner.jl](planner.jl) in `generate_scenario_and_run_planner()`.


### Problem description
Information about the Train Unit Shunting Problem and the local search approach can be found [in this paper](https://pubsonline.informs.org/doi/10.1287/trsc.2021.1090):

```bibtex
R. van den Broek, H. Hoogeveen, M. van den Akker, and B. Huisman. A Local Search Algorithm for Train Unit Shunting with Service Scheduling (2021). Transportation Science , Vol. 56, No. 1 
Institute for Operations Research and the Management Sciences (INFORMS), p. 141-161.
```

### Other tips
- [robust-rail-generator/src/scenario_generator/easy_converter.py](robust-rail-generator/src/scenario_generator/easy_converter.py) can be used to convert between the HIP and TORS formats.
- [robust-rail-generator/src/scenario_generator/config_explanation.md](robust-rail-generator/src/scenario_generator/config_explanation.md) explains the parameters of the scenario generation configuration files.
- [robust-rail-evaluator/doc/Description_TORS.md](robust-rail-evaluator/doc/Description_TORS.md) explains the TORS problem.
- [robust-rail-generator/data/locations/README.md](robust-rail-generator/data/locations/README.md) explains how to build a shunting location file.
- The package README files explain the setup of the different components:
    - [.devcontainer/README.md](.devcontainer/README.md)
    - [robust-rail-solver/README.md](robust-rail-solver/README.md)
    - [robust-rail-evaluator/README.md](robust-rail-evaluator/README.md)
    - [robust-rail-generator/README.md](robust-rail-generator/README.md)
    - [robust-rail-solver/ServiceSiteScheduling/README.md](robust-rail-solver/ServiceSiteScheduling/README.md)
