#  Code underlying the publication: Unidirectional and multi-directional wave estimation from ship motions using an Adaptive Kalman Filter with the inclusion of varying forward speed

 

## Description:
This repository provides a structured methodology for estimating directional sea state parameters using an Adaptive Kalman Filter (AKF) based on measured ship motion responses. The method incorporates the effect of **forward speed** and encounter frequency transformation, enabling more accurate real-time sea state reconstruction.

The code supports the academic article referenced below, where the full mathematical formulation and validation are presented:

---
## Purpose:

The objective is to estimate the **wave spectrum** and extract sea state parameters such as:
- Significant wave height ($H_s$)
- Peak period ($T_p$)
- Mean relative wave direction ($\beta$)

...by using ship motion measurements (e.g., heave, pitch, roll) and a physics-based state-space model enhanced with an **Adaptive Kalman filtering approach**.

---

## Features:

- Adaptive Kalman Filter for directional wave estimation.
- Inclusion of **ship forward speed** and encounter frequency correction.
- Uses transfer functions (RAOs) for each degree of freedom.
- Supports wave spectrum discretization via the **Equal Energy Method**.
- Outputs estimated sea state and time series of wave elevation.
---

## Project Structure:

```
├── results/                    # Input motion data files and generated results (plots functions, figures...)
├── src/                        # Source code for Sea State Estimation (SSE) and Adaptive Kalman Filter (AKF)
│   ├── analysis/               # Scripts for AKF algorithm and sea state estimation
│   ├── models/                 # RAO (Response Amplitude Operator) definitions
│   └── tools/                  # Utility functions (e.g., spectrum discretization, environmental conditions)
├── main.py                     # Main entry point for sea state parameter estimation
├── main_sim_doubleSum/         # Script to generate ship motion data using the double sum method
├── main_sim_equalEnergy/       # Script to generate ship motion data using the equal energy method
├── README.md                   # Project documentation
└── requirements.txt            # Python dependencies

```
---

## Inputs:

- Simulated ship motion data (heave, pitch, etc.)
- Transfer functions (RAO amplitudes and phases)
- Directional wave spectrum (eg., JONSWAP)
- Initial complex wave componets and AKF settings

> **Note:** The input data used in this project is **confidential** and not publicly distributed. This repository represents only the **main structure** of the proposed method.

---

## Outputs:

- Estimated directional wave spectrum.
- Estimated wave elevation at the vessel location.
- Estimated sea state parameters over time ($H_s$, $T_p$, $\beta$)
- Diagnostic plots comparing estimation vs ground truth
---

## Requirements

- Python 3.1+
- Install all dependencies using:
```bash
pip install -r requirements.txt
```

## References:
R. Bourkaib, M. Kok, H.C. Seyffert,
Unidirectional and multi-directional wave estimation from ship motions using an Adaptive Kalman Filter with the inclusion of varying forward speed,
Probabilistic Engineering Mechanics,
2025,
103773,
ISSN 0266-8920,
https://doi.org/10.1016/j.probengmech.2025.103773.

