
void skip_lines(std::ifstream& file, int skip_lines) {
    std::string temp;
    for(auto i = 0; i < skip_lines; i ++) {
        if (!std::getline(file, temp)) {
            std::cerr << "Failed to read or fewer lines in file." << std::endl;
        }
    }
}

template <typename T>
std::tuple<PG_Kernel<T>, Raytracer<T>> import_single(std::string foldername) {

    std::string filename = foldername + "/inputs.txt";
    std::ifstream file(filename);
    std::vector<std::string> inputs;
    std::vector<std::string> surface_inputs;
    std::string temp;
    std::string param_name, equal_sign, value, comment, unit;

    for(int i = 0; i < 60; i ++) {
        std::getline(file, temp);
        std::stringstream ss(temp);
        if(ss >> param_name >> equal_sign >> value) {
            inputs.push_back(value);
        }
    }
   
    std::string geometry_file = inputs[1].c_str();
    std::string surf_prop_file = inputs[2].c_str();

    Surface<T> surf(foldername + "/surface_files/" + geometry_file, foldername + "/surface_files/" + surf_prop_file);

    T offset_x = static_cast<T>(std::atof(inputs[3].c_str()));
    T offset_y = static_cast<T>(std::atof(inputs[4].c_str()));
    T offset_z = static_cast<T>(std::atof(inputs[5].c_str()));
    T rotation_x = static_cast<T>(std::atof(inputs[6].c_str()));
    T rotation_y = static_cast<T>(std::atof(inputs[7].c_str()));
    T rotation_z = static_cast<T>(std::atof(inputs[8].c_str()));
    T surf_temp = static_cast<T>(std::atof(inputs[9].c_str()));

    T gas_molar_mass = static_cast<T>(std::atof(inputs[11].c_str()));
    T gas_temperature = static_cast<T>(std::atof(inputs[12].c_str()));
    T gas_speed = static_cast<T>(std::atof(inputs[13].c_str()));

    void (*local_kernel)(T*, T*, T*, T*, T*);

    T GSI_parameters[3];
    GSI_parameters[0] = static_cast<T>(std::atof(inputs[15].c_str()));
    GSI_parameters[1] = static_cast<T>(std::atof(inputs[16].c_str()));

    long num_particles = static_cast<long>(std::atof(inputs[18].c_str()));

    T incidence_angle = static_cast<T>(std::atof(inputs[19].c_str())) * M_PI / 180.0;

    local_kernel = sample_CLL;

    T offset[4] = {offset_x, offset_y, offset_z};

    surf.get_geometry().rotate(0, rotation_x * M_PI / 180.0);
    surf.get_geometry().rotate(1, rotation_y * M_PI / 180.0);
    surf.get_geometry().rotate(2, rotation_z * M_PI / 180.0);
    surf.get_geometry().shift(offset);
    surf.get_geometry().add_surface_property("temperature", surf_temp);
    surf.get_geometry().add_GSI_property("alpha_n", GSI_parameters[0]);
    surf.get_geometry().add_GSI_property("sigma_t", GSI_parameters[1]);
    surf.get_local_parameters()[0] = surf_temp;
    surf.get_local_parameters()[1] = GSI_parameters[0];
    surf.get_local_parameters()[2] = GSI_parameters[1];
    
    Gas<T> atmosphere(1.0, gas_temperature, gas_molar_mass, gas_speed);

    Matrix<T> incident_velocity(3, 1, {std::sin(incidence_angle) * gas_speed, 0.0, - std::cos(incidence_angle) * gas_speed});
   
    PG_Kernel<T> kernel(surf, atmosphere, local_kernel, incident_velocity, num_particles, "single");
    Raytracer<T> raytracer(surf, atmosphere, local_kernel, incident_velocity, num_particles, "single");

    return std::make_tuple(kernel, raytracer);
}


template <typename T>
std::tuple<std::vector<PG_Kernel<T>>, std::vector<Raytracer<T>>> import_batch(std::string foldername) {

    std::string filename = foldername + "/inputs.txt";
    std::ifstream file(filename);
    std::vector<std::string> inputs;
    std::vector<std::string> surface_inputs;
    std::string temp;
    std::string param_name, equal_sign, value, comment, unit;

    for(int i = 0; i < 60; i ++) {
        std::getline(file, temp);
        std::stringstream ss(temp);
        if(ss >> param_name >> equal_sign >> value) {
            inputs.push_back(value);
        }
    }
   
    std::string geometry_file = inputs[1].c_str();
    std::string surf_prop_file = inputs[2].c_str();

    T offset_x = static_cast<T>(std::atof(inputs[3].c_str()));
    T offset_y = static_cast<T>(std::atof(inputs[4].c_str()));
    T offset_z = static_cast<T>(std::atof(inputs[5].c_str()));
    T rotation_x = static_cast<T>(std::atof(inputs[6].c_str()));
    T rotation_y = static_cast<T>(std::atof(inputs[7].c_str()));
    T rotation_z = static_cast<T>(std::atof(inputs[8].c_str()));
    T surf_temp = static_cast<T>(std::atof(inputs[9].c_str()));

    T gas_molar_mass = static_cast<T>(std::atof(inputs[11].c_str()));
    T gas_temperature = static_cast<T>(std::atof(inputs[12].c_str()));
    T gas_speed = static_cast<T>(std::atof(inputs[13].c_str()));

    void (*local_kernel)(T*, T*, T*, T*, T*);

    T GSI_parameters[3];
    GSI_parameters[0] = static_cast<T>(std::atof(inputs[15].c_str()));
    GSI_parameters[1] = static_cast<T>(std::atof(inputs[16].c_str()));

    long num_particles = static_cast<long>(std::atof(inputs[18].c_str()));

    T incidence_angle = static_cast<T>(std::atof(inputs[19].c_str()));

    T incidence_angle_start = static_cast<T>(std::atof(inputs[21].c_str())) * M_PI / 180.0;
    T incidence_angle_end = static_cast<T>(std::atof(inputs[22].c_str())) * M_PI / 180.0;
    T incidence_angle_step = static_cast<T>(std::atof(inputs[23].c_str())) * M_PI / 180.0;

    T alpha_n_start = static_cast<T>(std::atof(inputs[24].c_str()));
    T alpha_n_end = static_cast<T>(std::atof(inputs[25].c_str()));
    T alpha_n_step = static_cast<T>(std::atof(inputs[26].c_str()));

    T sigma_t_start = static_cast<T>(std::atof(inputs[27].c_str()));
    T sigma_t_end = static_cast<T>(std::atof(inputs[28].c_str()));
    T sigma_t_step = static_cast<T>(std::atof(inputs[29].c_str()));

    local_kernel = sample_CLL;

    std::vector<PG_Kernel<T>> kernels;
    std::vector<Raytracer<T>> raytracers;

    for(long i = 0; i <= (long)((incidence_angle_end - incidence_angle_start) / incidence_angle_step); i ++) {
        for(long j = 0; j <= (long)((alpha_n_end - alpha_n_start) / alpha_n_step); j ++) {
            for(long k = 0; k <= (long)((sigma_t_end - sigma_t_start) / sigma_t_step); k ++) {

                T incidence_angle_local = incidence_angle_start + (T)(i) * incidence_angle_step;
                T alpha_n_local = alpha_n_start + (T)(j) * alpha_n_step;
                T sigma_t_local = sigma_t_start + (T)(k) * sigma_t_step;

                Surface<T> surf(foldername + "/surface_files/" + geometry_file, foldername + "/surface_files/" + surf_prop_file);

                T offset[4] = {offset_x, offset_y, offset_z};

                surf.get_geometry().rotate(0, rotation_x * M_PI / 180.0);
                surf.get_geometry().rotate(1, rotation_y * M_PI / 180.0);
                surf.get_geometry().rotate(2, rotation_z * M_PI / 180.0);
                surf.get_geometry().shift(offset);
                surf.get_geometry().add_surface_property("temperature", surf_temp);
                surf.get_geometry().add_GSI_property("alpha_n", alpha_n_local);
                surf.get_geometry().add_GSI_property("sigma_t", sigma_t_local);
                surf.get_local_parameters()[0] = surf_temp;
                surf.get_local_parameters()[1] = alpha_n_local;
                surf.get_local_parameters()[2] = sigma_t_local;
                
                Gas<T> atmosphere(1.0, gas_temperature, gas_molar_mass, gas_speed);

                Matrix<T> incident_velocity(3, 1, {std::sin(incidence_angle_local) * gas_speed, 0.0, - std::cos(incidence_angle_local) * gas_speed});

                std::stringstream stream;
                stream << std::fixed << std::setprecision(2) << "theta_i_" << incidence_angle_local * 180.0 / M_PI << "_alpha_n_" << 
                        alpha_n_local << "_sigma_t_" << sigma_t_local;

                PG_Kernel<T> kernel(surf, atmosphere, local_kernel, incident_velocity, num_particles, stream.str());
                Raytracer<T> raytracer(surf, atmosphere, local_kernel, incident_velocity, num_particles, stream.str());
                kernels.push_back(kernel);
                raytracers.push_back(raytracer);
            }
        }
    }

    

    return std::make_tuple(kernels, raytracers);
}