
function cm = viko(n, varargin)
% Colormap: viko

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.309793908	0.100897207	0.238434037
	0.306924641	0.103056803	0.243182618
	0.304062940	0.105260033	0.248048227
	0.301206319	0.107641727	0.252960415
	0.298356560	0.110165464	0.257955995
	0.295505863	0.112760959	0.263073745
	0.292652303	0.115445943	0.268249976
	0.289796970	0.118319698	0.273541358
	0.286922584	0.121219994	0.278905492
	0.284058849	0.124314735	0.284343935
	0.281175542	0.127532693	0.289889726
	0.278303906	0.130892858	0.295517985
	0.275415214	0.134348669	0.301232048
	0.272488881	0.137934151	0.307043808
	0.269596384	0.141626169	0.312929697
	0.266659830	0.145480064	0.318904767
	0.263743299	0.149424621	0.324946579
	0.260788132	0.153481836	0.331073815
	0.257831213	0.157708529	0.337294032
	0.254905716	0.162084622	0.343564635
	0.251944797	0.166548898	0.349913974
	0.248988995	0.171142086	0.356325429
	0.246023639	0.175855924	0.362785856
	0.243081604	0.180726403	0.369314132
	0.240154945	0.185754938	0.375890706
	0.237283048	0.190836366	0.382507488
	0.234392504	0.196092022	0.389177594
	0.231550853	0.201425958	0.395877013
	0.228747557	0.206943556	0.402593578
	0.225999710	0.212529935	0.409350205
	0.223307331	0.218249859	0.416117330
	0.220709825	0.224061707	0.422891901
	0.218170283	0.229997523	0.429687848
	0.215755382	0.236076144	0.436479095
	0.213434195	0.242216716	0.443264023
	0.211280091	0.248489209	0.450037734
	0.209250417	0.254840506	0.456795626
	0.207408230	0.261270589	0.463536560
	0.205742916	0.267789334	0.470264325
	0.204294411	0.274425580	0.476951624
	0.203032297	0.281125414	0.483608809
	0.202026145	0.287915442	0.490242580
	0.201285317	0.294777887	0.496827974
	0.200827243	0.301710181	0.503377433
	0.200666746	0.308736376	0.509892838
	0.200819079	0.315806388	0.516355939
	0.201299892	0.322936745	0.522784800
	0.202125192	0.330124664	0.529167017
	0.203309782	0.337371383	0.535485877
	0.204842355	0.344664578	0.541769020
	0.206756324	0.352009926	0.548014230
	0.209001222	0.359413197	0.554202138
	0.211661402	0.366859288	0.560345631
	0.214658362	0.374347365	0.566442394
	0.218058716	0.381861083	0.572494811
	0.221805267	0.389424221	0.578493412
	0.225949135	0.397012128	0.584457017
	0.230400095	0.404640297	0.590370115
	0.235255339	0.412310758	0.596247409
	0.240385424	0.419990272	0.602077093
	0.245884716	0.427705551	0.607872906
	0.251718976	0.435439797	0.613609831
	0.257815141	0.443188870	0.619327952
	0.264244488	0.450959166	0.624986960
	0.270944706	0.458745864	0.630616483
	0.277910234	0.466545955	0.636198459
	0.285126215	0.474357736	0.641734471
	0.292615129	0.482176753	0.647237534
	0.300336390	0.489993419	0.652688378
	0.308292163	0.497830541	0.658107432
	0.316470562	0.505635346	0.663476411
	0.324835913	0.513465604	0.668791955
	0.333431867	0.521272075	0.674058751
	0.342198961	0.529079473	0.679273499
	0.351151993	0.536863152	0.684434776
	0.360264668	0.544620083	0.689547909
	0.369558505	0.552363102	0.694582745
	0.379006139	0.560074611	0.699562617
	0.388606265	0.567750257	0.704473405
	0.398342115	0.575392158	0.709312460
	0.408207532	0.582984800	0.714061870
	0.418197713	0.590534320	0.718732363
	0.428316836	0.598029092	0.723310982
	0.438534830	0.605463187	0.727795456
	0.448867108	0.612830984	0.732180172
	0.459282183	0.620135734	0.736442449
	0.469788332	0.627344299	0.740595074
	0.480359968	0.634476616	0.744620521
	0.491018563	0.641500031	0.748513057
	0.501718886	0.648430625	0.752259542
	0.512468389	0.655247611	0.755858021
	0.523270774	0.661953519	0.759290103
	0.534088265	0.668519687	0.762556165
	0.544938807	0.674947370	0.765647533
	0.555783331	0.681226718	0.768535946
	0.566644474	0.687359084	0.771238283
	0.577471869	0.693320654	0.773716661
	0.588275547	0.699099018	0.775983723
	0.599048767	0.704697871	0.778018852
	0.609756469	0.710098401	0.779808587
	0.620405990	0.715290343	0.781352518
	0.630964108	0.720259845	0.782630704
	0.641417527	0.725008163	0.783643569
	0.651774559	0.729510374	0.784376641
	0.661998095	0.733766411	0.784818005
	0.672071286	0.737761099	0.784964429
	0.681984585	0.741490886	0.784808631
	0.691734254	0.744947191	0.784344002
	0.701285767	0.748120494	0.783559276
	0.710637588	0.750999633	0.782456337
	0.719766231	0.753570564	0.781029651
	0.728655656	0.755844625	0.779275203
	0.737301172	0.757805991	0.777198440
	0.745681975	0.759446841	0.774779103
	0.753790168	0.760778792	0.772041235
	0.761608218	0.761780422	0.768968472
	0.769129548	0.762462467	0.765581419
	0.776349567	0.762821501	0.761860236
	0.783246950	0.762857525	0.757832068
	0.789824495	0.762572091	0.753486637
	0.796069082	0.761968042	0.748840836
	0.801982241	0.761051781	0.743900911
	0.807559464	0.759818173	0.738672259
	0.812790417	0.758288288	0.733164023
	0.817683362	0.756451219	0.727384922
	0.822239988	0.754327749	0.721348430
	0.826448980	0.751914817	0.715071069
	0.830322674	0.749220443	0.708557927
	0.833863604	0.746267454	0.701808818
	0.837071262	0.743057377	0.694857173
	0.839957396	0.739595494	0.687707098
	0.842522359	0.735881081	0.680358931
	0.844774749	0.731953043	0.672848964
	0.846720474	0.727794897	0.665157591
	0.848375463	0.723429103	0.657325400
	0.849743966	0.718865838	0.649342664
	0.850824407	0.714108876	0.641219103
	0.851641369	0.709178271	0.632987898
	0.852200241	0.704063880	0.624639218
	0.852501823	0.698788770	0.616187658
	0.852559159	0.693366144	0.607647646
	0.852382503	0.687792421	0.599014407
	0.851977123	0.682075735	0.590302873
	0.851351324	0.676237875	0.581529643
	0.850523852	0.670275735	0.572701278
	0.849497320	0.664185854	0.563812102
	0.848269089	0.657993379	0.554867323
	0.846856854	0.651690872	0.545892062
	0.845268481	0.645281054	0.536876949
	0.843501585	0.638785845	0.527819001
	0.841573484	0.632196449	0.518752935
	0.839479808	0.625516153	0.509649850
	0.837227265	0.618760692	0.500534902
	0.834819313	0.611908085	0.491420236
	0.832263827	0.604986040	0.482276131
	0.829562708	0.597982286	0.473123267
	0.826715032	0.590908018	0.463992634
	0.823723502	0.583758723	0.454850078
	0.820595076	0.576547456	0.445696585
	0.817329754	0.569242398	0.436574533
	0.813924676	0.561888525	0.427457585
	0.810382893	0.554450666	0.418335477
	0.806711385	0.546945476	0.409251214
	0.802891029	0.539365617	0.400180789
	0.798941778	0.531724762	0.391138398
	0.794848283	0.524008692	0.382105219
	0.790615547	0.516215363	0.373117373
	0.786247824	0.508373026	0.364161530
	0.781732030	0.500434476	0.355262140
	0.777074667	0.492434528	0.346370192
	0.772265266	0.484363577	0.337552192
	0.767311904	0.476231571	0.328784833
	0.762212703	0.468018379	0.320075528
	0.756966312	0.459744626	0.311414312
	0.751572326	0.451403544	0.302832020
	0.746016692	0.442995839	0.294338986
	0.740318342	0.434520620	0.285926394
	0.734467634	0.425985802	0.277632679
	0.728461953	0.417409786	0.269432638
	0.722309342	0.408764684	0.261326057
	0.716021872	0.400078423	0.253359913
	0.709579660	0.391359316	0.245505267
	0.702999518	0.382588638	0.237836432
	0.696284284	0.373805260	0.230275244
	0.689440579	0.364987807	0.222933158
	0.682464441	0.356174785	0.215739890
	0.675380227	0.347351638	0.208729058
	0.668189723	0.338518511	0.201918960
	0.660887215	0.329729555	0.195346519
	0.653502119	0.320947970	0.188997644
	0.646036842	0.312187539	0.182858188
	0.638504089	0.303505187	0.177002038
	0.630916439	0.294878025	0.171379825
	0.623278425	0.286317790	0.166022969
	0.615601139	0.277866226	0.160968300
	0.607918961	0.269500979	0.156190752
	0.600216343	0.261224428	0.151648656
	0.592533061	0.253083694	0.147456499
	0.584857193	0.245049568	0.143533222
	0.577214751	0.237213113	0.139876379
	0.569614347	0.229457621	0.136559865
	0.562086858	0.221899564	0.133557016
	0.554609230	0.214514025	0.130838561
	0.547212707	0.207308716	0.128376960
	0.539904284	0.200249242	0.126228977
	0.532704145	0.193438751	0.124313889
	0.525599117	0.186790661	0.122693060
	0.518615189	0.180343452	0.121354806
	0.511736813	0.174126793	0.120283376
	0.504996217	0.168092897	0.119460293
	0.498392471	0.162313847	0.118887241
	0.491910074	0.156717774	0.118529879
	0.485559260	0.151322838	0.118380292
	0.479365282	0.146178831	0.118440538
	0.473292909	0.141262336	0.118696334
	0.467385541	0.136499388	0.119128086
	0.461606180	0.132028702	0.119742548
	0.455965113	0.127738731	0.120540070
	0.450469844	0.123640151	0.121503182
	0.445109811	0.119800653	0.122633167
	0.439885122	0.116198808	0.123926504
	0.434794927	0.112774312	0.125383641
	0.429828629	0.109562953	0.126918094
	0.424995862	0.106542827	0.128630240
	0.420274501	0.103705928	0.130494887
	0.415679474	0.101055905	0.132411072
	0.411199310	0.098655324	0.134487338
	0.406829126	0.096378229	0.136617489
	0.402559264	0.094420204	0.138902711
	0.398404354	0.092522924	0.141317968
	0.394333722	0.090891824	0.143788188
	0.390360464	0.089395932	0.146355185
	0.386473268	0.088089587	0.149036652
	0.382681080	0.086971465	0.151797867
	0.378962262	0.085914937	0.154662983
	0.375314766	0.085142469	0.157608016
	0.371741680	0.084548791	0.160643093
	0.368247788	0.084070040	0.163800761
	0.364801673	0.083716750	0.166997027
	0.361424912	0.083520865	0.170268399
	0.358103909	0.083485078	0.173627583
	0.354839589	0.083605387	0.177086264
	0.351599248	0.083878241	0.180596276
	0.348426299	0.084281339	0.184215527
	0.345287123	0.084781030	0.187934950
	0.342192249	0.085387384	0.191667204
	0.339133145	0.086178677	0.195515423
	0.336087134	0.087176021	0.199428641
	0.333098737	0.088189870	0.203460250
	0.330116579	0.089356388	0.207546041
	0.327150489	0.090651792	0.211724348
	0.324218620	0.092078353	0.215974995
	0.321307976	0.093564401	0.220305810
	0.318411068	0.095269471	0.224678952
	0.315531128	0.096976479	0.229196932
	0.312640206	0.098899286	0.233766596
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
