
function cm = turbo(n, varargin)
% Colormap: turbo

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.189950000	0.071760000	0.232170000
	0.194830000	0.083390000	0.261490000
	0.199560000	0.094980000	0.290240000
	0.204150000	0.106520000	0.318440000
	0.208600000	0.118020000	0.346070000
	0.212910000	0.129470000	0.373140000
	0.217080000	0.140870000	0.399640000
	0.221110000	0.152230000	0.425580000
	0.225000000	0.163540000	0.450960000
	0.228750000	0.174810000	0.475780000
	0.232360000	0.186030000	0.500040000
	0.235820000	0.197200000	0.523730000
	0.239150000	0.208330000	0.546860000
	0.242340000	0.219410000	0.569420000
	0.245390000	0.230440000	0.591420000
	0.248300000	0.241430000	0.612860000
	0.251070000	0.252370000	0.633740000
	0.253690000	0.263270000	0.654060000
	0.256180000	0.274120000	0.673810000
	0.258530000	0.284920000	0.693000000
	0.260740000	0.295680000	0.711620000
	0.262800000	0.306390000	0.729680000
	0.264730000	0.317060000	0.747180000
	0.266520000	0.327680000	0.764120000
	0.268160000	0.338250000	0.780500000
	0.269670000	0.348780000	0.796310000
	0.271030000	0.359260000	0.811560000
	0.272260000	0.369700000	0.826240000
	0.273340000	0.380080000	0.840370000
	0.274290000	0.390430000	0.853930000
	0.275090000	0.400720000	0.866920000
	0.275760000	0.410970000	0.879360000
	0.276280000	0.421180000	0.891230000
	0.276670000	0.431340000	0.902540000
	0.276910000	0.441450000	0.913280000
	0.277010000	0.451520000	0.923470000
	0.276980000	0.461530000	0.933090000
	0.276800000	0.471510000	0.942140000
	0.276480000	0.481440000	0.950640000
	0.276030000	0.491320000	0.958570000
	0.275430000	0.501150000	0.965940000
	0.274690000	0.510940000	0.972750000
	0.273810000	0.520690000	0.978990000
	0.272730000	0.530400000	0.984610000
	0.271060000	0.540150000	0.989300000
	0.268780000	0.549950000	0.993030000
	0.265920000	0.559790000	0.995830000
	0.262520000	0.569670000	0.997730000
	0.258620000	0.579580000	0.998760000
	0.254250000	0.589500000	0.998960000
	0.249460000	0.599430000	0.998350000
	0.244270000	0.609370000	0.996970000
	0.238740000	0.619310000	0.994850000
	0.232880000	0.629230000	0.992020000
	0.226760000	0.639130000	0.988510000
	0.220390000	0.649010000	0.984360000
	0.213820000	0.658860000	0.979590000
	0.207080000	0.668660000	0.974230000
	0.200210000	0.678420000	0.968330000
	0.193260000	0.688120000	0.961900000
	0.186250000	0.697750000	0.954980000
	0.179230000	0.707320000	0.947610000
	0.172230000	0.716800000	0.939810000
	0.165290000	0.726200000	0.931610000
	0.158440000	0.735510000	0.923050000
	0.151730000	0.744720000	0.914160000
	0.145190000	0.753810000	0.904960000
	0.138860000	0.762790000	0.895500000
	0.132780000	0.771650000	0.885800000
	0.126980000	0.780370000	0.875900000
	0.121510000	0.788960000	0.865810000
	0.116390000	0.797400000	0.855590000
	0.111670000	0.805690000	0.845250000
	0.107380000	0.813810000	0.834840000
	0.103570000	0.821770000	0.824370000
	0.100260000	0.829550000	0.813890000
	0.097500000	0.837140000	0.803420000
	0.095320000	0.844550000	0.792990000
	0.093770000	0.851750000	0.782640000
	0.092870000	0.858750000	0.772400000
	0.092670000	0.865540000	0.762300000
	0.093200000	0.872110000	0.752370000
	0.094510000	0.878440000	0.742650000
	0.096620000	0.884540000	0.733160000
	0.099580000	0.890400000	0.723930000
	0.103420000	0.896000000	0.715000000
	0.108150000	0.901420000	0.705990000
	0.113740000	0.906730000	0.696510000
	0.120140000	0.911930000	0.686600000
	0.127330000	0.917010000	0.676270000
	0.135260000	0.921970000	0.665560000
	0.143910000	0.926800000	0.654480000
	0.153230000	0.931510000	0.643080000
	0.163190000	0.936090000	0.631370000
	0.173770000	0.940530000	0.619380000
	0.184910000	0.944840000	0.607130000
	0.196590000	0.949010000	0.594660000
	0.208770000	0.953040000	0.581990000
	0.221420000	0.956920000	0.569140000
	0.234490000	0.960650000	0.556140000
	0.247970000	0.964230000	0.543030000
	0.261800000	0.967650000	0.529810000
	0.275970000	0.970920000	0.516530000
	0.290420000	0.974030000	0.503210000
	0.305130000	0.976970000	0.489870000
	0.320060000	0.979740000	0.476540000
	0.335170000	0.982340000	0.463250000
	0.350430000	0.984770000	0.450020000
	0.365810000	0.987020000	0.436880000
	0.381270000	0.989090000	0.423860000
	0.396780000	0.990980000	0.410980000
	0.412290000	0.992680000	0.398260000
	0.427780000	0.994190000	0.385750000
	0.443210000	0.995510000	0.373450000
	0.458540000	0.996630000	0.361400000
	0.473750000	0.997550000	0.349630000
	0.488790000	0.998280000	0.338160000
	0.503620000	0.998790000	0.327010000
	0.518220000	0.999100000	0.316220000
	0.532550000	0.999190000	0.305810000
	0.546580000	0.999070000	0.295810000
	0.560260000	0.998730000	0.286230000
	0.573570000	0.998170000	0.277120000
	0.586460000	0.997390000	0.268490000
	0.598910000	0.996380000	0.260380000
	0.610880000	0.995140000	0.252800000
	0.622330000	0.993660000	0.245790000
	0.633230000	0.991950000	0.239370000
	0.643620000	0.989990000	0.233560000
	0.653940000	0.987750000	0.228350000
	0.664280000	0.985240000	0.223700000
	0.674620000	0.982460000	0.219600000
	0.684940000	0.979410000	0.216020000
	0.695250000	0.976100000	0.212940000
	0.705530000	0.972550000	0.210320000
	0.715770000	0.968750000	0.208150000
	0.725960000	0.964700000	0.206400000
	0.736100000	0.960430000	0.205040000
	0.746170000	0.955930000	0.204060000
	0.756170000	0.951210000	0.203430000
	0.766080000	0.946270000	0.203110000
	0.775910000	0.941130000	0.203100000
	0.785630000	0.935790000	0.203360000
	0.795240000	0.930250000	0.203860000
	0.804730000	0.924520000	0.204590000
	0.814100000	0.918610000	0.205520000
	0.823330000	0.912530000	0.206630000
	0.832410000	0.906270000	0.207880000
	0.841330000	0.899860000	0.209260000
	0.850100000	0.893280000	0.210740000
	0.858680000	0.886550000	0.212300000
	0.867090000	0.879680000	0.213910000
	0.875300000	0.872670000	0.215550000
	0.883310000	0.865530000	0.217190000
	0.891120000	0.858260000	0.218800000
	0.898700000	0.850870000	0.220380000
	0.906050000	0.843370000	0.221880000
	0.913170000	0.835760000	0.223280000
	0.920040000	0.828060000	0.224560000
	0.926660000	0.820250000	0.225700000
	0.933010000	0.812360000	0.226670000
	0.939090000	0.804390000	0.227440000
	0.944890000	0.796340000	0.228000000
	0.950390000	0.788230000	0.228310000
	0.955600000	0.780050000	0.228360000
	0.960490000	0.771810000	0.228110000
	0.965070000	0.763520000	0.227540000
	0.969310000	0.755190000	0.226630000
	0.973230000	0.746820000	0.225360000
	0.976790000	0.738420000	0.223690000
	0.980000000	0.730000000	0.221610000
	0.982890000	0.721400000	0.219180000
	0.985490000	0.712500000	0.216500000
	0.987810000	0.703300000	0.213580000
	0.989860000	0.693820000	0.210430000
	0.991630000	0.684080000	0.207060000
	0.993140000	0.674080000	0.203480000
	0.994380000	0.663860000	0.199710000
	0.995350000	0.653410000	0.195770000
	0.996070000	0.642770000	0.191650000
	0.996540000	0.631930000	0.187380000
	0.996750000	0.620930000	0.182970000
	0.996720000	0.609770000	0.178420000
	0.996440000	0.598460000	0.173760000
	0.995930000	0.587030000	0.168990000
	0.995170000	0.575490000	0.164120000
	0.994190000	0.563860000	0.159180000
	0.992970000	0.552140000	0.154170000
	0.991530000	0.540360000	0.149100000
	0.989870000	0.528540000	0.143980000
	0.987990000	0.516670000	0.138830000
	0.985900000	0.504790000	0.133670000
	0.983600000	0.492910000	0.128490000
	0.981080000	0.481040000	0.123320000
	0.978370000	0.469200000	0.118170000
	0.975450000	0.457400000	0.113050000
	0.972340000	0.445650000	0.107970000
	0.969040000	0.433990000	0.102940000
	0.965550000	0.422410000	0.097980000
	0.961870000	0.410930000	0.093100000
	0.958010000	0.399580000	0.088310000
	0.953980000	0.388360000	0.083620000
	0.949770000	0.377290000	0.079050000
	0.945380000	0.366380000	0.074610000
	0.940840000	0.355660000	0.070310000
	0.936120000	0.345130000	0.066160000
	0.931250000	0.334820000	0.062180000
	0.926230000	0.324730000	0.058370000
	0.921050000	0.314890000	0.054750000
	0.915720000	0.305300000	0.051340000
	0.910240000	0.295990000	0.048140000
	0.904630000	0.286960000	0.045160000
	0.898880000	0.278240000	0.042430000
	0.892980000	0.269810000	0.039930000
	0.886910000	0.261520000	0.037530000
	0.880660000	0.253340000	0.035210000
	0.874220000	0.245260000	0.032970000
	0.867600000	0.237300000	0.030820000
	0.860790000	0.229450000	0.028750000
	0.853800000	0.221700000	0.026770000
	0.846620000	0.214070000	0.024870000
	0.839260000	0.206540000	0.023050000
	0.831720000	0.199120000	0.021310000
	0.823990000	0.191820000	0.019660000
	0.816080000	0.184620000	0.018090000
	0.807990000	0.177530000	0.016600000
	0.799710000	0.170550000	0.015200000
	0.791250000	0.163680000	0.013870000
	0.782600000	0.156930000	0.012640000
	0.773770000	0.150280000	0.011480000
	0.764760000	0.143740000	0.010410000
	0.755560000	0.137310000	0.009420000
	0.746170000	0.130980000	0.008510000
	0.736610000	0.124770000	0.007690000
	0.726860000	0.118670000	0.006950000
	0.716920000	0.112680000	0.006290000
	0.706800000	0.106800000	0.005710000
	0.696500000	0.101020000	0.005220000
	0.686020000	0.095360000	0.004810000
	0.675350000	0.089800000	0.004490000
	0.664490000	0.084360000	0.004240000
	0.653450000	0.079020000	0.004080000
	0.642230000	0.073800000	0.004010000
	0.630820000	0.068680000	0.004010000
	0.619230000	0.063670000	0.004100000
	0.607460000	0.058780000	0.004270000
	0.595500000	0.053990000	0.004530000
	0.583360000	0.049310000	0.004860000
	0.571030000	0.044740000	0.005290000
	0.558520000	0.040280000	0.005790000
	0.545830000	0.035930000	0.006380000
	0.532950000	0.031690000	0.007050000
	0.519890000	0.027560000	0.007800000
	0.506640000	0.023540000	0.008630000
	0.493210000	0.019630000	0.009550000
	0.479600000	0.015830000	0.010550000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
