
function cm = tokyo(n, varargin)
% Colormap: tokyo

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.103873577	0.056805137	0.202430165
	0.109754454	0.059104265	0.205635472
	0.115663416	0.061045788	0.208843079
	0.121597815	0.063055444	0.212091509
	0.127574763	0.064934620	0.215311545
	0.133514659	0.066895406	0.218580874
	0.139386336	0.068938698	0.221839715
	0.145346340	0.070893865	0.225121658
	0.151192730	0.072938105	0.228452638
	0.157077228	0.074969577	0.231770531
	0.162979372	0.077037935	0.235110479
	0.168863448	0.079187975	0.238435077
	0.174746199	0.081434616	0.241823121
	0.180609215	0.083638600	0.245193726
	0.186520300	0.085842523	0.248633325
	0.192424724	0.088221238	0.252056378
	0.198334178	0.090586269	0.255503128
	0.204293363	0.092948661	0.258980121
	0.210211246	0.095478962	0.262460832
	0.216185840	0.098018401	0.265979356
	0.222123919	0.100564047	0.269514901
	0.228120990	0.103253187	0.273058092
	0.234096443	0.105964744	0.276636162
	0.240087452	0.108707972	0.280212391
	0.246100914	0.111593627	0.283828472
	0.252139406	0.114453284	0.287452352
	0.258152612	0.117464121	0.291116629
	0.264209650	0.120518715	0.294769146
	0.270259480	0.123649180	0.298453565
	0.276306971	0.126865238	0.302145415
	0.282355530	0.130211468	0.305883594
	0.288386754	0.133541030	0.309604705
	0.294424478	0.136972631	0.313330988
	0.300463111	0.140494348	0.317072256
	0.306505829	0.144082713	0.320831820
	0.312496492	0.147750185	0.324572169
	0.318503637	0.151468313	0.328340029
	0.324469580	0.155292350	0.332106716
	0.330423725	0.159176320	0.335860175
	0.336336994	0.163148317	0.339626165
	0.342232021	0.167174579	0.343368634
	0.348075780	0.171243641	0.347113877
	0.353869243	0.175399157	0.350843096
	0.359631065	0.179615225	0.354553544
	0.365331156	0.183888623	0.358243611
	0.370971855	0.188248032	0.361924638
	0.376572764	0.192607070	0.365572743
	0.382076986	0.197055088	0.369202432
	0.387525080	0.201501206	0.372794326
	0.392901594	0.206057345	0.376375574
	0.398203757	0.210594920	0.379900231
	0.403416478	0.215176326	0.383403854
	0.408536142	0.219817122	0.386848170
	0.413573616	0.224433607	0.390266416
	0.418506961	0.229126503	0.393641304
	0.423351224	0.233801474	0.396963646
	0.428105118	0.238503926	0.400253271
	0.432749861	0.243215040	0.403484104
	0.437290286	0.247962243	0.406657803
	0.441721463	0.252674361	0.409786036
	0.446033784	0.257394241	0.412860493
	0.450255658	0.262113542	0.415865810
	0.454364909	0.266820715	0.418823467
	0.458351733	0.271519945	0.421720354
	0.462233711	0.276235992	0.424573486
	0.466002331	0.280883373	0.427366106
	0.469676743	0.285545196	0.430087397
	0.473210420	0.290188981	0.432760422
	0.476658944	0.294809372	0.435374859
	0.479995256	0.299420716	0.437927922
	0.483211263	0.303978664	0.440413327
	0.486331544	0.308535215	0.442859159
	0.489342174	0.313046044	0.445236469
	0.492258648	0.317536752	0.447556281
	0.495074393	0.321995987	0.449837003
	0.497793813	0.326417124	0.452060998
	0.500398609	0.330818604	0.454222773
	0.502918777	0.335209941	0.456330727
	0.505350559	0.339544876	0.458394728
	0.507705698	0.343833580	0.460402613
	0.509958448	0.348118860	0.462372622
	0.512131861	0.352358199	0.464306600
	0.514235068	0.356581657	0.466168237
	0.516239000	0.360747526	0.467999972
	0.518191304	0.364909483	0.469799737
	0.520049701	0.369041717	0.471546415
	0.521848370	0.373130335	0.473241318
	0.523590784	0.377205193	0.474928596
	0.525257165	0.381250425	0.476555600
	0.526870175	0.385250246	0.478153683
	0.528413887	0.389248394	0.479726418
	0.529904961	0.393206002	0.481251181
	0.531340762	0.397142616	0.482757340
	0.532730522	0.401074614	0.484226464
	0.534059096	0.404954376	0.485673300
	0.535350401	0.408830617	0.487099311
	0.536606440	0.412692098	0.488491939
	0.537809643	0.416516680	0.489853241
	0.538969622	0.420325523	0.491214557
	0.540090484	0.424120109	0.492521365
	0.541177670	0.427905968	0.493828758
	0.542237829	0.431673074	0.495113933
	0.543262165	0.435417441	0.496366887
	0.544252486	0.439136401	0.497628285
	0.545216850	0.442864149	0.498851371
	0.546158093	0.446565205	0.500055485
	0.547061850	0.450259225	0.501263884
	0.547950215	0.453939452	0.502440903
	0.548817404	0.457607427	0.503608968
	0.549654652	0.461272081	0.504773453
	0.550475800	0.464923290	0.505906216
	0.551279253	0.468564313	0.507046782
	0.552068035	0.472204756	0.508178795
	0.552830381	0.475831016	0.509285968
	0.553581267	0.479450836	0.510385496
	0.554326432	0.483057605	0.511479078
	0.555048368	0.486668606	0.512567067
	0.555755422	0.490273648	0.513651640
	0.556461779	0.493870573	0.514722005
	0.557162282	0.497470039	0.515775614
	0.557834919	0.501057434	0.516843429
	0.558500233	0.504646989	0.517897492
	0.559168279	0.508232167	0.518945357
	0.559828777	0.511802107	0.519973766
	0.560474170	0.515379728	0.521015283
	0.561111940	0.518967373	0.522039109
	0.561754246	0.522534533	0.523076782
	0.562388052	0.526114675	0.524095523
	0.563010964	0.529687655	0.525114344
	0.563632900	0.533254731	0.526132607
	0.564247180	0.536837222	0.527144480
	0.564852871	0.540402564	0.528147677
	0.565462846	0.543975541	0.529160208
	0.566077045	0.547547480	0.530156926
	0.566688985	0.551124215	0.531155690
	0.567294311	0.554699838	0.532155745
	0.567894837	0.558268776	0.533146648
	0.568496345	0.561858986	0.534136384
	0.569099211	0.565427257	0.535129391
	0.569702934	0.569012032	0.536119781
	0.570308379	0.572605052	0.537114880
	0.570915857	0.576196242	0.538100561
	0.571525758	0.579782645	0.539078971
	0.572139949	0.583367235	0.540059434
	0.572756631	0.586963833	0.541041761
	0.573370995	0.590563034	0.542024470
	0.573985942	0.594169528	0.543011822
	0.574607991	0.597776531	0.543989634
	0.575243764	0.601388217	0.544971631
	0.575887647	0.605007250	0.545957925
	0.576530658	0.608636845	0.546935655
	0.577173126	0.612254453	0.547918959
	0.577824571	0.615890295	0.548906681
	0.578494173	0.619537245	0.549887711
	0.579176797	0.623182471	0.550874741
	0.579865857	0.626832049	0.551868381
	0.580560768	0.630500343	0.552855012
	0.581270069	0.634171745	0.553851848
	0.581995336	0.637846355	0.554854119
	0.582737005	0.641532033	0.555851432
	0.583496958	0.645231741	0.556874616
	0.584276389	0.648949439	0.557885356
	0.585079058	0.652665612	0.558906738
	0.585898776	0.656409891	0.559947188
	0.586735835	0.660154508	0.560981808
	0.587601861	0.663922290	0.562043032
	0.588497029	0.667703113	0.563103838
	0.589424239	0.671494383	0.564177928
	0.590386108	0.675310737	0.565256161
	0.591385420	0.679143010	0.566369698
	0.592424989	0.683001645	0.567492293
	0.593493587	0.686878686	0.568627260
	0.594609782	0.690775809	0.569787124
	0.595775565	0.694703034	0.570972503
	0.596998064	0.698657526	0.572186785
	0.598262760	0.702644232	0.573422866
	0.599601906	0.706660234	0.574680059
	0.600992156	0.710703635	0.575991366
	0.602456302	0.714778832	0.577314087
	0.603998868	0.718896840	0.578683992
	0.605601986	0.723048749	0.580099196
	0.607309806	0.727245983	0.581546599
	0.609094638	0.731483229	0.583046979
	0.610970983	0.735764021	0.584603068
	0.612941703	0.740099658	0.586210264
	0.615026892	0.744473067	0.587866887
	0.617228998	0.748900323	0.589592016
	0.619549606	0.753380938	0.591389809
	0.621979846	0.757920654	0.593253383
	0.624559759	0.762508144	0.595184754
	0.627268735	0.767157071	0.597203271
	0.630127635	0.771868401	0.599299124
	0.633135392	0.776636615	0.601476450
	0.636304902	0.781462103	0.603756391
	0.639633185	0.786350437	0.606114928
	0.643130305	0.791291074	0.608593333
	0.646810483	0.796293879	0.611158547
	0.650666227	0.801356469	0.613823832
	0.654703924	0.806477090	0.616615659
	0.658935899	0.811644333	0.619511971
	0.663368155	0.816861819	0.622511764
	0.667984414	0.822126770	0.625635588
	0.672796291	0.827425777	0.628877014
	0.677802951	0.832761867	0.632231899
	0.682999554	0.838129087	0.635702178
	0.688393522	0.843510933	0.639290897
	0.693965023	0.848913410	0.642990793
	0.699728571	0.854314277	0.646806011
	0.705668685	0.859715122	0.650724974
	0.711775694	0.865094709	0.654744336
	0.718038696	0.870452831	0.658868490
	0.724452187	0.875781362	0.663093743
	0.731000043	0.881058352	0.667394917
	0.737676452	0.886282291	0.671776481
	0.744466510	0.891433098	0.676235765
	0.751359413	0.896510812	0.680751773
	0.758327015	0.901495548	0.685338453
	0.765367868	0.906385999	0.689963791
	0.772456371	0.911165802	0.694624819
	0.779589205	0.915825703	0.699323034
	0.786751922	0.920366868	0.704044514
	0.793918539	0.924774284	0.708782154
	0.801075943	0.929044982	0.713514732
	0.808222854	0.933170964	0.718247687
	0.815337789	0.937155990	0.722969226
	0.822414780	0.940981833	0.727677763
	0.829437960	0.944659922	0.732365840
	0.836395962	0.948178165	0.737014990
	0.843285284	0.951544118	0.741629900
	0.850102195	0.954756578	0.746210113
	0.856831332	0.957815932	0.750749949
	0.863479291	0.960722762	0.755237248
	0.870022898	0.963478891	0.759669709
	0.876479521	0.966091227	0.764060003
	0.882837966	0.968566188	0.768392448
	0.889102063	0.970900278	0.772675700
	0.895264107	0.973106852	0.776909160
	0.901325176	0.975179832	0.781078858
	0.907294438	0.977138091	0.785200950
	0.913164864	0.978976511	0.789269349
	0.918939045	0.980707549	0.793286970
	0.924628551	0.982335275	0.797248052
	0.930234938	0.983859712	0.801168659
	0.935754533	0.985295133	0.805041840
	0.941192497	0.986643292	0.808875756
	0.946557971	0.987907108	0.812659736
	0.951852662	0.989100835	0.816415103
	0.957081899	0.990221718	0.820123624
	0.962248316	0.991279603	0.823805858
	0.967363027	0.992280612	0.827457357
	0.972421753	0.993229227	0.831083393
	0.977430212	0.994124774	0.834679413
	0.982399795	0.994978488	0.838253143
	0.987328351	0.995794800	0.841810071
	0.992220526	0.996577783	0.845345226
	0.997079758	0.997331436	0.848869523
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
