
function cm = thermal(n, varargin)
% Colormap: thermal

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.015556000	0.138244000	0.201811000
	0.016202000	0.141051000	0.208977000
	0.016856000	0.143827000	0.216239000
	0.017526000	0.146572000	0.223600000
	0.018219000	0.149283000	0.231062000
	0.018941000	0.151961000	0.238627000
	0.019700000	0.154601000	0.246305000
	0.020503000	0.157204000	0.254097000
	0.021367000	0.159766000	0.261999000
	0.022303000	0.162288000	0.270013000
	0.023325000	0.164765000	0.278141000
	0.024447000	0.167197000	0.286386000
	0.025686000	0.169580000	0.294748000
	0.027059000	0.171913000	0.303231000
	0.028586000	0.174193000	0.311835000
	0.030288000	0.176417000	0.320562000
	0.032190000	0.178582000	0.329414000
	0.034318000	0.180685000	0.338391000
	0.036701000	0.182722000	0.347495000
	0.039371000	0.184690000	0.356724000
	0.042305000	0.186585000	0.366080000
	0.045441000	0.188404000	0.375561000
	0.048799000	0.190141000	0.385166000
	0.052386000	0.191794000	0.394891000
	0.056209000	0.193356000	0.404733000
	0.060276000	0.194825000	0.414686000
	0.064595000	0.196188000	0.424771000
	0.069173000	0.197446000	0.434957000
	0.074014000	0.198594000	0.445232000
	0.079126000	0.199625000	0.455597000
	0.084521000	0.200528000	0.466051000
	0.090194000	0.201308000	0.476548000
	0.096164000	0.201947000	0.487104000
	0.102425000	0.202452000	0.497665000
	0.108994000	0.202809000	0.508227000
	0.115860000	0.203027000	0.518725000
	0.123042000	0.203094000	0.529148000
	0.130528000	0.203022000	0.539420000
	0.138310000	0.202820000	0.549477000
	0.146380000	0.202500000	0.559246000
	0.154719000	0.202085000	0.568642000
	0.163297000	0.201605000	0.577568000
	0.172073000	0.201103000	0.585918000
	0.180992000	0.200627000	0.593592000
	0.189990000	0.200234000	0.600497000
	0.199000000	0.199980000	0.606565000
	0.207953000	0.199916000	0.611757000
	0.216790000	0.200083000	0.616067000
	0.225460000	0.200507000	0.619523000
	0.233931000	0.201199000	0.622176000
	0.242179000	0.202159000	0.624098000
	0.250197000	0.203373000	0.625368000
	0.257986000	0.204821000	0.626069000
	0.265554000	0.206480000	0.626278000
	0.272915000	0.208324000	0.626068000
	0.280083000	0.210328000	0.625501000
	0.287068000	0.212469000	0.624642000
	0.293885000	0.214725000	0.623538000
	0.300558000	0.217076000	0.622225000
	0.307084000	0.219506000	0.620755000
	0.313492000	0.221998000	0.619145000
	0.319780000	0.224542000	0.617434000
	0.325970000	0.227124000	0.615633000
	0.332058000	0.229737000	0.613777000
	0.338066000	0.232372000	0.611866000
	0.343992000	0.235022000	0.609928000
	0.349846000	0.237681000	0.607969000
	0.355638000	0.240344000	0.605995000
	0.361369000	0.243009000	0.604024000
	0.367043000	0.245671000	0.602061000
	0.372671000	0.248327000	0.600106000
	0.378255000	0.250974000	0.598166000
	0.383796000	0.253612000	0.596250000
	0.389299000	0.256239000	0.594362000
	0.394769000	0.258852000	0.592500000
	0.400210000	0.261451000	0.590666000
	0.405624000	0.264035000	0.588863000
	0.411014000	0.266603000	0.587093000
	0.416383000	0.269154000	0.585357000
	0.421731000	0.271688000	0.583658000
	0.427063000	0.274205000	0.581994000
	0.432382000	0.276704000	0.580364000
	0.437689000	0.279184000	0.578768000
	0.442986000	0.281646000	0.577205000
	0.448276000	0.284089000	0.575675000
	0.453560000	0.286513000	0.574176000
	0.458841000	0.288918000	0.572709000
	0.464120000	0.291304000	0.571271000
	0.469399000	0.293670000	0.569861000
	0.474680000	0.296017000	0.568477000
	0.479963000	0.298345000	0.567118000
	0.485252000	0.300652000	0.565782000
	0.490547000	0.302940000	0.564466000
	0.495850000	0.305208000	0.563169000
	0.501162000	0.307457000	0.561889000
	0.506485000	0.309685000	0.560622000
	0.511819000	0.311894000	0.559367000
	0.517167000	0.314083000	0.558121000
	0.522529000	0.316252000	0.556882000
	0.527906000	0.318401000	0.555646000
	0.533299000	0.320531000	0.554412000
	0.538709000	0.322641000	0.553175000
	0.544138000	0.324732000	0.551934000
	0.549585000	0.326803000	0.550686000
	0.555051000	0.328855000	0.549427000
	0.560538000	0.330889000	0.548155000
	0.566045000	0.332903000	0.546866000
	0.571572000	0.334900000	0.545558000
	0.577121000	0.336878000	0.544228000
	0.582692000	0.338839000	0.542872000
	0.588284000	0.340783000	0.541488000
	0.593898000	0.342710000	0.540072000
	0.599534000	0.344621000	0.538621000
	0.605192000	0.346516000	0.537133000
	0.610871000	0.348396000	0.535604000
	0.616571000	0.350261000	0.534033000
	0.622291000	0.352113000	0.532415000
	0.628032000	0.353951000	0.530748000
	0.633793000	0.355778000	0.529030000
	0.639572000	0.357593000	0.527259000
	0.645370000	0.359398000	0.525431000
	0.651185000	0.361193000	0.523544000
	0.657016000	0.362980000	0.521596000
	0.662863000	0.364759000	0.519585000
	0.668724000	0.366532000	0.517508000
	0.674598000	0.368299000	0.515365000
	0.680485000	0.370063000	0.513152000
	0.686382000	0.371824000	0.510869000
	0.692288000	0.373584000	0.508514000
	0.698202000	0.375344000	0.506084000
	0.704122000	0.377105000	0.503580000
	0.710047000	0.378869000	0.501000000
	0.715975000	0.380637000	0.498341000
	0.721905000	0.382411000	0.495604000
	0.727834000	0.384192000	0.492788000
	0.733762000	0.385983000	0.489892000
	0.739685000	0.387785000	0.486915000
	0.745602000	0.389600000	0.483858000
	0.751511000	0.391430000	0.480719000
	0.757410000	0.393276000	0.477499000
	0.763296000	0.395140000	0.474198000
	0.769168000	0.397026000	0.470814000
	0.775023000	0.398934000	0.467350000
	0.780859000	0.400868000	0.463805000
	0.786673000	0.402829000	0.460179000
	0.792463000	0.404820000	0.456473000
	0.798226000	0.406842000	0.452688000
	0.803959000	0.408900000	0.448825000
	0.809660000	0.410995000	0.444884000
	0.815326000	0.413130000	0.440867000
	0.820953000	0.415308000	0.436775000
	0.826539000	0.417531000	0.432611000
	0.832081000	0.419803000	0.428375000
	0.837574000	0.422127000	0.424070000
	0.843016000	0.424505000	0.419699000
	0.848403000	0.426941000	0.415263000
	0.853732000	0.429438000	0.410766000
	0.858998000	0.431999000	0.406210000
	0.864197000	0.434628000	0.401600000
	0.869327000	0.437327000	0.396938000
	0.874383000	0.440100000	0.392229000
	0.879361000	0.442951000	0.387477000
	0.884256000	0.445882000	0.382687000
	0.889066000	0.448897000	0.377863000
	0.893784000	0.451998000	0.373012000
	0.898409000	0.455189000	0.368138000
	0.902934000	0.458473000	0.363249000
	0.907358000	0.461851000	0.358352000
	0.911674000	0.465327000	0.353452000
	0.915881000	0.468902000	0.348558000
	0.919974000	0.472579000	0.343676000
	0.923950000	0.476358000	0.338816000
	0.927806000	0.480241000	0.333985000
	0.931540000	0.484229000	0.329191000
	0.935149000	0.488322000	0.324443000
	0.938630000	0.492520000	0.319749000
	0.941983000	0.496823000	0.315118000
	0.945205000	0.501230000	0.310559000
	0.948297000	0.505739000	0.306080000
	0.951257000	0.510350000	0.301689000
	0.954086000	0.515059000	0.297394000
	0.956784000	0.519865000	0.293202000
	0.959351000	0.524766000	0.289122000
	0.961788000	0.529758000	0.285160000
	0.964097000	0.534838000	0.281322000
	0.966280000	0.540003000	0.277614000
	0.968337000	0.545251000	0.274042000
	0.970272000	0.550576000	0.270610000
	0.972089000	0.555974000	0.267332000
	0.973788000	0.561443000	0.264205000
	0.975372000	0.566979000	0.261232000
	0.976843000	0.572579000	0.258416000
	0.978204000	0.578240000	0.255760000
	0.979456000	0.583959000	0.253264000
	0.980601000	0.589733000	0.250932000
	0.981645000	0.595558000	0.248767000
	0.982596000	0.601424000	0.246784000
	0.983448000	0.607335000	0.244967000
	0.984204000	0.613291000	0.243316000
	0.984863000	0.619289000	0.241832000
	0.985434000	0.625323000	0.240521000
	0.985927000	0.631384000	0.239392000
	0.986329000	0.637481000	0.238429000
	0.986641000	0.643612000	0.237627000
	0.986874000	0.649770000	0.236998000
	0.987039000	0.655947000	0.236546000
	0.987116000	0.662154000	0.236252000
	0.987105000	0.668393000	0.236113000
	0.987045000	0.674636000	0.236155000
	0.986901000	0.680907000	0.236349000
	0.986669000	0.687206000	0.236690000
	0.986393000	0.693507000	0.237203000
	0.986036000	0.699832000	0.237859000
	0.985594000	0.706183000	0.238655000
	0.985117000	0.712529000	0.239614000
	0.984552000	0.718902000	0.240703000
	0.983922000	0.725287000	0.241930000
	0.983241000	0.731678000	0.243298000
	0.982469000	0.738096000	0.244785000
	0.981668000	0.744506000	0.246412000
	0.980781000	0.750939000	0.248153000
	0.979838000	0.757380000	0.250014000
	0.978839000	0.763828000	0.251991000
	0.977757000	0.770297000	0.254072000
	0.976648000	0.776757000	0.256266000
	0.975436000	0.783249000	0.258553000
	0.974211000	0.789725000	0.260947000
	0.972884000	0.796231000	0.263426000
	0.971530000	0.802728000	0.265999000
	0.970086000	0.809248000	0.268653000
	0.968606000	0.815765000	0.271390000
	0.967043000	0.822301000	0.274201000
	0.965438000	0.828836000	0.277086000
	0.963752000	0.835388000	0.280038000
	0.962023000	0.841941000	0.283055000
	0.960210000	0.848512000	0.286133000
	0.958358000	0.855081000	0.289268000
	0.956412000	0.861672000	0.292456000
	0.954435000	0.868257000	0.295695000
	0.952349000	0.874871000	0.298979000
	0.950246000	0.881473000	0.302308000
	0.948014000	0.888111000	0.305675000
	0.945782000	0.894730000	0.309081000
	0.943420000	0.901385000	0.312520000
	0.941029000	0.908033000	0.315991000
	0.938533000	0.914705000	0.319489000
	0.935971000	0.921385000	0.323014000
	0.933338000	0.928075000	0.326562000
	0.930592000	0.934791000	0.330130000
	0.927814000	0.941500000	0.333717000
	0.924890000	0.948247000	0.337320000
	0.921941000	0.954985000	0.340937000
	0.918861000	0.961753000	0.344566000
	0.915693000	0.968535000	0.348206000
	0.912449000	0.975327000	0.351853000
	0.909042000	0.982157000	0.355508000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
