
function cm = tempo(n, varargin)
% Colormap: tempo

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.082256000	0.114924000	0.264790000
	0.083126000	0.119038000	0.266863000
	0.084002000	0.123107000	0.268953000
	0.084873000	0.127139000	0.271054000
	0.085744000	0.131133000	0.273169000
	0.086612000	0.135094000	0.275296000
	0.087475000	0.139026000	0.277433000
	0.088339000	0.142927000	0.279583000
	0.089190000	0.146804000	0.281740000
	0.090041000	0.150656000	0.283909000
	0.090882000	0.154485000	0.286085000
	0.091717000	0.158293000	0.288270000
	0.092546000	0.162081000	0.290465000
	0.093362000	0.165852000	0.292665000
	0.094173000	0.169605000	0.294874000
	0.094969000	0.173343000	0.297089000
	0.095756000	0.177067000	0.299312000
	0.096533000	0.180776000	0.301541000
	0.097293000	0.184473000	0.303775000
	0.098045000	0.188158000	0.306016000
	0.098778000	0.191833000	0.308261000
	0.099498000	0.195498000	0.310512000
	0.100205000	0.199152000	0.312768000
	0.100890000	0.202799000	0.315028000
	0.101562000	0.206438000	0.317293000
	0.102215000	0.210069000	0.319561000
	0.102847000	0.213694000	0.321833000
	0.103464000	0.217312000	0.324109000
	0.104056000	0.220926000	0.326387000
	0.104627000	0.224535000	0.328668000
	0.105181000	0.228138000	0.330953000
	0.105706000	0.231738000	0.333238000
	0.106209000	0.235335000	0.335526000
	0.106693000	0.238927000	0.337817000
	0.107143000	0.242519000	0.340106000
	0.107571000	0.246107000	0.342398000
	0.107976000	0.249693000	0.344691000
	0.108346000	0.253279000	0.346983000
	0.108691000	0.256863000	0.349275000
	0.109012000	0.260445000	0.351568000
	0.109293000	0.264029000	0.353858000
	0.109548000	0.267611000	0.356148000
	0.109775000	0.271193000	0.358437000
	0.109964000	0.274776000	0.360723000
	0.110120000	0.278360000	0.363007000
	0.110246000	0.281944000	0.365289000
	0.110336000	0.285530000	0.367567000
	0.110387000	0.289117000	0.369842000
	0.110405000	0.292706000	0.372113000
	0.110389000	0.296295000	0.374381000
	0.110329000	0.299888000	0.376642000
	0.110232000	0.303483000	0.378899000
	0.110099000	0.307079000	0.381150000
	0.109929000	0.310678000	0.383397000
	0.109709000	0.314280000	0.385635000
	0.109452000	0.317885000	0.387867000
	0.109156000	0.321492000	0.390092000
	0.108820000	0.325102000	0.392310000
	0.108434000	0.328716000	0.394518000
	0.108005000	0.332333000	0.396718000
	0.107536000	0.335953000	0.398909000
	0.107024000	0.339576000	0.401091000
	0.106467000	0.343203000	0.403262000
	0.105858000	0.346834000	0.405422000
	0.105207000	0.350468000	0.407571000
	0.104511000	0.354106000	0.409709000
	0.103772000	0.357747000	0.411835000
	0.102988000	0.361391000	0.413949000
	0.102151000	0.365040000	0.416048000
	0.101269000	0.368692000	0.418134000
	0.100342000	0.372348000	0.420205000
	0.099372000	0.376007000	0.422263000
	0.098357000	0.379670000	0.424305000
	0.097300000	0.383335000	0.426331000
	0.096200000	0.387005000	0.428342000
	0.095052000	0.390678000	0.430334000
	0.093862000	0.394355000	0.432309000
	0.092634000	0.398034000	0.434266000
	0.091369000	0.401717000	0.436204000
	0.090069000	0.405402000	0.438124000
	0.088737000	0.409090000	0.440024000
	0.087376000	0.412781000	0.441903000
	0.085988000	0.416474000	0.443762000
	0.084579000	0.420169000	0.445599000
	0.083152000	0.423867000	0.447414000
	0.081714000	0.427566000	0.449206000
	0.080270000	0.431267000	0.450975000
	0.078827000	0.434969000	0.452720000
	0.077394000	0.438673000	0.454441000
	0.075980000	0.442377000	0.456136000
	0.074594000	0.446082000	0.457806000
	0.073249000	0.449786000	0.459450000
	0.071958000	0.453491000	0.461067000
	0.070734000	0.457195000	0.462657000
	0.069594000	0.460898000	0.464219000
	0.068554000	0.464600000	0.465753000
	0.067633000	0.468299000	0.467258000
	0.066850000	0.471997000	0.468733000
	0.066227000	0.475691000	0.470179000
	0.065777000	0.479382000	0.471594000
	0.065526000	0.483070000	0.472978000
	0.065498000	0.486753000	0.474331000
	0.065716000	0.490431000	0.475652000
	0.066198000	0.494103000	0.476943000
	0.066963000	0.497768000	0.478202000
	0.068016000	0.501427000	0.479427000
	0.069383000	0.505078000	0.480620000
	0.071074000	0.508720000	0.481781000
	0.073096000	0.512352000	0.482912000
	0.075443000	0.515975000	0.484008000
	0.078127000	0.519587000	0.485073000
	0.081146000	0.523186000	0.486107000
	0.084488000	0.526773000	0.487110000
	0.088151000	0.530346000	0.488082000
	0.092127000	0.533904000	0.489026000
	0.096401000	0.537447000	0.489939000
	0.100965000	0.540973000	0.490826000
	0.105806000	0.544482000	0.491687000
	0.110909000	0.547972000	0.492522000
	0.116263000	0.551443000	0.493336000
	0.121854000	0.554894000	0.494126000
	0.127667000	0.558324000	0.494898000
	0.133691000	0.561732000	0.495652000
	0.139912000	0.565117000	0.496392000
	0.146317000	0.568479000	0.497119000
	0.152894000	0.571816000	0.497837000
	0.159630000	0.575129000	0.498548000
	0.166513000	0.578417000	0.499256000
	0.173533000	0.581679000	0.499963000
	0.180676000	0.584915000	0.500674000
	0.187933000	0.588125000	0.501390000
	0.195292000	0.591308000	0.502116000
	0.202744000	0.594465000	0.502855000
	0.210278000	0.597596000	0.503610000
	0.217884000	0.600700000	0.504386000
	0.225552000	0.603779000	0.505184000
	0.233275000	0.606832000	0.506009000
	0.241043000	0.609860000	0.506864000
	0.248849000	0.612863000	0.507752000
	0.256684000	0.615842000	0.508675000
	0.264543000	0.618798000	0.509637000
	0.272416000	0.621732000	0.510640000
	0.280300000	0.624644000	0.511686000
	0.288188000	0.627535000	0.512778000
	0.296075000	0.630406000	0.513918000
	0.303956000	0.633258000	0.515108000
	0.311825000	0.636091000	0.516349000
	0.319681000	0.638907000	0.517643000
	0.327519000	0.641707000	0.518992000
	0.335336000	0.644492000	0.520396000
	0.343128000	0.647262000	0.521858000
	0.350894000	0.650019000	0.523377000
	0.358631000	0.652763000	0.524954000
	0.366337000	0.655495000	0.526592000
	0.374012000	0.658216000	0.528288000
	0.381651000	0.660928000	0.530046000
	0.389258000	0.663629000	0.531863000
	0.396826000	0.666324000	0.533743000
	0.404359000	0.669010000	0.535683000
	0.411855000	0.671689000	0.537684000
	0.419312000	0.674363000	0.539748000
	0.426733000	0.677031000	0.541872000
	0.434113000	0.679695000	0.544058000
	0.441455000	0.682355000	0.546306000
	0.448760000	0.685011000	0.548614000
	0.456024000	0.687666000	0.550984000
	0.463250000	0.690318000	0.553415000
	0.470439000	0.692968000	0.555906000
	0.477589000	0.695618000	0.558458000
	0.484700000	0.698268000	0.561070000
	0.491774000	0.700918000	0.563741000
	0.498812000	0.703569000	0.566472000
	0.505812000	0.706222000	0.569262000
	0.512774000	0.708876000	0.572111000
	0.519701000	0.711533000	0.575019000
	0.526593000	0.714192000	0.577984000
	0.533449000	0.716855000	0.581007000
	0.540269000	0.719521000	0.584087000
	0.547055000	0.722192000	0.587223000
	0.553807000	0.724867000	0.590416000
	0.560527000	0.727547000	0.593665000
	0.567213000	0.730233000	0.596969000
	0.573865000	0.732924000	0.600328000
	0.580485000	0.735622000	0.603742000
	0.587073000	0.738327000	0.607209000
	0.593630000	0.741038000	0.610730000
	0.600156000	0.743756000	0.614304000
	0.606653000	0.746482000	0.617930000
	0.613119000	0.749215000	0.621609000
	0.619556000	0.751957000	0.625338000
	0.625964000	0.754708000	0.629119000
	0.632341000	0.757468000	0.632950000
	0.638691000	0.760237000	0.636831000
	0.645013000	0.763015000	0.640761000
	0.651308000	0.765803000	0.644740000
	0.657576000	0.768602000	0.648767000
	0.663817000	0.771410000	0.652842000
	0.670032000	0.774230000	0.656965000
	0.676222000	0.777060000	0.661133000
	0.682386000	0.779901000	0.665348000
	0.688525000	0.782754000	0.669608000
	0.694640000	0.785619000	0.673914000
	0.700730000	0.788495000	0.678263000
	0.706797000	0.791384000	0.682656000
	0.712841000	0.794285000	0.687093000
	0.718861000	0.797199000	0.691572000
	0.724859000	0.800126000	0.696093000
	0.730835000	0.803066000	0.700656000
	0.736789000	0.806020000	0.705260000
	0.742722000	0.808987000	0.709904000
	0.748633000	0.811968000	0.714587000
	0.754522000	0.814963000	0.719310000
	0.760392000	0.817973000	0.724070000
	0.766241000	0.820997000	0.728869000
	0.772071000	0.824036000	0.733705000
	0.777882000	0.827089000	0.738578000
	0.783673000	0.830158000	0.743487000
	0.789447000	0.833242000	0.748432000
	0.795203000	0.836341000	0.753412000
	0.800940000	0.839456000	0.758426000
	0.806658000	0.842588000	0.763472000
	0.812360000	0.845736000	0.768552000
	0.818045000	0.848899000	0.773664000
	0.823714000	0.852079000	0.778808000
	0.829367000	0.855275000	0.783984000
	0.835005000	0.858488000	0.789190000
	0.840625000	0.861719000	0.794424000
	0.846230000	0.864967000	0.799687000
	0.851821000	0.868232000	0.804980000
	0.857399000	0.871515000	0.810300000
	0.862963000	0.874814000	0.815649000
	0.868511000	0.878133000	0.821020000
	0.874047000	0.881469000	0.826418000
	0.879571000	0.884822000	0.831841000
	0.885084000	0.888194000	0.837289000
	0.890584000	0.891584000	0.842759000
	0.896072000	0.894993000	0.848250000
	0.901551000	0.898420000	0.853763000
	0.907022000	0.901864000	0.859298000
	0.912483000	0.905327000	0.864852000
	0.917937000	0.908808000	0.870423000
	0.923385000	0.912307000	0.876015000
	0.928831000	0.915822000	0.881626000
	0.934272000	0.919356000	0.887253000
	0.939712000	0.922905000	0.892900000
	0.945156000	0.926468000	0.898570000
	0.950604000	0.930046000	0.904265000
	0.956053000	0.933639000	0.909989000
	0.961507000	0.937243000	0.915756000
	0.966957000	0.940862000	0.921580000
	0.972387000	0.944502000	0.927467000
	0.977779000	0.948169000	0.933436000
	0.983105000	0.951873000	0.939486000
	0.988342000	0.955628000	0.945584000
	0.993492000	0.959438000	0.951698000
	0.998576000	0.963297000	0.957790000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
