
function cm = speed(n, varargin)
% Colormap: speed

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.090533000	0.137339000	0.073258000
	0.091493000	0.141050000	0.076387000
	0.092410000	0.144757000	0.079475000
	0.093282000	0.148461000	0.082521000
	0.094089000	0.152165000	0.085526000
	0.094849000	0.155867000	0.088490000
	0.095558000	0.159567000	0.091412000
	0.096205000	0.163269000	0.094292000
	0.096795000	0.166971000	0.097130000
	0.097332000	0.170672000	0.099927000
	0.097811000	0.174375000	0.102681000
	0.098223000	0.178081000	0.105391000
	0.098577000	0.181788000	0.108059000
	0.098873000	0.185496000	0.110684000
	0.099106000	0.189206000	0.113264000
	0.099269000	0.192920000	0.115800000
	0.099371000	0.196636000	0.118291000
	0.099410000	0.200354000	0.120736000
	0.099385000	0.204074000	0.123136000
	0.099291000	0.207798000	0.125489000
	0.099128000	0.211526000	0.127794000
	0.098899000	0.215255000	0.130051000
	0.098605000	0.218987000	0.132261000
	0.098244000	0.222722000	0.134421000
	0.097815000	0.226459000	0.136533000
	0.097313000	0.230200000	0.138593000
	0.096744000	0.233943000	0.140602000
	0.096107000	0.237688000	0.142560000
	0.095403000	0.241435000	0.144467000
	0.094632000	0.245183000	0.146321000
	0.093793000	0.248934000	0.148122000
	0.092887000	0.252686000	0.149869000
	0.091913000	0.256439000	0.151563000
	0.090872000	0.260194000	0.153201000
	0.089765000	0.263949000	0.154785000
	0.088594000	0.267705000	0.156313000
	0.087360000	0.271461000	0.157785000
	0.086064000	0.275217000	0.159202000
	0.084707000	0.278973000	0.160561000
	0.083291000	0.282728000	0.161864000
	0.081818000	0.286483000	0.163110000
	0.080290000	0.290236000	0.164298000
	0.078709000	0.293988000	0.165428000
	0.077077000	0.297738000	0.166501000
	0.075399000	0.301486000	0.167515000
	0.073677000	0.305232000	0.168470000
	0.071916000	0.308975000	0.169366000
	0.070119000	0.312715000	0.170203000
	0.068292000	0.316452000	0.170981000
	0.066442000	0.320185000	0.171699000
	0.064575000	0.323914000	0.172357000
	0.062699000	0.327639000	0.172956000
	0.060821000	0.331359000	0.173494000
	0.058953000	0.335075000	0.173972000
	0.057105000	0.338785000	0.174389000
	0.055290000	0.342489000	0.174746000
	0.053521000	0.346188000	0.175042000
	0.051814000	0.349880000	0.175277000
	0.050186000	0.353565000	0.175450000
	0.048656000	0.357244000	0.175562000
	0.047245000	0.360915000	0.175612000
	0.045974000	0.364578000	0.175600000
	0.044867000	0.368233000	0.175527000
	0.043947000	0.371879000	0.175391000
	0.043239000	0.375517000	0.175192000
	0.042767000	0.379145000	0.174931000
	0.042554000	0.382764000	0.174607000
	0.042620000	0.386372000	0.174220000
	0.042985000	0.389970000	0.173769000
	0.043663000	0.393558000	0.173256000
	0.044664000	0.397133000	0.172678000
	0.045995000	0.400697000	0.172037000
	0.047658000	0.404249000	0.171332000
	0.049651000	0.407788000	0.170563000
	0.051968000	0.411314000	0.169730000
	0.054600000	0.414826000	0.168833000
	0.057534000	0.418325000	0.167872000
	0.060756000	0.421808000	0.166847000
	0.064252000	0.425277000	0.165757000
	0.068006000	0.428731000	0.164604000
	0.072002000	0.432169000	0.163386000
	0.076224000	0.435590000	0.162105000
	0.080657000	0.438995000	0.160760000
	0.085288000	0.442382000	0.159351000
	0.090103000	0.445752000	0.157879000
	0.095088000	0.449104000	0.156343000
	0.100234000	0.452438000	0.154745000
	0.105528000	0.455752000	0.153084000
	0.110962000	0.459048000	0.151361000
	0.116526000	0.462323000	0.149577000
	0.122211000	0.465579000	0.147732000
	0.128010000	0.468814000	0.145827000
	0.133915000	0.472029000	0.143863000
	0.139920000	0.475223000	0.141840000
	0.146020000	0.478395000	0.139758000
	0.152207000	0.481546000	0.137620000
	0.158477000	0.484676000	0.135425000
	0.164825000	0.487783000	0.133174000
	0.171244000	0.490869000	0.130870000
	0.177732000	0.493932000	0.128513000
	0.184284000	0.496973000	0.126104000
	0.190895000	0.499992000	0.123644000
	0.197562000	0.502989000	0.121135000
	0.204280000	0.505964000	0.118578000
	0.211047000	0.508916000	0.115974000
	0.217857000	0.511847000	0.113324000
	0.224710000	0.514755000	0.110631000
	0.231600000	0.517642000	0.107896000
	0.238525000	0.520507000	0.105119000
	0.245481000	0.523351000	0.102304000
	0.252467000	0.526174000	0.099451000
	0.259479000	0.528976000	0.096564000
	0.266514000	0.531758000	0.093642000
	0.273570000	0.534520000	0.090689000
	0.280644000	0.537262000	0.087706000
	0.287735000	0.539985000	0.084696000
	0.294840000	0.542689000	0.081661000
	0.301957000	0.545374000	0.078604000
	0.309085000	0.548042000	0.075527000
	0.316219000	0.550691000	0.072435000
	0.323360000	0.553324000	0.069331000
	0.330506000	0.555940000	0.066219000
	0.337655000	0.558541000	0.063103000
	0.344806000	0.561125000	0.059988000
	0.351957000	0.563695000	0.056881000
	0.359107000	0.566249000	0.053788000
	0.366254000	0.568790000	0.050718000
	0.373399000	0.571317000	0.047680000
	0.380539000	0.573831000	0.044686000
	0.387673000	0.576332000	0.041747000
	0.394801000	0.578822000	0.038871000
	0.401922000	0.581300000	0.036166000
	0.409034000	0.583766000	0.033673000
	0.416138000	0.586222000	0.031397000
	0.423233000	0.588669000	0.029344000
	0.430318000	0.591105000	0.027522000
	0.437392000	0.593533000	0.025937000
	0.444455000	0.595951000	0.024595000
	0.451506000	0.598362000	0.023504000
	0.458545000	0.600765000	0.022672000
	0.465571000	0.603161000	0.022106000
	0.472584000	0.605550000	0.021814000
	0.479583000	0.607934000	0.021806000
	0.486568000	0.610311000	0.022089000
	0.493538000	0.612683000	0.022674000
	0.500493000	0.615051000	0.023571000
	0.507433000	0.617414000	0.024790000
	0.514357000	0.619774000	0.026341000
	0.521264000	0.622130000	0.028238000
	0.528154000	0.624484000	0.030491000
	0.535027000	0.626835000	0.033114000
	0.541882000	0.629185000	0.036121000
	0.548719000	0.631534000	0.039525000
	0.555537000	0.633882000	0.043237000
	0.562335000	0.636229000	0.047138000
	0.569113000	0.638578000	0.051219000
	0.575870000	0.640927000	0.055464000
	0.582605000	0.643278000	0.059860000
	0.589317000	0.645631000	0.064393000
	0.596007000	0.647988000	0.069054000
	0.602672000	0.650347000	0.073835000
	0.609313000	0.652711000	0.078728000
	0.615927000	0.655080000	0.083728000
	0.622515000	0.657454000	0.088831000
	0.629075000	0.659835000	0.094032000
	0.635605000	0.662223000	0.099329000
	0.642104000	0.664619000	0.104719000
	0.648572000	0.667024000	0.110201000
	0.655006000	0.669439000	0.115773000
	0.661406000	0.671864000	0.121435000
	0.667769000	0.674301000	0.127187000
	0.674094000	0.676750000	0.133027000
	0.680379000	0.679213000	0.138956000
	0.686622000	0.681691000	0.144974000
	0.692822000	0.684185000	0.151081000
	0.698977000	0.686695000	0.157279000
	0.705085000	0.689224000	0.163567000
	0.711142000	0.691772000	0.169945000
	0.717148000	0.694341000	0.176414000
	0.723099000	0.696932000	0.182974000
	0.728994000	0.699547000	0.189626000
	0.734830000	0.702186000	0.196369000
	0.740605000	0.704851000	0.203204000
	0.746317000	0.707543000	0.210131000
	0.751963000	0.710264000	0.217148000
	0.757541000	0.713016000	0.224255000
	0.763048000	0.715798000	0.231452000
	0.768483000	0.718614000	0.238736000
	0.773844000	0.721464000	0.246107000
	0.779129000	0.724350000	0.253563000
	0.784335000	0.727272000	0.261102000
	0.789461000	0.730231000	0.268720000
	0.794507000	0.733230000	0.276417000
	0.799470000	0.736268000	0.284188000
	0.804350000	0.739347000	0.292032000
	0.809147000	0.742467000	0.299944000
	0.813859000	0.745629000	0.307922000
	0.818487000	0.748833000	0.315962000
	0.823030000	0.752080000	0.324058000
	0.827490000	0.755371000	0.332208000
	0.831866000	0.758704000	0.340408000
	0.836159000	0.762081000	0.348655000
	0.840371000	0.765500000	0.356944000
	0.844504000	0.768962000	0.365272000
	0.848557000	0.772467000	0.373634000
	0.852534000	0.776014000	0.382029000
	0.856436000	0.779603000	0.390451000
	0.860265000	0.783233000	0.398898000
	0.864022000	0.786903000	0.407367000
	0.867711000	0.790613000	0.415854000
	0.871333000	0.794362000	0.424356000
	0.874892000	0.798149000	0.432871000
	0.878388000	0.801973000	0.441397000
	0.881825000	0.805834000	0.449931000
	0.885204000	0.809731000	0.458472000
	0.888529000	0.813663000	0.467016000
	0.891802000	0.817629000	0.475563000
	0.895025000	0.821627000	0.484111000
	0.898200000	0.825659000	0.492659000
	0.901329000	0.829721000	0.501206000
	0.904416000	0.833815000	0.509749000
	0.907461000	0.837938000	0.518289000
	0.910468000	0.842091000	0.526825000
	0.913438000	0.846271000	0.535356000
	0.916373000	0.850480000	0.543881000
	0.919275000	0.854715000	0.552400000
	0.922147000	0.858976000	0.560912000
	0.924990000	0.863263000	0.569415000
	0.927807000	0.867574000	0.577908000
	0.930599000	0.871909000	0.586394000
	0.933367000	0.876268000	0.594871000
	0.936114000	0.880650000	0.603340000
	0.938840000	0.885055000	0.611801000
	0.941549000	0.889480000	0.620254000
	0.944240000	0.893928000	0.628698000
	0.946917000	0.898395000	0.637132000
	0.949581000	0.902883000	0.645556000
	0.952233000	0.907391000	0.653971000
	0.954874000	0.911917000	0.662378000
	0.957507000	0.916463000	0.670777000
	0.960132000	0.921026000	0.679167000
	0.962751000	0.925608000	0.687549000
	0.965366000	0.930207000	0.695921000
	0.967978000	0.934822000	0.704286000
	0.970588000	0.939454000	0.712643000
	0.973198000	0.944102000	0.720992000
	0.975809000	0.948766000	0.729334000
	0.978424000	0.953445000	0.737667000
	0.981043000	0.958138000	0.745993000
	0.983667000	0.962847000	0.754315000
	0.986298000	0.967569000	0.762629000
	0.988938000	0.972304000	0.770936000
	0.991590000	0.977053000	0.779237000
	0.994253000	0.981814000	0.787532000
	0.996931000	0.986587000	0.795820000
	0.999625000	0.991371000	0.804101000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
