
function cm = rocket(n, varargin)
% Colormap: rocket

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.000000000	0.007843000	0.090196000
	0.031373000	0.027451000	0.117647000
	0.058824000	0.043137000	0.137255000
	0.082353000	0.054902000	0.152941000
	0.101961000	0.062745000	0.168627000
	0.129412000	0.070588000	0.184314000
	0.152941000	0.078431000	0.200000000
	0.176471000	0.086275000	0.219608000
	0.200000000	0.094118000	0.235294000
	0.223529000	0.098039000	0.250980000
	0.254902000	0.105882000	0.270588000
	0.278431000	0.109804000	0.282353000
	0.305882000	0.113725000	0.294118000
	0.333333000	0.113725000	0.305882000
	0.356863000	0.117647000	0.317647000
	0.384314000	0.117647000	0.325490000
	0.411765000	0.121569000	0.333333000
	0.439216000	0.121569000	0.341176000
	0.470588000	0.117647000	0.345098000
	0.494118000	0.117647000	0.349020000
	0.525490000	0.113725000	0.352941000
	0.556863000	0.109804000	0.356863000
	0.576471000	0.105882000	0.356863000
	0.611765000	0.101961000	0.356863000
	0.635294000	0.098039000	0.352941000
	0.666667000	0.094118000	0.349020000
	0.694118000	0.086275000	0.345098000
	0.721569000	0.086275000	0.337255000
	0.749020000	0.086275000	0.329412000
	0.776471000	0.094118000	0.317647000
	0.796078000	0.101961000	0.309804000
	0.823529000	0.125490000	0.294118000
	0.843137000	0.149020000	0.282353000
	0.862745000	0.172549000	0.270588000
	0.882353000	0.196078000	0.258824000
	0.898039000	0.227451000	0.250980000
	0.909804000	0.254902000	0.243137000
	0.921569000	0.290196000	0.239216000
	0.929412000	0.317647000	0.243137000
	0.937255000	0.356863000	0.254902000
	0.941176000	0.384314000	0.266667000
	0.949020000	0.423529000	0.286275000
	0.949020000	0.447059000	0.305882000
	0.952941000	0.478431000	0.329412000
	0.956863000	0.509804000	0.356863000
	0.956863000	0.537255000	0.380392000
	0.960784000	0.568627000	0.407843000
	0.960784000	0.596078000	0.435294000
	0.960784000	0.623529000	0.462745000
	0.960784000	0.654902000	0.494118000
	0.960784000	0.674510000	0.521569000
	0.964706000	0.705882000	0.556863000
	0.964706000	0.729412000	0.592157000
	0.964706000	0.756863000	0.627451000
	0.964706000	0.780392000	0.662745000
	0.968627000	0.807843000	0.701961000
	0.968627000	0.831373000	0.737255000
	0.972549000	0.858824000	0.776471000
	0.972549000	0.878431000	0.807843000
	0.976471000	0.909804000	0.850980000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
