
function cm = rainforest(n, varargin)
% Colormap: rainforest

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.000000000	0.000000000	0.000000000
	0.000353000	0.000182000	0.000285000
	0.001286000	0.000605000	0.001028000
	0.002780000	0.001202000	0.002211000
	0.004841000	0.001939000	0.003846000
	0.007480000	0.002787000	0.005953000
	0.010709000	0.003727000	0.008562000
	0.014543000	0.004740000	0.011705000
	0.018993000	0.005808000	0.015423000
	0.024071000	0.006918000	0.019759000
	0.029790000	0.008056000	0.024764000
	0.036158000	0.009207000	0.030493000
	0.043090000	0.010359000	0.037008000
	0.050028000	0.011500000	0.044209000
	0.056909000	0.012619000	0.051556000
	0.063737000	0.013703000	0.059036000
	0.070515000	0.014741000	0.066664000
	0.077242000	0.015721000	0.074454000
	0.083919000	0.016635000	0.082418000
	0.090546000	0.017470000	0.090571000
	0.097119000	0.018217000	0.098922000
	0.103638000	0.018867000	0.107483000
	0.110098000	0.019409000	0.116266000
	0.116497000	0.019836000	0.125279000
	0.122831000	0.020140000	0.134529000
	0.129094000	0.020313000	0.144026000
	0.135283000	0.020350000	0.153774000
	0.141390000	0.020246000	0.163777000
	0.147411000	0.019997000	0.174038000
	0.153339000	0.019601000	0.184558000
	0.159166000	0.019058000	0.195334000
	0.164886000	0.018370000	0.206364000
	0.170492000	0.017542000	0.217641000
	0.175975000	0.016581000	0.229158000
	0.181328000	0.015497000	0.240905000
	0.186542000	0.014304000	0.252868000
	0.191608000	0.013019000	0.265031000
	0.196517000	0.011664000	0.277380000
	0.201260000	0.010266000	0.289893000
	0.205827000	0.008857000	0.302548000
	0.210207000	0.007473000	0.315321000
	0.214390000	0.006158000	0.328186000
	0.218364000	0.004962000	0.341113000
	0.222118000	0.003941000	0.354071000
	0.225639000	0.003160000	0.367029000
	0.228913000	0.002689000	0.379949000
	0.231928000	0.002609000	0.392795000
	0.234669000	0.003006000	0.405527000
	0.237120000	0.003975000	0.418104000
	0.239268000	0.005618000	0.430482000
	0.241096000	0.008043000	0.442617000
	0.242590000	0.011363000	0.454463000
	0.243732000	0.015695000	0.465974000
	0.244509000	0.021161000	0.477102000
	0.244906000	0.027878000	0.487801000
	0.244910000	0.035964000	0.498027000
	0.244509000	0.045273000	0.507735000
	0.243693000	0.054855000	0.516886000
	0.242454000	0.064597000	0.525443000
	0.240789000	0.074466000	0.533375000
	0.238696000	0.084430000	0.540656000
	0.236175000	0.094456000	0.547267000
	0.233233000	0.104511000	0.553196000
	0.229879000	0.114564000	0.558438000
	0.226124000	0.124584000	0.562997000
	0.221983000	0.134542000	0.566884000
	0.217476000	0.144411000	0.570115000
	0.212622000	0.154166000	0.572716000
	0.207445000	0.163786000	0.574715000
	0.201968000	0.173251000	0.576146000
	0.196215000	0.182545000	0.577048000
	0.190213000	0.191657000	0.577459000
	0.183985000	0.200577000	0.577420000
	0.177557000	0.209297000	0.576974000
	0.170951000	0.217814000	0.576160000
	0.164191000	0.226127000	0.575020000
	0.157296000	0.234235000	0.573590000
	0.150288000	0.242140000	0.571909000
	0.143183000	0.249847000	0.570010000
	0.136001000	0.257359000	0.567925000
	0.128755000	0.264684000	0.565683000
	0.121461000	0.271827000	0.563312000
	0.114131000	0.278794000	0.560835000
	0.106778000	0.285595000	0.558275000
	0.099412000	0.292236000	0.555651000
	0.092044000	0.298725000	0.552982000
	0.084683000	0.305070000	0.550283000
	0.077339000	0.311278000	0.547568000
	0.070020000	0.317357000	0.544849000
	0.062736000	0.323315000	0.542136000
	0.055494000	0.329159000	0.539440000
	0.048304000	0.334897000	0.536767000
	0.041177000	0.340534000	0.534124000
	0.034313000	0.346077000	0.531517000
	0.028232000	0.351534000	0.528951000
	0.022911000	0.356909000	0.526428000
	0.018317000	0.362210000	0.523952000
	0.014414000	0.367441000	0.521525000
	0.011160000	0.372608000	0.519147000
	0.008520000	0.377715000	0.516820000
	0.006453000	0.382769000	0.514542000
	0.004922000	0.387774000	0.512315000
	0.003884000	0.392734000	0.510135000
	0.003303000	0.397653000	0.508002000
	0.003139000	0.402536000	0.505913000
	0.003355000	0.407387000	0.503866000
	0.003914000	0.412208000	0.501857000
	0.004778000	0.417004000	0.499882000
	0.005915000	0.421778000	0.497938000
	0.007290000	0.426533000	0.496020000
	0.008874000	0.431271000	0.494124000
	0.010637000	0.435996000	0.492244000
	0.012554000	0.440710000	0.490375000
	0.014600000	0.445415000	0.488511000
	0.016755000	0.450113000	0.486645000
	0.019004000	0.454806000	0.484773000
	0.021331000	0.459496000	0.482888000
	0.023728000	0.464184000	0.480982000
	0.026190000	0.468871000	0.479049000
	0.028716000	0.473559000	0.477082000
	0.031309000	0.478248000	0.475074000
	0.033979000	0.482938000	0.473017000
	0.036740000	0.487631000	0.470906000
	0.039610000	0.492327000	0.468732000
	0.042545000	0.497025000	0.466488000
	0.045502000	0.501725000	0.464168000
	0.048517000	0.506427000	0.461764000
	0.051615000	0.511131000	0.459270000
	0.054821000	0.515835000	0.456678000
	0.058162000	0.520539000	0.453983000
	0.061662000	0.525243000	0.451178000
	0.065344000	0.529943000	0.448256000
	0.069229000	0.534640000	0.445213000
	0.073336000	0.539333000	0.442041000
	0.077684000	0.544018000	0.438735000
	0.082286000	0.548696000	0.435291000
	0.087153000	0.553363000	0.431703000
	0.092297000	0.558019000	0.427965000
	0.097723000	0.562662000	0.424074000
	0.103437000	0.567288000	0.420024000
	0.109442000	0.571897000	0.415812000
	0.115738000	0.576487000	0.411432000
	0.122326000	0.581054000	0.406881000
	0.129204000	0.585597000	0.402156000
	0.136369000	0.590114000	0.397251000
	0.143818000	0.594602000	0.392163000
	0.151547000	0.599059000	0.386889000
	0.159551000	0.603483000	0.381424000
	0.167826000	0.607870000	0.375765000
	0.176368000	0.612219000	0.369908000
	0.185172000	0.616526000	0.363849000
	0.194233000	0.620790000	0.357583000
	0.203548000	0.625006000	0.351108000
	0.213113000	0.629174000	0.344417000
	0.222923000	0.633289000	0.337508000
	0.232977000	0.637348000	0.330373000
	0.243271000	0.641349000	0.323009000
	0.253801000	0.645288000	0.315410000
	0.264568000	0.649162000	0.307569000
	0.275569000	0.652968000	0.299479000
	0.286801000	0.656701000	0.291134000
	0.298265000	0.660358000	0.282526000
	0.309959000	0.663936000	0.273646000
	0.321884000	0.667430000	0.264485000
	0.334037000	0.670836000	0.255031000
	0.346419000	0.674149000	0.245276000
	0.359031000	0.677365000	0.235204000
	0.371871000	0.680479000	0.224801000
	0.384937000	0.683487000	0.214057000
	0.398230000	0.686384000	0.202950000
	0.411744000	0.689164000	0.191467000
	0.425479000	0.691822000	0.179583000
	0.439427000	0.694355000	0.167283000
	0.453579000	0.696759000	0.154543000
	0.467926000	0.699028000	0.141341000
	0.482452000	0.701162000	0.127653000
	0.497138000	0.703158000	0.113456000
	0.511959000	0.705018000	0.098732000
	0.526885000	0.706743000	0.083460000
	0.541877000	0.708340000	0.067641000
	0.556892000	0.709816000	0.051296000
	0.571882000	0.711184000	0.034676000
	0.586792000	0.712458000	0.020965000
	0.601568000	0.713655000	0.011445000
	0.616155000	0.714797000	0.006284000
	0.630501000	0.715902000	0.005613000
	0.644562000	0.716993000	0.009520000
	0.658301000	0.718089000	0.018059000
	0.671690000	0.719210000	0.031256000
	0.684712000	0.720371000	0.048490000
	0.697354000	0.721585000	0.066111000
	0.709616000	0.722864000	0.083473000
	0.721500000	0.724216000	0.100550000
	0.733014000	0.725647000	0.117352000
	0.744168000	0.727162000	0.133899000
	0.754976000	0.728764000	0.150219000
	0.765451000	0.730455000	0.166337000
	0.775607000	0.732236000	0.182278000
	0.785459000	0.734106000	0.198068000
	0.795021000	0.736067000	0.213725000
	0.804305000	0.738117000	0.229274000
	0.813325000	0.740256000	0.244730000
	0.822092000	0.742482000	0.260110000
	0.830615000	0.744796000	0.275428000
	0.838906000	0.747197000	0.290697000
	0.846972000	0.749682000	0.305930000
	0.854821000	0.752253000	0.321137000
	0.862459000	0.754908000	0.336327000
	0.869894000	0.757647000	0.351507000
	0.877129000	0.760471000	0.366685000
	0.884170000	0.763378000	0.381868000
	0.891019000	0.766369000	0.397062000
	0.897680000	0.769444000	0.412270000
	0.904154000	0.772604000	0.427497000
	0.910444000	0.775849000	0.442747000
	0.916549000	0.779181000	0.458023000
	0.922469000	0.782600000	0.473326000
	0.928205000	0.786108000	0.488659000
	0.933755000	0.789706000	0.504022000
	0.939116000	0.793396000	0.519416000
	0.944288000	0.797181000	0.534840000
	0.949265000	0.801062000	0.550295000
	0.954045000	0.805042000	0.565776000
	0.958624000	0.809124000	0.581284000
	0.962995000	0.813310000	0.596813000
	0.967155000	0.817605000	0.612359000
	0.971097000	0.822010000	0.627917000
	0.974814000	0.826531000	0.643481000
	0.978300000	0.831170000	0.659041000
	0.981548000	0.835931000	0.674588000
	0.984550000	0.840820000	0.690110000
	0.987299000	0.845839000	0.705595000
	0.989788000	0.850993000	0.721026000
	0.992011000	0.856286000	0.736386000
	0.993962000	0.861720000	0.751655000
	0.995637000	0.867300000	0.766811000
	0.997031000	0.873027000	0.781827000
	0.998147000	0.878902000	0.796677000
	0.998984000	0.884927000	0.811330000
	0.999549000	0.891100000	0.825756000
	0.999852000	0.897418000	0.839919000
	0.999907000	0.903877000	0.853788000
	0.999733000	0.910470000	0.867327000
	0.999353000	0.917188000	0.880504000
	0.998801000	0.924021000	0.893287000
	0.998110000	0.930954000	0.905649000
	0.997324000	0.937972000	0.917564000
	0.996493000	0.945057000	0.929007000
	0.995676000	0.952187000	0.939959000
	0.994949000	0.959334000	0.950394000
	0.994422000	0.966461000	0.960272000
	0.994324000	0.973490000	0.969478000
	0.996026000	0.979967000	0.977163000
	0.997756000	0.986471000	0.984703000
	0.999047000	0.993159000	0.992341000
	1.000000000	1.000000000	1.000000000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
