
function cm = plasma(n, varargin)
% Colormap: plasma

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.050383000	0.029803000	0.527975000
	0.063536000	0.028426000	0.533124000
	0.075353000	0.027206000	0.538007000
	0.086222000	0.026125000	0.542658000
	0.096379000	0.025165000	0.547103000
	0.105980000	0.024309000	0.551368000
	0.115124000	0.023556000	0.555468000
	0.123903000	0.022878000	0.559423000
	0.132381000	0.022258000	0.563250000
	0.140603000	0.021687000	0.566959000
	0.148607000	0.021154000	0.570562000
	0.156421000	0.020651000	0.574065000
	0.164070000	0.020171000	0.577478000
	0.171574000	0.019706000	0.580806000
	0.178950000	0.019252000	0.584054000
	0.186213000	0.018803000	0.587228000
	0.193374000	0.018354000	0.590330000
	0.200445000	0.017902000	0.593364000
	0.207435000	0.017442000	0.596333000
	0.214350000	0.016973000	0.599239000
	0.221197000	0.016497000	0.602083000
	0.227983000	0.016007000	0.604867000
	0.234715000	0.015502000	0.607592000
	0.241396000	0.014979000	0.610259000
	0.248032000	0.014439000	0.612868000
	0.254627000	0.013882000	0.615419000
	0.261183000	0.013308000	0.617911000
	0.267703000	0.012716000	0.620346000
	0.274191000	0.012109000	0.622722000
	0.280648000	0.011488000	0.625038000
	0.287076000	0.010855000	0.627295000
	0.293478000	0.010213000	0.629490000
	0.299855000	0.009561000	0.631624000
	0.306210000	0.008902000	0.633694000
	0.312543000	0.008239000	0.635700000
	0.318856000	0.007576000	0.637640000
	0.325150000	0.006915000	0.639512000
	0.331426000	0.006261000	0.641316000
	0.337683000	0.005618000	0.643049000
	0.343925000	0.004991000	0.644710000
	0.350150000	0.004382000	0.646298000
	0.356359000	0.003798000	0.647810000
	0.362553000	0.003243000	0.649245000
	0.368733000	0.002724000	0.650601000
	0.374897000	0.002245000	0.651876000
	0.381047000	0.001814000	0.653068000
	0.387183000	0.001434000	0.654177000
	0.393304000	0.001114000	0.655199000
	0.399411000	0.000859000	0.656133000
	0.405503000	0.000678000	0.656977000
	0.411580000	0.000577000	0.657730000
	0.417642000	0.000564000	0.658390000
	0.423689000	0.000646000	0.658956000
	0.429719000	0.000831000	0.659425000
	0.435734000	0.001127000	0.659797000
	0.441732000	0.001540000	0.660069000
	0.447714000	0.002080000	0.660240000
	0.453677000	0.002755000	0.660310000
	0.459623000	0.003574000	0.660277000
	0.465550000	0.004545000	0.660139000
	0.471457000	0.005678000	0.659897000
	0.477344000	0.006980000	0.659549000
	0.483210000	0.008460000	0.659095000
	0.489055000	0.010127000	0.658534000
	0.494877000	0.011990000	0.657865000
	0.500678000	0.014055000	0.657088000
	0.506454000	0.016333000	0.656202000
	0.512206000	0.018833000	0.655209000
	0.517933000	0.021563000	0.654109000
	0.523633000	0.024532000	0.652901000
	0.529306000	0.027747000	0.651586000
	0.534952000	0.031217000	0.650165000
	0.540570000	0.034950000	0.648640000
	0.546157000	0.038954000	0.647010000
	0.551715000	0.043136000	0.645277000
	0.557243000	0.047331000	0.643443000
	0.562738000	0.051545000	0.641509000
	0.568201000	0.055778000	0.639477000
	0.573632000	0.060028000	0.637349000
	0.579029000	0.064296000	0.635126000
	0.584391000	0.068579000	0.632812000
	0.589719000	0.072878000	0.630408000
	0.595011000	0.077190000	0.627917000
	0.600266000	0.081516000	0.625342000
	0.605485000	0.085854000	0.622686000
	0.610667000	0.090204000	0.619951000
	0.615812000	0.094564000	0.617140000
	0.620919000	0.098934000	0.614257000
	0.625987000	0.103312000	0.611305000
	0.631017000	0.107699000	0.608287000
	0.636008000	0.112092000	0.605205000
	0.640959000	0.116492000	0.602065000
	0.645872000	0.120898000	0.598867000
	0.650746000	0.125309000	0.595617000
	0.655580000	0.129725000	0.592317000
	0.660374000	0.134144000	0.588971000
	0.665129000	0.138566000	0.585582000
	0.669845000	0.142992000	0.582154000
	0.674522000	0.147419000	0.578688000
	0.679160000	0.151848000	0.575189000
	0.683758000	0.156278000	0.571660000
	0.688318000	0.160709000	0.568103000
	0.692840000	0.165141000	0.564522000
	0.697324000	0.169573000	0.560919000
	0.701769000	0.174005000	0.557296000
	0.706178000	0.178437000	0.553657000
	0.710549000	0.182868000	0.550004000
	0.714883000	0.187299000	0.546338000
	0.719181000	0.191729000	0.542663000
	0.723444000	0.196158000	0.538981000
	0.727670000	0.200586000	0.535293000
	0.731862000	0.205013000	0.531601000
	0.736019000	0.209439000	0.527908000
	0.740143000	0.213864000	0.524216000
	0.744232000	0.218288000	0.520524000
	0.748289000	0.222711000	0.516834000
	0.752312000	0.227133000	0.513149000
	0.756304000	0.231555000	0.509468000
	0.760264000	0.235976000	0.505794000
	0.764193000	0.240396000	0.502126000
	0.768090000	0.244817000	0.498465000
	0.771958000	0.249237000	0.494813000
	0.775796000	0.253658000	0.491171000
	0.779604000	0.258078000	0.487539000
	0.783383000	0.262500000	0.483918000
	0.787133000	0.266922000	0.480307000
	0.790855000	0.271345000	0.476706000
	0.794549000	0.275770000	0.473117000
	0.798216000	0.280197000	0.469538000
	0.801855000	0.284626000	0.465971000
	0.805467000	0.289057000	0.462415000
	0.809052000	0.293491000	0.458870000
	0.812612000	0.297928000	0.455338000
	0.816144000	0.302368000	0.451816000
	0.819651000	0.306812000	0.448306000
	0.823132000	0.311261000	0.444806000
	0.826588000	0.315714000	0.441316000
	0.830018000	0.320172000	0.437836000
	0.833422000	0.324635000	0.434366000
	0.836801000	0.329105000	0.430905000
	0.840155000	0.333580000	0.427455000
	0.843484000	0.338062000	0.424013000
	0.846788000	0.342551000	0.420579000
	0.850066000	0.347048000	0.417153000
	0.853319000	0.351553000	0.413734000
	0.856547000	0.356066000	0.410322000
	0.859750000	0.360588000	0.406917000
	0.862927000	0.365119000	0.403519000
	0.866078000	0.369660000	0.400126000
	0.869203000	0.374212000	0.396738000
	0.872303000	0.378774000	0.393355000
	0.875376000	0.383347000	0.389976000
	0.878423000	0.387932000	0.386600000
	0.881443000	0.392529000	0.383229000
	0.884436000	0.397139000	0.379860000
	0.887402000	0.401762000	0.376494000
	0.890340000	0.406398000	0.373130000
	0.893250000	0.411048000	0.369768000
	0.896131000	0.415712000	0.366407000
	0.898984000	0.420392000	0.363047000
	0.901807000	0.425087000	0.359688000
	0.904601000	0.429797000	0.356329000
	0.907365000	0.434524000	0.352970000
	0.910098000	0.439268000	0.349610000
	0.912800000	0.444029000	0.346251000
	0.915471000	0.448807000	0.342890000
	0.918109000	0.453603000	0.339529000
	0.920714000	0.458417000	0.336166000
	0.923287000	0.463251000	0.332801000
	0.925825000	0.468103000	0.329435000
	0.928329000	0.472975000	0.326067000
	0.930798000	0.477867000	0.322697000
	0.933232000	0.482780000	0.319325000
	0.935630000	0.487712000	0.315952000
	0.937990000	0.492667000	0.312575000
	0.940313000	0.497642000	0.309197000
	0.942598000	0.502639000	0.305816000
	0.944844000	0.507658000	0.302433000
	0.947051000	0.512699000	0.299049000
	0.949217000	0.517763000	0.295662000
	0.951344000	0.522850000	0.292275000
	0.953428000	0.527960000	0.288883000
	0.955470000	0.533093000	0.285490000
	0.957469000	0.538250000	0.282096000
	0.959424000	0.543431000	0.278701000
	0.961336000	0.548636000	0.275305000
	0.963203000	0.553865000	0.271909000
	0.965024000	0.559118000	0.268513000
	0.966798000	0.564396000	0.265118000
	0.968526000	0.569700000	0.261721000
	0.970205000	0.575028000	0.258325000
	0.971835000	0.580382000	0.254931000
	0.973416000	0.585761000	0.251540000
	0.974947000	0.591165000	0.248151000
	0.976428000	0.596595000	0.244767000
	0.977856000	0.602051000	0.241387000
	0.979233000	0.607532000	0.238013000
	0.980556000	0.613039000	0.234646000
	0.981826000	0.618572000	0.231287000
	0.983041000	0.624131000	0.227937000
	0.984199000	0.629718000	0.224595000
	0.985301000	0.635330000	0.221265000
	0.986345000	0.640969000	0.217948000
	0.987332000	0.646633000	0.214648000
	0.988260000	0.652325000	0.211364000
	0.989128000	0.658043000	0.208100000
	0.989935000	0.663787000	0.204859000
	0.990681000	0.669558000	0.201642000
	0.991365000	0.675355000	0.198453000
	0.991985000	0.681179000	0.195295000
	0.992541000	0.687030000	0.192171000
	0.993032000	0.692907000	0.189084000
	0.993456000	0.698810000	0.186041000
	0.993814000	0.704741000	0.183043000
	0.994103000	0.710698000	0.180097000
	0.994324000	0.716681000	0.177208000
	0.994474000	0.722691000	0.174381000
	0.994553000	0.728728000	0.171622000
	0.994561000	0.734791000	0.168938000
	0.994495000	0.740880000	0.166335000
	0.994355000	0.746995000	0.163821000
	0.994141000	0.753137000	0.161404000
	0.993851000	0.759304000	0.159092000
	0.993482000	0.765499000	0.156891000
	0.993033000	0.771720000	0.154808000
	0.992505000	0.777967000	0.152855000
	0.991897000	0.784239000	0.151042000
	0.991209000	0.790537000	0.149377000
	0.990439000	0.796859000	0.147870000
	0.989587000	0.803205000	0.146529000
	0.988648000	0.809579000	0.145357000
	0.987621000	0.815978000	0.144363000
	0.986509000	0.822401000	0.143557000
	0.985314000	0.828846000	0.142945000
	0.984031000	0.835315000	0.142528000
	0.982653000	0.841812000	0.142303000
	0.981190000	0.848329000	0.142279000
	0.979644000	0.854866000	0.142453000
	0.977995000	0.861432000	0.142808000
	0.976265000	0.868016000	0.143351000
	0.974443000	0.874622000	0.144061000
	0.972530000	0.881250000	0.144923000
	0.970533000	0.887896000	0.145919000
	0.968443000	0.894564000	0.147014000
	0.966271000	0.901249000	0.148180000
	0.964021000	0.907950000	0.149370000
	0.961681000	0.914672000	0.150520000
	0.959276000	0.921407000	0.151566000
	0.956808000	0.928152000	0.152409000
	0.954287000	0.934908000	0.152921000
	0.951726000	0.941671000	0.152925000
	0.949151000	0.948435000	0.152178000
	0.946602000	0.955190000	0.150328000
	0.944152000	0.961916000	0.146861000
	0.941896000	0.968590000	0.140956000
	0.940015000	0.975158000	0.131326000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
