
function cm = oxy(n, varargin)
% Colormap: oxy from cmocean (data copy-pasted from ColorSchemes.jl)
% oxygen saturation in ocean water, diverging 80% of the way to represent
% a state of supersaturation. The bottom 20% of the colormap is colored
% reddish to highlight hypoxic or low oxygen water")

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.25032176905858416   0.020462373007628664   0.019668915240963425
	0.25556484590315925   0.021115914562057317   0.020900079605680265
	0.260801551287606   0.021764366566897772   0.02215967228611414
	0.26604462644840876   0.022383035772931454   0.023440162122590095
	0.2765326364024715   0.023561335944458806   0.026067621442162
	0.2817861616671274   0.024102040700526   0.027406852891152786
	0.2870367982396965   0.02462864448899237   0.028766693287901334
	0.29229647292718025   0.025115213825385452   0.03013810573921637
	0.3028221259572579   0.026009807799723155   0.032922206878895514
	0.3080989498969099   0.026391793653086672   0.034323445726190914
	0.3133766829953621   0.02674829090811269   0.03573422597599481
	0.31865531570069366   0.027079127219430545   0.03715280555634475
	0.32924566072594813   0.027587400661237986   0.039979156139025404
	0.3345444278514147   0.027794827950613325   0.0413706406541229
	0.3398547648028716   0.02794706430858016   0.04271748371599068
	0.34517249382192633   0.028053685024482643   0.04402857557145471
	0.3558206849295222   0.0281526333037441   0.04654771396733793
	0.36115912489428104   0.028122260666773778   0.04774545304821292
	0.36650538605257504   0.028042290914116412   0.04890135088859194
	0.37185717878462354   0.02791864422174392   0.05001583572284549
	0.38257894539736265   0.027534718313660875   0.05211053476335369
	0.38794954741145826   0.027272157544536355   0.053085096912266115
	0.39332998820186316   0.02695211659028964   0.05400332569218739
	0.39871727403227747   0.026583390141117245   0.05486495007360833
	0.40950809478480493   0.02571397721177637   0.05640694245975856
	0.4149106638808665   0.025217416553774786   0.05707880838445476
	0.4203169224276967   0.024684262851943115   0.057678291022847696
	0.42572564497608806   0.02411983059354548   0.05820016787208187
	0.4365491859863962   0.022908683302009045   0.05897909145270989
	0.44195989271872843   0.022280711559501974   0.05922145534252384
	0.44736413243777823   0.02166211126655112   0.059358278073057345
	0.45275754812847707   0.02107281505394201   0.059382131948203166
	0.46350709475737245   0.020024047465979106   0.05902266227273282
	0.46884497497466887   0.01964556257714446   0.058627764393172625
	0.4741516624279997   0.019402340589192137   0.05806380572763908
	0.47941182688110145   0.019363351000614242   0.057331018908608984
	0.48974345100760724   0.020146134792308878   0.055320019738505706
	0.4947824246224634   0.02112807697320262   0.05404462487713375
	0.4997137287427876   0.022619495056171248   0.05260678769207213
	0.5045221796142562   0.024700218814984028   0.05103037173727245
	0.5137301598248653   0.030864875760097502   0.04759930860912274
	0.5181239197849398   0.03500462903556055   0.045820425422232615
	0.5223830134996688   0.03984501254619848   0.04404711326285258
	0.5265167824786487   0.045116550723240174   0.04230178743284147
	0.5344521625028915   0.05613230116634508   0.03893707769140806
	0.5382767330694612   0.06174820344635037   0.037382246827492256
	0.5420185347623404   0.06738177887118912   0.03591446197845813
	0.5456872157339706   0.07300021292187203   0.03454024418762976
	0.5528333528391163   0.08412806121949529   0.03203530971705802
	0.5563218795889671   0.0896211548615796   0.03088637914922975
	0.5597632862141977   0.09505189218342755   0.029813731602715176
	0.3124295956605861   0.3104471192643529   0.30909262272555144
	0.3153354478588586   0.3133524060708574   0.3119821443435121
	0.31824305989224766   0.3162596157133579   0.31487354510523713
	0.32115221971252766   0.3191685075353222   0.3177665914743307
	0.32697542309980804   0.3249915726322321   0.32355785571741547
	0.32988958556325093   0.32790586210624356   0.32645618967304524
	0.3328058950511414   0.3308224519789741   0.32935678012827674
	0.3357242465615516   0.33374122160052   0.3322595102624681
	0.3415668398051759   0.33958502610190355   0.3380711247962143
	0.34449119400937284   0.34251017094898034   0.34098011903706754
	0.3474177171638534   0.3454376095238634   0.34389136888185307
	0.35034698338855336   0.34836794139503385   0.346805465369161
	0.35621236143814083   0.3542358046622061   0.352640745757892
	0.35914858037681685   0.35717344083567293   0.3555620343021813
	0.36208722341951666   0.36011361599156305   0.35848582427813286
	0.3650286939883333   0.36305674775961494   0.36141252807501206
	0.3709200935456274   0.3689518358458999   0.3672746363207957
	0.3738697751287151   0.37190352658604986   0.37020978034606317
	0.3768221792091647   0.3748580483073255   0.3731477173927215
	0.3797773564061295   0.3778154505573167   0.37608849693507174
	0.3856977984917309   0.38374071501836987   0.38198038140594964
	0.3886624779865983   0.3867079629882915   0.38493088138337844
	0.3916301675373727   0.389678323471107   0.38788445547990014
	0.39460091605125996   0.3926518443624523   0.39084115151341253
	0.40055295260897017   0.3986097611264988   0.39676528887887746
	0.40353411331378775   0.4015940188237795   0.39973259498361824
	0.4065185627017746   0.4045816619557017   0.4027032476697736
	0.40950634828178395   0.4075727370718815   0.4056772934047228
	0.415492795434692   0.41356606472920515   0.4116364375734102
	0.4184918779167747   0.4165687434984514   0.4146219586956935
	0.4214945204326191   0.4195750736283389   0.4176110918403175
	0.42450076936624254   0.4225851005893354   0.42060388239095875
	0.43052437250182096   0.4286165297439478   0.4266007190310782
	0.4335427826643468   0.43163900764725716   0.4296058306451354
	0.43656501838561024   0.434665397257347   0.43261481411662484
	0.43959112516553095   0.4376957432004656   0.43562771398038685
	0.44565513335980034   0.4437684820761267   0.4416654405060407
	0.44869368903939827   0.4468115388000441   0.44469092519180037
	0.4517368917688297   0.44985933527681526   0.4477211036271618
	0.4547842258698518   0.4529113434703738   0.4507554532964671
	0.46089146711387297   0.4590281706024677   0.4568368415436758
	0.4639514635319542   0.4620930771611265   0.45988396754605004
	0.46701686496082256   0.46516348464581553   0.4629365433533289
	0.47008677688273864   0.4682384803878612   0.4659936652121622
	0.4762399433154002   0.4744020380433919   0.4721213515388643
	0.47932328627791204   0.4774906868110462   0.4751920026556299
	0.48241157981572785   0.4805843644813184   0.47826763775129433
	0.4855054065192262   0.4836836604074203   0.48134884138053535
	0.4917071661727568   0.48989656843060064   0.4875254394390606
	0.4948151870857158   0.49301026694263855   0.490620920068211
	0.497928027327714   0.4961288527000837   0.49372124586446003
	0.5041707018503041   0.5023832495766818   0.4999389760567756
	0.5072996974715959   0.5055182071194114   0.5030555348110034
	0.5104337218186611   0.5086582576893807   0.5061771439834861
	0.5135728187816995   0.5118034444283539   0.5093038466023048
	0.5198680090904712   0.5181110205469276   0.5155743126495593
	0.5230240786607409   0.5212733823701987   0.5187180494068471
	0.5261854303107181   0.5244410863000215   0.5218670849934367
	0.5293521080119286   0.5276141755769954   0.5250214625310645
	0.5357023822572596   0.5339774558564434   0.5313471825523317
	0.5388868512651764   0.5371685253040657   0.5345193971027961
	0.5420768564731617   0.5403651867966881   0.5376971597230371
	0.545272442064579   0.543567483801437   0.5408805137559964
	0.5516805313407565   0.5499891584349246   0.5472641696469992
	0.5548945759211055   0.553210088520657   0.5504660124980879
	0.5581145670784501   0.5564370183489838   0.5536738091851505
	0.5613403945534087   0.5596698355312789   0.5568874483927889
	0.5678097368298003   0.5661533075224889   0.5633324294117918
	0.5710538502837967   0.5694045636227956   0.5665643684189754
	0.5743051694640114   0.5726630826009093   0.5698035160864107
	0.5775625831679843   0.5759277431077965   0.5730487596836393
	0.5840958744176996   0.5824756662065079   0.5795577116206488
	0.5873718422959868   0.5857590177478061   0.5828215086350755
	0.5906553283643479   0.5890499401540877   0.5860928212875073
	0.5939456863496749   0.5923477811162676   0.5893710023062436
	0.6005456518693509   0.5989628389111977   0.5959466004538667
	0.6038553509508688   0.602280145921328   0.5992441074734932
	0.6071717820521229   0.6056042263837068   0.6025483395942317
	0.6104964593110322   0.6089366020846008   0.6058608080471198
	0.6171658601273857   0.6156215142843694   0.6125057634705912
	0.6205106766639509   0.6189741424017309   0.6158383417607967
	0.623862299461208   0.622333613132911   0.6191777148380594
	0.6272217495526115   0.6257009516987573   0.6225249009896979
	0.6339633886626701   0.632458480253568   0.6292419666367618
	0.637344730790933   0.6358478171202773   0.6326109992853028
	0.6407331512665517   0.6392442647751326   0.6359870940032012
	0.644128697727182   0.642647870178569   0.6393702975927646
	0.6509452405110124   0.6494806387834576   0.6461620890521664
	0.6543645413031806   0.6529080970404894   0.6495689839578402
	0.6577911976868459   0.6563429394235857   0.6529832133417283
	0.6612252582674152   0.6597852138609859   0.6564048249672773
	0.6681185471134806   0.6666950204492558   0.6632731374913206
	0.6715772676011302   0.6701620407069336   0.6667193303275074
	0.6750436266693426   0.6736367241694728   0.6701731357532019
	0.678517673996441   0.6771191198362991   0.6736346025961091
	0.685490583067358   0.6841087989309357   0.6805822608627878
	0.6889902152593659   0.687616852735363   0.6840692180364434
	0.6924977753545576   0.6911328551431065   0.687564072190608
	0.6960133142099523   0.6946568563288202   0.6910668733210059
	0.703068780886553   0.7017293055249039   0.6980967646835469
	0.7066108508007372   0.7052798983395075   0.7016259863087929
	0.7101611448678149   0.7088387320594561   0.7051633961675597
	0.7172866142285044   0.7159813282321918   0.7122629858555887
	0.7208618943992978   0.719565194184362   0.71582526880799
	0.7244468165907456   0.7231587179839266   0.719397148563149
	0.7280414152493158   0.7267619329076519   0.7229786584068482
	0.7352564107249326   0.7339941964502681   0.7301673497187976
	0.7388769152586618   0.7376233513935839   0.733774637119419
	0.7425061631603387   0.7412612596920829   0.7373906233269836
	0.7461464606086874   0.7449102288687008   0.7410176017144567
	0.7534542299137884   0.7522353655092588   0.7482985885600492
	0.7571215953297079   0.7559114248995535   0.7519524898864893
	0.7607980221631284   0.7595965516360116   0.7556154028404163
	0.7644843645869689   0.7632915995427993   0.7592881761602848
	0.7718882453269261   0.7707129043795912   0.7666647413348012
	0.7756041540460803   0.77443752930021   0.7703669114468018
	0.7793294514661021   0.7781715447334472   0.7740784151337411
	0.7830641952537597   0.7819150076262106   0.777799309126386
	0.7905668625004234   0.7894351125938581   0.7852740763344663
	0.794333046186906   0.7932100130488933   0.7890262187563091
	0.7981089557544192   0.796994637012073   0.7927880264788568
	0.8018946506826832   0.8007890432303661   0.79655955802376
	0.809498735510421   0.8084105365473571   0.804135107432646
	0.81331697852586   0.8122374748676888   0.8079389777476483
	0.8171452951864402   0.8160744801984102   0.8117528555427497
	0.8209837469106039   0.8199216132106035   0.8155768012541027
	0.8286927840915763   0.8276479863786951   0.8232566109078919
	0.8325649270796638   0.8315287807573953   0.8271140202815063
	0.8364475027756378   0.8354199968604652   0.8309817904707685
	0.8403405746677917   0.8393216974124768   0.8348599839552472
	0.8481584625591254   0.8471568043142441   0.8426478922732167
	0.8520861550384412   0.8510930816852288   0.8465604617719047
	0.8560249024716683   0.8550403982451368   0.8504840066608007
	0.8599745194151317   0.8589985681043337   0.8544183422480285
	0.8679066262857829   0.8669477290320207   0.8623196457986929
	0.8718902314626645   0.8709398320337273   0.8662877195686166
	0.8758871280259101   0.8749452028944591   0.8702689853121507
	0.8798952803818768   0.8789618087644507   0.8742614219551689
	0.8879456264404303   0.88702899627762   0.8822800776100529
	0.8919879580252079   0.8910797141836339   0.8863064323430556
	0.8960441427301344   0.8951442561280015   0.8903465328361805
	0.9001128904953543   0.8992213337528863   0.8943990982004267
	0.908285637729791   0.9074106609684427   0.9025392027229122
	0.9123897802040108   0.9115230518994157   0.9066268826559936
	0.9165062601210144   0.9156477504829056   0.9107268012198582
	0.9206377372962851   0.919787408960455   0.9148415959800745
	0.9289371983431668   0.9281031383100254   0.9231073947496014
	0.9331053306682362   0.9322793559214043   0.9272585449078168
	0.9372858305148154   0.9364679073285836   0.9314219603563132
	0.9414805849385761   0.9406706735323028   0.9355995118038627
	0.9499112324285693   0.9491172259914931   0.9439954080097929
	0.9541456149743491   0.9533595046046891   0.9482122537117518
	0.9583928069476743   0.9576145538486545   0.9524417997736037
	0.9717386353800527   0.9973777600608619   0.4115658643585359
	0.9662006602777348   0.993726645981926   0.40232518119581634
	0.9607627521945551   0.9900572267174857   0.3929085929665735
	0.9554415272451376   0.9863634202187735   0.38330208519025977
	0.945224757475888   0.9788787426033022   0.36335720440407554
	0.9403922547690046   0.9750651532690909   0.3529658674736868
	0.9358012781940933   0.9711846436929118   0.3422125309180296
	0.931521900657607   0.9672115998149192   0.33105536171489763
	0.9243262891934023   0.9588257749438184   0.30744835670116216
	0.9217020058646493   0.954295165063129   0.29515795323361943
	0.919888737046915   0.9494613758630887   0.28299330593300415
	0.9188014423728452   0.9443342663663614   0.2716012421636956
	0.9177841550998648   0.9335426933786861   0.25248000016572114
	0.9174401026070885   0.9280407871647589   0.2446155106635522
	0.9170895513231806   0.9225221346800715   0.23759656244455835
	0.9167020828694254   0.9170043397013649   0.23124673824496145
	0.9157691900066246   0.9060063912564605   0.22005713608188132
	0.9152197058922081   0.900533802765957   0.21504179987008742
	0.9146241645334555   0.8950779708690549   0.2103289435929298
	0.9139711070576974   0.8896449914470077   0.20587612376631775
	0.9125407126803214   0.8788330083046588   0.19761251454601503
	0.9117530169460994   0.8734600806229882   0.19374979857114402
	0.9109311963239964   0.8681043338417845   0.19004032765360274
	0.9100752049629436   0.8627663273889324   0.18646838415176775
	0.9082549005100644   0.8521478984780773   0.17968211884884425
	0.9072929210165844   0.8468673217860987   0.17644545029690303
	0.9063013792870692   0.8416041433916347   0.17330194735987925
	0.9052811273728737   0.8363582655293055   0.1702439219249277
	0.9031581378443196   0.8259177493137719   0.16435796802914526
	0.902057262878912   0.8207226877358885   0.1615187200622499
	0.9009313663687085   0.8155441018959304   0.15874211240673433
	0.8997813459322432   0.8103817325993177   0.1560239134014782
	0.8974123625824063   0.8001045762385368   0.15074796136848082
	0.8961950196441476   0.7949892523212133   0.14818373065962578
	0.8949567873642768   0.7898890771497077   0.14566486352871547
	0.893698371171872   0.784803791183925   0.14318884251411537
	0.8911216151255343   0.7746778361440715   0.13835480304030517
	0.8898020181760183   0.7696378889985143   0.1359906608477614
	0.8884645911096111   0.7646119206511363   0.13366106059151575
	0.8871098774237283   0.7595996914637695   0.13136443029268266
	0.8843505587935225   0.7496155463925207   0.12686440488156295
	0.8829468419986223   0.7446432050409977   0.12465844029436216
	0.881524908551438   0.7396851204434678   0.12247764446514017
	0.8800852120157935   0.7347410842227018   0.12032085010229573
	0.8771622516330287   0.7248902111580254   0.11608344566490061
	0.8756795889485279   0.7199830249122412   0.11400110853293868
	0.874181868847392   0.7150884618420272   0.1119405415999486
	0.872666470131086   0.710207884512615   0.10989771859644232
	0.8695967618761147   0.7004812035381729   0.10587692666937212
	0.8680428176626152   0.695634824121185   0.10389774620271444
	0.8664728647912948   0.690801466531225   0.10193436755629554
	0.8648889520799001   0.6859800077414488   0.09998838514326469
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
