
function cm = ocean(n, varargin)
% Colormap: ocean

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.110363000	0.001691000	0.253026000
	0.112295000	0.006033000	0.257538000
	0.114180000	0.010608000	0.262052000
	0.116020000	0.015420000	0.266566000
	0.117813000	0.020473000	0.271076000
	0.119559000	0.025769000	0.275581000
	0.121258000	0.031314000	0.280079000
	0.122910000	0.037110000	0.284567000
	0.124516000	0.043066000	0.289045000
	0.126074000	0.048803000	0.293509000
	0.127585000	0.054341000	0.297960000
	0.129049000	0.059715000	0.302396000
	0.130467000	0.064950000	0.306815000
	0.131837000	0.070068000	0.311216000
	0.133160000	0.075085000	0.315599000
	0.134436000	0.080014000	0.319962000
	0.135665000	0.084868000	0.324305000
	0.136846000	0.089655000	0.328626000
	0.137981000	0.094383000	0.332924000
	0.139069000	0.099060000	0.337199000
	0.140110000	0.103690000	0.341449000
	0.141104000	0.108279000	0.345674000
	0.142051000	0.112831000	0.349873000
	0.142951000	0.117350000	0.354045000
	0.143805000	0.121839000	0.358190000
	0.144612000	0.126301000	0.362305000
	0.145373000	0.130739000	0.366392000
	0.146087000	0.135155000	0.370448000
	0.146756000	0.139551000	0.374473000
	0.147379000	0.143930000	0.378466000
	0.147956000	0.148292000	0.382427000
	0.148488000	0.152639000	0.386354000
	0.148976000	0.156972000	0.390248000
	0.149419000	0.161293000	0.394106000
	0.149818000	0.165603000	0.397930000
	0.150174000	0.169902000	0.401717000
	0.150488000	0.174192000	0.405468000
	0.150759000	0.178473000	0.409181000
	0.150989000	0.182746000	0.412857000
	0.151178000	0.187011000	0.416494000
	0.151327000	0.191269000	0.420093000
	0.151437000	0.195520000	0.423652000
	0.151510000	0.199766000	0.427171000
	0.151545000	0.204005000	0.430650000
	0.151545000	0.208239000	0.434088000
	0.151510000	0.212467000	0.437486000
	0.151442000	0.216690000	0.440842000
	0.151342000	0.220909000	0.444157000
	0.151211000	0.225122000	0.447430000
	0.151052000	0.229331000	0.450662000
	0.150865000	0.233535000	0.453852000
	0.150653000	0.237734000	0.457000000
	0.150417000	0.241929000	0.460107000
	0.150158000	0.246119000	0.463171000
	0.149880000	0.250304000	0.466194000
	0.149584000	0.254485000	0.469176000
	0.149271000	0.258662000	0.472116000
	0.148945000	0.262833000	0.475016000
	0.148608000	0.267000000	0.477874000
	0.148261000	0.271161000	0.480693000
	0.147907000	0.275318000	0.483471000
	0.147548000	0.279470000	0.486210000
	0.147188000	0.283617000	0.488910000
	0.146828000	0.287759000	0.491572000
	0.146471000	0.291895000	0.494196000
	0.146120000	0.296026000	0.496782000
	0.145777000	0.300152000	0.499331000
	0.145445000	0.304272000	0.501845000
	0.145126000	0.308387000	0.504323000
	0.144824000	0.312496000	0.506766000
	0.144541000	0.316600000	0.509175000
	0.144280000	0.320698000	0.511551000
	0.144043000	0.324790000	0.513894000
	0.143834000	0.328876000	0.516205000
	0.143654000	0.332957000	0.518485000
	0.143507000	0.337032000	0.520735000
	0.143394000	0.341102000	0.522955000
	0.143320000	0.345165000	0.525146000
	0.143285000	0.349223000	0.527309000
	0.143293000	0.353275000	0.529445000
	0.143346000	0.357322000	0.531555000
	0.143446000	0.361363000	0.533639000
	0.143596000	0.365398000	0.535697000
	0.143796000	0.369428000	0.537732000
	0.144051000	0.373452000	0.539743000
	0.144361000	0.377471000	0.541731000
	0.144727000	0.381484000	0.543697000
	0.145153000	0.385493000	0.545641000
	0.145639000	0.389496000	0.547565000
	0.146187000	0.393494000	0.549469000
	0.146798000	0.397487000	0.551354000
	0.147474000	0.401475000	0.553220000
	0.148215000	0.405458000	0.555068000
	0.149022000	0.409437000	0.556898000
	0.149896000	0.413411000	0.558711000
	0.150838000	0.417381000	0.560508000
	0.151848000	0.421347000	0.562289000
	0.152927000	0.425308000	0.564055000
	0.154075000	0.429265000	0.565806000
	0.155292000	0.433218000	0.567543000
	0.156579000	0.437168000	0.569266000
	0.157935000	0.441113000	0.570976000
	0.159360000	0.445055000	0.572673000
	0.160854000	0.448994000	0.574357000
	0.162417000	0.452929000	0.576030000
	0.164048000	0.456862000	0.577691000
	0.165748000	0.460791000	0.579340000
	0.167515000	0.464717000	0.580979000
	0.169349000	0.468640000	0.582606000
	0.171249000	0.472560000	0.584224000
	0.173216000	0.476478000	0.585831000
	0.175248000	0.480393000	0.587429000
	0.177344000	0.484306000	0.589017000
	0.179505000	0.488217000	0.590596000
	0.181729000	0.492125000	0.592166000
	0.184016000	0.496031000	0.593728000
	0.186365000	0.499935000	0.595280000
	0.188775000	0.503838000	0.596825000
	0.191246000	0.507738000	0.598361000
	0.193777000	0.511637000	0.599889000
	0.196368000	0.515533000	0.601409000
	0.199019000	0.519429000	0.602921000
	0.201727000	0.523322000	0.604426000
	0.204494000	0.527214000	0.605923000
	0.207319000	0.531105000	0.607413000
	0.210201000	0.534994000	0.608895000
	0.213140000	0.538881000	0.610370000
	0.216136000	0.542767000	0.611838000
	0.219188000	0.546652000	0.613299000
	0.222296000	0.550535000	0.614753000
	0.225461000	0.554417000	0.616200000
	0.228682000	0.558297000	0.617639000
	0.231959000	0.562176000	0.619072000
	0.235293000	0.566053000	0.620498000
	0.238683000	0.569928000	0.621917000
	0.242129000	0.573802000	0.623330000
	0.245633000	0.577674000	0.624735000
	0.249194000	0.581544000	0.626134000
	0.252812000	0.585411000	0.627526000
	0.256489000	0.589277000	0.628911000
	0.260225000	0.593141000	0.630289000
	0.264020000	0.597002000	0.631661000
	0.267876000	0.600860000	0.633027000
	0.271793000	0.604715000	0.634385000
	0.275772000	0.608567000	0.635738000
	0.279814000	0.612416000	0.637084000
	0.283921000	0.616261000	0.638424000
	0.288092000	0.620102000	0.639758000
	0.292331000	0.623939000	0.641086000
	0.296638000	0.627771000	0.642408000
	0.301014000	0.631598000	0.643724000
	0.305461000	0.635419000	0.645036000
	0.309981000	0.639234000	0.646343000
	0.314576000	0.643043000	0.647645000
	0.319247000	0.646845000	0.648943000
	0.323996000	0.650639000	0.650237000
	0.328826000	0.654426000	0.651529000
	0.333738000	0.658203000	0.652818000
	0.338735000	0.661971000	0.654106000
	0.343819000	0.665728000	0.655393000
	0.348992000	0.669475000	0.656681000
	0.354256000	0.673209000	0.657970000
	0.359614000	0.676931000	0.659262000
	0.365068000	0.680639000	0.660558000
	0.370621000	0.684332000	0.661861000
	0.376275000	0.688010000	0.663171000
	0.382031000	0.691671000	0.664492000
	0.387893000	0.695314000	0.665825000
	0.393862000	0.698939000	0.667173000
	0.399939000	0.702544000	0.668540000
	0.406126000	0.706127000	0.669928000
	0.412423000	0.709689000	0.671341000
	0.418832000	0.713228000	0.672783000
	0.425351000	0.716743000	0.674258000
	0.431980000	0.720233000	0.675770000
	0.438718000	0.723698000	0.677325000
	0.445561000	0.727137000	0.678928000
	0.452508000	0.730549000	0.680584000
	0.459553000	0.733935000	0.682297000
	0.466691000	0.737294000	0.684074000
	0.473918000	0.740628000	0.685919000
	0.481225000	0.743936000	0.687837000
	0.488606000	0.747219000	0.689834000
	0.496053000	0.750479000	0.691913000
	0.503557000	0.753717000	0.694078000
	0.511110000	0.756934000	0.696333000
	0.518702000	0.760132000	0.698679000
	0.526326000	0.763313000	0.701119000
	0.533972000	0.766480000	0.703654000
	0.541633000	0.769633000	0.706284000
	0.549302000	0.772776000	0.709010000
	0.556972000	0.775909000	0.711830000
	0.564637000	0.779036000	0.714743000
	0.572291000	0.782158000	0.717748000
	0.579929000	0.785277000	0.720843000
	0.587548000	0.788395000	0.724025000
	0.595145000	0.791512000	0.727293000
	0.602716000	0.794632000	0.730643000
	0.610258000	0.797754000	0.734073000
	0.617772000	0.800881000	0.737580000
	0.625254000	0.804013000	0.741162000
	0.632704000	0.807153000	0.744815000
	0.640122000	0.810299000	0.748537000
	0.647507000	0.813455000	0.752325000
	0.654858000	0.816619000	0.756177000
	0.662177000	0.819794000	0.760090000
	0.669464000	0.822980000	0.764062000
	0.676718000	0.826177000	0.768091000
	0.683940000	0.829386000	0.772174000
	0.691131000	0.832607000	0.776309000
	0.698292000	0.835842000	0.780494000
	0.705423000	0.839089000	0.784728000
	0.712525000	0.842351000	0.789009000
	0.719599000	0.845627000	0.793334000
	0.726646000	0.848917000	0.797703000
	0.733666000	0.852223000	0.802113000
	0.740660000	0.855544000	0.806563000
	0.747630000	0.858880000	0.811052000
	0.754576000	0.862232000	0.815579000
	0.761499000	0.865600000	0.820142000
	0.768399000	0.868985000	0.824739000
	0.775279000	0.872386000	0.829371000
	0.782137000	0.875804000	0.834035000
	0.788975000	0.879240000	0.838730000
	0.795795000	0.882692000	0.843456000
	0.802596000	0.886163000	0.848212000
	0.809379000	0.889651000	0.852996000
	0.816145000	0.893157000	0.857808000
	0.822895000	0.896682000	0.862646000
	0.829629000	0.900225000	0.867510000
	0.836347000	0.903787000	0.872399000
	0.843051000	0.907368000	0.877312000
	0.849741000	0.910968000	0.882248000
	0.856417000	0.914588000	0.887207000
	0.863080000	0.918227000	0.892187000
	0.869731000	0.921887000	0.897188000
	0.876369000	0.925567000	0.902209000
	0.882995000	0.929268000	0.907248000
	0.889609000	0.932989000	0.912306000
	0.896212000	0.936732000	0.917381000
	0.902803000	0.940497000	0.922471000
	0.909383000	0.944284000	0.927577000
	0.915952000	0.948093000	0.932697000
	0.922510000	0.951926000	0.937830000
	0.929056000	0.955782000	0.942975000
	0.935590000	0.959662000	0.948130000
	0.942112000	0.963567000	0.953295000
	0.948620000	0.967497000	0.958467000
	0.955115000	0.971454000	0.963646000
	0.961594000	0.975438000	0.968831000
	0.968055000	0.979451000	0.974019000
	0.974497000	0.983494000	0.979210000
	0.980916000	0.987569000	0.984403000
	0.987309000	0.991677000	0.989598000
	0.993672000	0.995820000	0.994796000
	1.000000000	1.000000000	1.000000000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
