
function cm = nuclear(n, varargin)
% Colormap: nuclear

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.000000000	0.000000000	0.000000000
	0.000219000	0.000178000	0.000256000
	0.000768000	0.000609000	0.000925000
	0.001607000	0.001248000	0.001996000
	0.002720000	0.002074000	0.003475000
	0.004097000	0.003071000	0.005378000
	0.005730000	0.004231000	0.007722000
	0.007614000	0.005543000	0.010528000
	0.009743000	0.007002000	0.013816000
	0.012114000	0.008602000	0.017609000
	0.014722000	0.010338000	0.021932000
	0.017564000	0.012204000	0.026808000
	0.020635000	0.014199000	0.032265000
	0.023932000	0.016317000	0.038330000
	0.027451000	0.018556000	0.044814000
	0.031189000	0.020913000	0.051320000
	0.035140000	0.023385000	0.057855000
	0.039301000	0.025970000	0.064424000
	0.043542000	0.028666000	0.071033000
	0.047710000	0.031471000	0.077685000
	0.051818000	0.034383000	0.084384000
	0.055867000	0.037400000	0.091133000
	0.059858000	0.040520000	0.097934000
	0.063792000	0.043617000	0.104791000
	0.067668000	0.046674000	0.111706000
	0.071488000	0.049696000	0.118681000
	0.075250000	0.052683000	0.125718000
	0.078955000	0.055639000	0.132820000
	0.082600000	0.058566000	0.139987000
	0.086186000	0.061466000	0.147221000
	0.089711000	0.064341000	0.154524000
	0.093172000	0.067194000	0.161896000
	0.096568000	0.070027000	0.169337000
	0.099895000	0.072843000	0.176849000
	0.103151000	0.075644000	0.184432000
	0.106331000	0.078434000	0.192084000
	0.109432000	0.081216000	0.199805000
	0.112448000	0.083993000	0.207594000
	0.115375000	0.086770000	0.215448000
	0.118204000	0.089551000	0.223364000
	0.120931000	0.092341000	0.231337000
	0.123544000	0.095147000	0.239364000
	0.126036000	0.097974000	0.247435000
	0.128395000	0.100830000	0.255544000
	0.130608000	0.103725000	0.263677000
	0.132661000	0.106668000	0.271820000
	0.134539000	0.109670000	0.279955000
	0.136222000	0.112745000	0.288060000
	0.137692000	0.115908000	0.296105000
	0.138928000	0.119174000	0.304055000
	0.139905000	0.122561000	0.311868000
	0.140604000	0.126089000	0.319492000
	0.141003000	0.129773000	0.326868000
	0.141089000	0.133631000	0.333930000
	0.140855000	0.137673000	0.340608000
	0.140306000	0.141903000	0.346835000
	0.139461000	0.146318000	0.352557000
	0.138353000	0.150901000	0.357733000
	0.137026000	0.155631000	0.362348000
	0.135530000	0.160477000	0.366409000
	0.133917000	0.165410000	0.369945000
	0.132235000	0.170399000	0.372997000
	0.130528000	0.175417000	0.375616000
	0.128831000	0.180442000	0.377853000
	0.127174000	0.185454000	0.379761000
	0.125580000	0.190441000	0.381387000
	0.124067000	0.195393000	0.382772000
	0.122649000	0.200303000	0.383954000
	0.121337000	0.205165000	0.384967000
	0.120138000	0.209979000	0.385836000
	0.119058000	0.214741000	0.386587000
	0.118101000	0.219452000	0.387241000
	0.117269000	0.224113000	0.387814000
	0.116562000	0.228724000	0.388321000
	0.115980000	0.233287000	0.388774000
	0.115523000	0.237803000	0.389186000
	0.115187000	0.242276000	0.389565000
	0.114970000	0.246706000	0.389919000
	0.114869000	0.251096000	0.390255000
	0.114879000	0.255449000	0.390578000
	0.114995000	0.259765000	0.390894000
	0.115213000	0.264049000	0.391207000
	0.115526000	0.268301000	0.391520000
	0.115930000	0.272523000	0.391836000
	0.116417000	0.276719000	0.392158000
	0.116982000	0.280889000	0.392487000
	0.117618000	0.285036000	0.392826000
	0.118318000	0.289162000	0.393176000
	0.119076000	0.293268000	0.393537000
	0.119885000	0.297357000	0.393911000
	0.120739000	0.301430000	0.394297000
	0.121630000	0.305488000	0.394696000
	0.122553000	0.309534000	0.395108000
	0.123501000	0.313569000	0.395532000
	0.124468000	0.317593000	0.395968000
	0.125447000	0.321610000	0.396416000
	0.126432000	0.325620000	0.396875000
	0.127419000	0.329625000	0.397343000
	0.128401000	0.333625000	0.397820000
	0.129373000	0.337623000	0.398305000
	0.130330000	0.341619000	0.398795000
	0.131266000	0.345614000	0.399290000
	0.132178000	0.349609000	0.399787000
	0.133061000	0.353606000	0.400286000
	0.133911000	0.357606000	0.400784000
	0.134723000	0.361609000	0.401280000
	0.135494000	0.365616000	0.401771000
	0.136221000	0.369627000	0.402255000
	0.136901000	0.373645000	0.402730000
	0.137530000	0.377669000	0.403194000
	0.138106000	0.381700000	0.403645000
	0.138627000	0.385738000	0.404081000
	0.139090000	0.389785000	0.404499000
	0.139494000	0.393840000	0.404896000
	0.139836000	0.397904000	0.405271000
	0.140116000	0.401977000	0.405621000
	0.140332000	0.406060000	0.405945000
	0.140484000	0.410152000	0.406238000
	0.140570000	0.414255000	0.406500000
	0.140590000	0.418367000	0.406728000
	0.140544000	0.422490000	0.406920000
	0.140431000	0.426623000	0.407073000
	0.140253000	0.430767000	0.407185000
	0.140009000	0.434921000	0.407255000
	0.139700000	0.439085000	0.407280000
	0.139327000	0.443260000	0.407258000
	0.138891000	0.447444000	0.407187000
	0.138393000	0.451639000	0.407065000
	0.137835000	0.455844000	0.406891000
	0.137218000	0.460058000	0.406663000
	0.136544000	0.464281000	0.406378000
	0.135815000	0.468514000	0.406036000
	0.135034000	0.472755000	0.405634000
	0.134202000	0.477006000	0.405171000
	0.133324000	0.481264000	0.404646000
	0.132401000	0.485531000	0.404057000
	0.131437000	0.489806000	0.403402000
	0.130436000	0.494088000	0.402681000
	0.129401000	0.498377000	0.401891000
	0.128337000	0.502674000	0.401032000
	0.127248000	0.506977000	0.400102000
	0.126139000	0.511286000	0.399100000
	0.125014000	0.515601000	0.398024000
	0.123880000	0.519921000	0.396875000
	0.122741000	0.524247000	0.395649000
	0.121606000	0.528578000	0.394347000
	0.120479000	0.532913000	0.392966000
	0.119370000	0.537252000	0.391506000
	0.118284000	0.541596000	0.389966000
	0.117230000	0.545942000	0.388344000
	0.116217000	0.550292000	0.386639000
	0.115254000	0.554645000	0.384850000
	0.114351000	0.559000000	0.382975000
	0.113517000	0.563357000	0.381014000
	0.112764000	0.567716000	0.378965000
	0.112101000	0.572076000	0.376827000
	0.111541000	0.576437000	0.374597000
	0.111095000	0.580799000	0.372275000
	0.110774000	0.585161000	0.369860000
	0.110591000	0.589522000	0.367349000
	0.110558000	0.593884000	0.364741000
	0.110687000	0.598244000	0.362035000
	0.110989000	0.602603000	0.359227000
	0.111475000	0.606959000	0.356317000
	0.112156000	0.611314000	0.353303000
	0.113042000	0.615666000	0.350181000
	0.114144000	0.620015000	0.346950000
	0.115469000	0.624360000	0.343608000
	0.117025000	0.628701000	0.340151000
	0.118819000	0.633038000	0.336578000
	0.120857000	0.637369000	0.332884000
	0.123143000	0.641694000	0.329067000
	0.125681000	0.646013000	0.325123000
	0.128474000	0.650325000	0.321049000
	0.131523000	0.654629000	0.316840000
	0.134831000	0.658925000	0.312493000
	0.138397000	0.663212000	0.308002000
	0.142221000	0.667489000	0.303361000
	0.146303000	0.671755000	0.298566000
	0.150643000	0.676009000	0.293611000
	0.155240000	0.680250000	0.288489000
	0.160093000	0.684478000	0.283192000
	0.165202000	0.688691000	0.277711000
	0.170567000	0.692887000	0.272041000
	0.176190000	0.697065000	0.266167000
	0.182069000	0.701225000	0.260082000
	0.188209000	0.705363000	0.253770000
	0.194612000	0.709478000	0.247221000
	0.201282000	0.713569000	0.240417000
	0.208225000	0.717632000	0.233340000
	0.215448000	0.721664000	0.225971000
	0.222959000	0.725664000	0.218288000
	0.230770000	0.729627000	0.210263000
	0.238894000	0.733549000	0.201868000
	0.247348000	0.737425000	0.193068000
	0.256153000	0.741250000	0.183817000
	0.265332000	0.745018000	0.174077000
	0.274916000	0.748719000	0.163784000
	0.284940000	0.752346000	0.152881000
	0.295446000	0.755887000	0.141293000
	0.306485000	0.759327000	0.128940000
	0.318120000	0.762649000	0.115738000
	0.330415000	0.765833000	0.101625000
	0.343439000	0.768855000	0.086604000
	0.357252000	0.771687000	0.070852000
	0.371858000	0.774306000	0.055012000
	0.387164000	0.776700000	0.040729000
	0.402911000	0.778887000	0.031747000
	0.418690000	0.780923000	0.031097000
	0.434074000	0.782883000	0.039037000
	0.448767000	0.784840000	0.053422000
	0.462657000	0.786838000	0.070275000
	0.475747000	0.788901000	0.087739000
	0.488113000	0.791036000	0.105020000
	0.499840000	0.793241000	0.121821000
	0.511011000	0.795513000	0.138060000
	0.521703000	0.797846000	0.153747000
	0.531978000	0.800235000	0.168919000
	0.541894000	0.802674000	0.183630000
	0.551489000	0.805160000	0.197923000
	0.560808000	0.807688000	0.211854000
	0.569878000	0.810255000	0.225456000
	0.578731000	0.812858000	0.238772000
	0.587386000	0.815493000	0.251830000
	0.595865000	0.818159000	0.264657000
	0.604184000	0.820854000	0.277277000
	0.612360000	0.823576000	0.289714000
	0.620405000	0.826323000	0.301985000
	0.628327000	0.829095000	0.314098000
	0.636143000	0.831888000	0.326081000
	0.643855000	0.834705000	0.337930000
	0.651476000	0.837542000	0.349670000
	0.659012000	0.840399000	0.361305000
	0.666467000	0.843276000	0.372839000
	0.673850000	0.846172000	0.384285000
	0.681166000	0.849086000	0.395650000
	0.688418000	0.852017000	0.406939000
	0.695611000	0.854966000	0.418156000
	0.702750000	0.857932000	0.429305000
	0.709836000	0.860915000	0.440393000
	0.716875000	0.863915000	0.451421000
	0.723870000	0.866931000	0.462394000
	0.730822000	0.869963000	0.473316000
	0.737735000	0.873010000	0.484191000
	0.744612000	0.876074000	0.495020000
	0.751453000	0.879154000	0.505801000
	0.758261000	0.882249000	0.516539000
	0.765039000	0.885360000	0.527241000
	0.771789000	0.888487000	0.537905000
	0.778510000	0.891630000	0.548526000
	0.785207000	0.894788000	0.559117000
	0.791879000	0.897962000	0.569673000
	0.798527000	0.901152000	0.580193000
	0.805156000	0.904357000	0.590686000
	0.811761000	0.907580000	0.601141000
	0.818351000	0.910817000	0.611575000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
