
function cm = magma(n, varargin)
% Colormap: magma

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.001462000	0.000466000	0.013866000
	0.002258000	0.001295000	0.018331000
	0.003279000	0.002305000	0.023708000
	0.004512000	0.003490000	0.029965000
	0.005950000	0.004843000	0.037130000
	0.007588000	0.006356000	0.044973000
	0.009426000	0.008022000	0.052844000
	0.011465000	0.009828000	0.060750000
	0.013708000	0.011771000	0.068667000
	0.016156000	0.013840000	0.076603000
	0.018815000	0.016026000	0.084584000
	0.021692000	0.018320000	0.092610000
	0.024792000	0.020715000	0.100676000
	0.028123000	0.023201000	0.108787000
	0.031696000	0.025765000	0.116965000
	0.035520000	0.028397000	0.125209000
	0.039608000	0.031090000	0.133515000
	0.043830000	0.033830000	0.141886000
	0.048062000	0.036607000	0.150327000
	0.052320000	0.039407000	0.158841000
	0.056615000	0.042160000	0.167446000
	0.060949000	0.044794000	0.176129000
	0.065330000	0.047318000	0.184892000
	0.069764000	0.049726000	0.193735000
	0.074257000	0.052017000	0.202660000
	0.078815000	0.054184000	0.211667000
	0.083446000	0.056225000	0.220755000
	0.088155000	0.058133000	0.229922000
	0.092949000	0.059904000	0.239164000
	0.097833000	0.061531000	0.248477000
	0.102815000	0.063010000	0.257854000
	0.107899000	0.064335000	0.267289000
	0.113094000	0.065492000	0.276784000
	0.118405000	0.066479000	0.286321000
	0.123833000	0.067295000	0.295879000
	0.129380000	0.067935000	0.305443000
	0.135053000	0.068391000	0.315000000
	0.140858000	0.068654000	0.324538000
	0.146785000	0.068738000	0.334011000
	0.152839000	0.068637000	0.343404000
	0.159018000	0.068354000	0.352688000
	0.165308000	0.067911000	0.361816000
	0.171713000	0.067305000	0.370771000
	0.178212000	0.066576000	0.379497000
	0.184801000	0.065732000	0.387973000
	0.191460000	0.064818000	0.396152000
	0.198177000	0.063862000	0.404009000
	0.204935000	0.062907000	0.411514000
	0.211718000	0.061992000	0.418647000
	0.218512000	0.061158000	0.425392000
	0.225302000	0.060445000	0.431742000
	0.232077000	0.059889000	0.437695000
	0.238826000	0.059517000	0.443256000
	0.245543000	0.059352000	0.448436000
	0.252220000	0.059415000	0.453248000
	0.258857000	0.059706000	0.457710000
	0.265447000	0.060237000	0.461840000
	0.271994000	0.060994000	0.465660000
	0.278493000	0.061978000	0.469190000
	0.284951000	0.063168000	0.472451000
	0.291366000	0.064553000	0.475462000
	0.297740000	0.066117000	0.478243000
	0.304081000	0.067835000	0.480812000
	0.310382000	0.069702000	0.483186000
	0.316654000	0.071690000	0.485380000
	0.322899000	0.073782000	0.487408000
	0.329114000	0.075972000	0.489287000
	0.335308000	0.078236000	0.491024000
	0.341482000	0.080564000	0.492631000
	0.347636000	0.082946000	0.494121000
	0.353773000	0.085373000	0.495501000
	0.359898000	0.087831000	0.496778000
	0.366012000	0.090314000	0.497960000
	0.372116000	0.092816000	0.499053000
	0.378211000	0.095332000	0.500067000
	0.384299000	0.097855000	0.501002000
	0.390384000	0.100379000	0.501864000
	0.396467000	0.102902000	0.502658000
	0.402548000	0.105420000	0.503386000
	0.408629000	0.107930000	0.504052000
	0.414709000	0.110431000	0.504662000
	0.420791000	0.112920000	0.505215000
	0.426877000	0.115395000	0.505714000
	0.432967000	0.117855000	0.506160000
	0.439062000	0.120298000	0.506555000
	0.445163000	0.122724000	0.506901000
	0.451271000	0.125132000	0.507198000
	0.457386000	0.127522000	0.507448000
	0.463508000	0.129893000	0.507652000
	0.469640000	0.132245000	0.507809000
	0.475780000	0.134578000	0.507921000
	0.481929000	0.136891000	0.507989000
	0.488088000	0.139186000	0.508011000
	0.494258000	0.141462000	0.507988000
	0.500438000	0.143719000	0.507920000
	0.506629000	0.145958000	0.507806000
	0.512831000	0.148179000	0.507648000
	0.519045000	0.150383000	0.507443000
	0.525270000	0.152569000	0.507192000
	0.531507000	0.154739000	0.506895000
	0.537755000	0.156894000	0.506551000
	0.544015000	0.159033000	0.506159000
	0.550287000	0.161158000	0.505719000
	0.556571000	0.163269000	0.505230000
	0.562866000	0.165368000	0.504692000
	0.569172000	0.167454000	0.504105000
	0.575490000	0.169530000	0.503466000
	0.581819000	0.171596000	0.502777000
	0.588158000	0.173652000	0.502035000
	0.594508000	0.175701000	0.501241000
	0.600868000	0.177743000	0.500394000
	0.607238000	0.179779000	0.499492000
	0.613617000	0.181811000	0.498536000
	0.620005000	0.183840000	0.497524000
	0.626401000	0.185867000	0.496456000
	0.632805000	0.187893000	0.495332000
	0.639216000	0.189921000	0.494150000
	0.645633000	0.191952000	0.492910000
	0.652056000	0.193986000	0.491611000
	0.658483000	0.196027000	0.490253000
	0.664915000	0.198075000	0.488836000
	0.671349000	0.200133000	0.487358000
	0.677786000	0.202203000	0.485819000
	0.684224000	0.204286000	0.484219000
	0.690661000	0.206384000	0.482558000
	0.697098000	0.208501000	0.480835000
	0.703532000	0.210638000	0.479049000
	0.709962000	0.212797000	0.477201000
	0.716387000	0.214982000	0.475290000
	0.722805000	0.217194000	0.473316000
	0.729216000	0.219437000	0.471279000
	0.735616000	0.221713000	0.469180000
	0.742004000	0.224025000	0.467018000
	0.748378000	0.226377000	0.464794000
	0.754737000	0.228772000	0.462509000
	0.761077000	0.231214000	0.460162000
	0.767398000	0.233705000	0.457755000
	0.773695000	0.236249000	0.455289000
	0.779968000	0.238851000	0.452765000
	0.786212000	0.241514000	0.450184000
	0.792427000	0.244242000	0.447543000
	0.798608000	0.247040000	0.444848000
	0.804752000	0.249911000	0.442102000
	0.810855000	0.252861000	0.439305000
	0.816914000	0.255895000	0.436461000
	0.822926000	0.259016000	0.433573000
	0.828886000	0.262229000	0.430644000
	0.834791000	0.265540000	0.427671000
	0.840636000	0.268953000	0.424666000
	0.846416000	0.272473000	0.421631000
	0.852126000	0.276106000	0.418573000
	0.857763000	0.279857000	0.415496000
	0.863320000	0.283729000	0.412403000
	0.868793000	0.287728000	0.409303000
	0.874176000	0.291859000	0.406205000
	0.879464000	0.296125000	0.403118000
	0.884651000	0.300530000	0.400047000
	0.889731000	0.305079000	0.397002000
	0.894700000	0.309773000	0.393995000
	0.899552000	0.314616000	0.391037000
	0.904281000	0.319610000	0.388137000
	0.908884000	0.324755000	0.385308000
	0.913354000	0.330052000	0.382563000
	0.917689000	0.335500000	0.379915000
	0.921884000	0.341098000	0.377376000
	0.925937000	0.346844000	0.374959000
	0.929845000	0.352734000	0.372677000
	0.933606000	0.358764000	0.370541000
	0.937221000	0.364929000	0.368567000
	0.940687000	0.371224000	0.366762000
	0.944006000	0.377643000	0.365136000
	0.947180000	0.384178000	0.363701000
	0.950210000	0.390820000	0.362468000
	0.953099000	0.397563000	0.361438000
	0.955849000	0.404400000	0.360619000
	0.958464000	0.411324000	0.360014000
	0.960949000	0.418323000	0.359630000
	0.963310000	0.425390000	0.359469000
	0.965549000	0.432519000	0.359529000
	0.967671000	0.439703000	0.359810000
	0.969680000	0.446936000	0.360311000
	0.971582000	0.454210000	0.361030000
	0.973381000	0.461520000	0.361965000
	0.975082000	0.468861000	0.363111000
	0.976690000	0.476226000	0.364466000
	0.978210000	0.483612000	0.366025000
	0.979645000	0.491014000	0.367783000
	0.981000000	0.498428000	0.369734000
	0.982279000	0.505851000	0.371874000
	0.983485000	0.513280000	0.374198000
	0.984622000	0.520713000	0.376698000
	0.985693000	0.528148000	0.379371000
	0.986700000	0.535582000	0.382210000
	0.987646000	0.543015000	0.385210000
	0.988533000	0.550446000	0.388365000
	0.989363000	0.557873000	0.391671000
	0.990138000	0.565296000	0.395122000
	0.990871000	0.572706000	0.398714000
	0.991558000	0.580107000	0.402441000
	0.992196000	0.587502000	0.406299000
	0.992785000	0.594891000	0.410283000
	0.993326000	0.602275000	0.414390000
	0.993834000	0.609644000	0.418613000
	0.994309000	0.616999000	0.422950000
	0.994738000	0.624350000	0.427397000
	0.995122000	0.631696000	0.431951000
	0.995480000	0.639027000	0.436607000
	0.995810000	0.646344000	0.441361000
	0.996096000	0.653659000	0.446213000
	0.996341000	0.660969000	0.451160000
	0.996580000	0.668256000	0.456192000
	0.996775000	0.675541000	0.461314000
	0.996925000	0.682828000	0.466526000
	0.997077000	0.690088000	0.471811000
	0.997186000	0.697349000	0.477182000
	0.997254000	0.704611000	0.482635000
	0.997325000	0.711848000	0.488154000
	0.997351000	0.719089000	0.493755000
	0.997351000	0.726324000	0.499428000
	0.997341000	0.733545000	0.505167000
	0.997285000	0.740772000	0.510983000
	0.997228000	0.747981000	0.516859000
	0.997138000	0.755190000	0.522806000
	0.997019000	0.762398000	0.528821000
	0.996898000	0.769591000	0.534892000
	0.996727000	0.776795000	0.541039000
	0.996571000	0.783977000	0.547233000
	0.996369000	0.791167000	0.553499000
	0.996162000	0.798348000	0.559820000
	0.995932000	0.805527000	0.566202000
	0.995680000	0.812706000	0.572645000
	0.995424000	0.819875000	0.579140000
	0.995131000	0.827052000	0.585701000
	0.994851000	0.834213000	0.592307000
	0.994524000	0.841387000	0.598983000
	0.994222000	0.848540000	0.605696000
	0.993866000	0.855711000	0.612482000
	0.993545000	0.862859000	0.619299000
	0.993170000	0.870024000	0.626189000
	0.992831000	0.877168000	0.633109000
	0.992440000	0.884330000	0.640099000
	0.992089000	0.891470000	0.647116000
	0.991688000	0.898627000	0.654202000
	0.991332000	0.905763000	0.661309000
	0.990930000	0.912915000	0.668481000
	0.990570000	0.920049000	0.675675000
	0.990175000	0.927196000	0.682926000
	0.989815000	0.934329000	0.690198000
	0.989434000	0.941470000	0.697519000
	0.989077000	0.948604000	0.704863000
	0.988717000	0.955742000	0.712242000
	0.988367000	0.962878000	0.719649000
	0.988033000	0.970012000	0.727077000
	0.987691000	0.977154000	0.734536000
	0.987387000	0.984288000	0.742002000
	0.987053000	0.991438000	0.749504000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
