
function cm = lavender(n, varargin)
% Colormap: lavender

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.000000000	0.000000000	0.000000000
	0.000226000	0.000127000	0.000180000
	0.000814000	0.000429000	0.000640000
	0.001743000	0.000864000	0.001355000
	0.003012000	0.001410000	0.002321000
	0.004626000	0.002053000	0.003540000
	0.006590000	0.002781000	0.005016000
	0.008910000	0.003582000	0.006755000
	0.011591000	0.004449000	0.008764000
	0.014641000	0.005373000	0.011053000
	0.018068000	0.006348000	0.013632000
	0.021877000	0.007366000	0.016511000
	0.026076000	0.008420000	0.019703000
	0.030671000	0.009506000	0.023221000
	0.035671000	0.010616000	0.027079000
	0.041069000	0.011746000	0.031293000
	0.046529000	0.012890000	0.035880000
	0.051962000	0.014041000	0.040848000
	0.057373000	0.015197000	0.045923000
	0.062762000	0.016349000	0.051029000
	0.068133000	0.017495000	0.056172000
	0.073487000	0.018628000	0.061356000
	0.078825000	0.019744000	0.066586000
	0.084148000	0.020838000	0.071866000
	0.089459000	0.021904000	0.077202000
	0.094756000	0.022938000	0.082598000
	0.100042000	0.023934000	0.088057000
	0.105316000	0.024889000	0.093584000
	0.110579000	0.025795000	0.099184000
	0.115830000	0.026650000	0.104861000
	0.121071000	0.027448000	0.110619000
	0.126299000	0.028183000	0.116462000
	0.131516000	0.028853000	0.122393000
	0.136720000	0.029450000	0.128419000
	0.141911000	0.029972000	0.134542000
	0.147088000	0.030413000	0.140767000
	0.152250000	0.030769000	0.147098000
	0.157395000	0.031036000	0.153539000
	0.162523000	0.031209000	0.160094000
	0.167631000	0.031285000	0.166768000
	0.172719000	0.031260000	0.173563000
	0.177783000	0.031132000	0.180483000
	0.182822000	0.030897000	0.187532000
	0.187833000	0.030553000	0.194713000
	0.192813000	0.030100000	0.202029000
	0.197760000	0.029535000	0.209483000
	0.202669000	0.028861000	0.217075000
	0.207537000	0.028076000	0.224810000
	0.212360000	0.027185000	0.232685000
	0.217134000	0.026190000	0.240703000
	0.221853000	0.025098000	0.248862000
	0.226513000	0.023915000	0.257161000
	0.231108000	0.022651000	0.265596000
	0.235632000	0.021317000	0.274165000
	0.240079000	0.019929000	0.282860000
	0.244442000	0.018502000	0.291676000
	0.248714000	0.017057000	0.300605000
	0.252887000	0.015618000	0.309634000
	0.256954000	0.014212000	0.318754000
	0.260907000	0.012868000	0.327950000
	0.264739000	0.011621000	0.337207000
	0.268439000	0.010510000	0.346506000
	0.272002000	0.009577000	0.355829000
	0.275418000	0.008865000	0.365155000
	0.278679000	0.008424000	0.374463000
	0.281779000	0.008305000	0.383728000
	0.284711000	0.008560000	0.392927000
	0.287467000	0.009244000	0.402036000
	0.290042000	0.010412000	0.411030000
	0.292431000	0.012120000	0.419885000
	0.294630000	0.014423000	0.428577000
	0.296635000	0.017372000	0.437083000
	0.298445000	0.021019000	0.445384000
	0.300058000	0.025410000	0.453460000
	0.301473000	0.030588000	0.461292000
	0.302691000	0.036593000	0.468866000
	0.303714000	0.043346000	0.476168000
	0.304544000	0.050309000	0.483188000
	0.305184000	0.057397000	0.489917000
	0.305637000	0.064579000	0.496349000
	0.305910000	0.071827000	0.502480000
	0.306006000	0.079119000	0.508307000
	0.305932000	0.086435000	0.513831000
	0.305693000	0.093759000	0.519053000
	0.305297000	0.101077000	0.523976000
	0.304750000	0.108376000	0.528605000
	0.304060000	0.115645000	0.532946000
	0.303232000	0.122876000	0.537006000
	0.302276000	0.130059000	0.540793000
	0.301199000	0.137189000	0.544315000
	0.300007000	0.144258000	0.547582000
	0.298708000	0.151264000	0.550603000
	0.297311000	0.158200000	0.553388000
	0.295822000	0.165064000	0.555948000
	0.294248000	0.171852000	0.558293000
	0.292596000	0.178563000	0.560432000
	0.290874000	0.185196000	0.562378000
	0.289089000	0.191748000	0.564139000
	0.287245000	0.198219000	0.565726000
	0.285352000	0.204608000	0.567150000
	0.283413000	0.210916000	0.568419000
	0.281437000	0.217142000	0.569543000
	0.279427000	0.223288000	0.570532000
	0.277390000	0.229353000	0.571394000
	0.275332000	0.235338000	0.572138000
	0.273257000	0.241246000	0.572771000
	0.271171000	0.247076000	0.573303000
	0.269078000	0.252831000	0.573739000
	0.266982000	0.258511000	0.574089000
	0.264889000	0.264118000	0.574358000
	0.262802000	0.269654000	0.574553000
	0.260725000	0.275120000	0.574681000
	0.258662000	0.280519000	0.574746000
	0.256616000	0.285851000	0.574756000
	0.254591000	0.291120000	0.574714000
	0.252590000	0.296325000	0.574627000
	0.250615000	0.301470000	0.574499000
	0.248670000	0.306556000	0.574334000
	0.246757000	0.311586000	0.574137000
	0.244878000	0.316560000	0.573912000
	0.243034000	0.321481000	0.573661000
	0.241229000	0.326350000	0.573390000
	0.239463000	0.331169000	0.573101000
	0.237738000	0.335941000	0.572796000
	0.236055000	0.340667000	0.572480000
	0.234415000	0.345348000	0.572155000
	0.232819000	0.349987000	0.571822000
	0.231267000	0.354585000	0.571485000
	0.229760000	0.359144000	0.571145000
	0.228297000	0.363665000	0.570804000
	0.226878000	0.368150000	0.570465000
	0.225504000	0.372602000	0.570128000
	0.224173000	0.377020000	0.569795000
	0.222884000	0.381408000	0.569468000
	0.221637000	0.385766000	0.569147000
	0.220430000	0.390096000	0.568833000
	0.219262000	0.394400000	0.568528000
	0.218131000	0.398679000	0.568231000
	0.217036000	0.402934000	0.567945000
	0.215973000	0.407168000	0.567668000
	0.214942000	0.411380000	0.567402000
	0.213939000	0.415574000	0.567146000
	0.212963000	0.419749000	0.566901000
	0.212009000	0.423907000	0.566667000
	0.211077000	0.428050000	0.566443000
	0.210161000	0.432179000	0.566229000
	0.209260000	0.436296000	0.566025000
	0.208370000	0.440400000	0.565830000
	0.207488000	0.444494000	0.565644000
	0.206611000	0.448578000	0.565466000
	0.205734000	0.452655000	0.565295000
	0.204855000	0.456724000	0.565130000
	0.203969000	0.460786000	0.564971000
	0.203074000	0.464844000	0.564815000
	0.202165000	0.468897000	0.564663000
	0.201240000	0.472947000	0.564512000
	0.200293000	0.476995000	0.564362000
	0.199322000	0.481041000	0.564211000
	0.198323000	0.485087000	0.564057000
	0.197292000	0.489132000	0.563898000
	0.196226000	0.493179000	0.563734000
	0.195122000	0.497227000	0.563562000
	0.193976000	0.501277000	0.563380000
	0.192784000	0.505330000	0.563188000
	0.191543000	0.509386000	0.562982000
	0.190251000	0.513446000	0.562760000
	0.188904000	0.517511000	0.562522000
	0.187500000	0.521581000	0.562264000
	0.186034000	0.525656000	0.561985000
	0.184506000	0.529737000	0.561683000
	0.182912000	0.533823000	0.561355000
	0.181250000	0.537916000	0.561000000
	0.179517000	0.542016000	0.560614000
	0.177712000	0.546122000	0.560197000
	0.175833000	0.550235000	0.559746000
	0.173877000	0.554355000	0.559259000
	0.171844000	0.558482000	0.558733000
	0.169733000	0.562616000	0.558166000
	0.167541000	0.566757000	0.557557000
	0.165268000	0.570905000	0.556904000
	0.162914000	0.575061000	0.556203000
	0.160478000	0.579223000	0.555454000
	0.157960000	0.583392000	0.554653000
	0.155360000	0.587567000	0.553800000
	0.152680000	0.591748000	0.552892000
	0.149920000	0.595936000	0.551927000
	0.147082000	0.600130000	0.550904000
	0.144167000	0.604329000	0.549819000
	0.141179000	0.608533000	0.548673000
	0.138120000	0.612742000	0.547462000
	0.134996000	0.616955000	0.546185000
	0.131809000	0.621173000	0.544840000
	0.128567000	0.625393000	0.543426000
	0.125276000	0.629618000	0.541941000
	0.121945000	0.633844000	0.540383000
	0.118582000	0.638073000	0.538751000
	0.115201000	0.642304000	0.537043000
	0.111813000	0.646536000	0.535258000
	0.108435000	0.650768000	0.533394000
	0.105084000	0.655000000	0.531449000
	0.101783000	0.659232000	0.529424000
	0.098554000	0.663463000	0.527315000
	0.095426000	0.667691000	0.525122000
	0.092429000	0.671917000	0.522843000
	0.089600000	0.676140000	0.520477000
	0.086978000	0.680360000	0.518023000
	0.084606000	0.684574000	0.515480000
	0.082530000	0.688784000	0.512846000
	0.080799000	0.692987000	0.510119000
	0.079462000	0.697184000	0.507300000
	0.078570000	0.701374000	0.504386000
	0.078166000	0.705555000	0.501376000
	0.078293000	0.709726000	0.498270000
	0.078986000	0.713888000	0.495066000
	0.080267000	0.718039000	0.491763000
	0.082151000	0.722179000	0.488359000
	0.084644000	0.726306000	0.484854000
	0.087737000	0.730419000	0.481247000
	0.091418000	0.734517000	0.477536000
	0.095663000	0.738600000	0.473721000
	0.100445000	0.742666000	0.469799000
	0.105736000	0.746714000	0.465772000
	0.111502000	0.750744000	0.461635000
	0.117715000	0.754753000	0.457391000
	0.124342000	0.758741000	0.453035000
	0.131356000	0.762706000	0.448569000
	0.138731000	0.766647000	0.443992000
	0.146445000	0.770563000	0.439301000
	0.154476000	0.774451000	0.434497000
	0.162807000	0.778311000	0.429579000
	0.171422000	0.782141000	0.424546000
	0.180309000	0.785938000	0.419398000
	0.189457000	0.789702000	0.414135000
	0.198856000	0.793429000	0.408757000
	0.208501000	0.797119000	0.403264000
	0.218385000	0.800768000	0.397656000
	0.228505000	0.804374000	0.391936000
	0.238858000	0.807935000	0.386104000
	0.249443000	0.811447000	0.380163000
	0.260260000	0.814909000	0.374118000
	0.271309000	0.818316000	0.367972000
	0.282591000	0.821665000	0.361733000
	0.294111000	0.824953000	0.355406000
	0.305868000	0.828175000	0.349003000
	0.317870000	0.831328000	0.342536000
	0.330116000	0.834407000	0.336021000
	0.342612000	0.837407000	0.329479000
	0.355360000	0.840322000	0.322935000
	0.368362000	0.843149000	0.316419000
	0.381618000	0.845882000	0.309973000
	0.395125000	0.848515000	0.303642000
	0.408877000	0.851043000	0.297486000
	0.422866000	0.853463000	0.291572000
	0.437071000	0.855771000	0.285984000
	0.451470000	0.857964000	0.280814000
	0.466027000	0.860043000	0.276167000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
