
function cm = lajolla(n, varargin)
% Colormap: lajolla

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.100226644	0.100908457	0.003791345
	0.105487212	0.102956193	0.007623843
	0.110583872	0.104991742	0.011622045
	0.115699087	0.107133590	0.015460303
	0.120855422	0.109197696	0.019283161
	0.126157425	0.111254971	0.023109830
	0.131462861	0.113321010	0.026942531
	0.136816115	0.115318578	0.030783747
	0.142250702	0.117348127	0.034740254
	0.147732203	0.119395181	0.038691024
	0.153228764	0.121394305	0.042481719
	0.158832498	0.123420614	0.046062104
	0.164453840	0.125481387	0.049639515
	0.170113967	0.127477485	0.052899180
	0.175797417	0.129510078	0.056198009
	0.181557762	0.131529617	0.059336901
	0.187395140	0.133540714	0.062322869
	0.193222390	0.135533075	0.065213384
	0.199088769	0.137585842	0.068083588
	0.205032058	0.139542604	0.070836850
	0.211004811	0.141605145	0.073581417
	0.217021015	0.143615928	0.076120395
	0.223073904	0.145658655	0.078687195
	0.229142270	0.147662982	0.081329293
	0.235262744	0.149700964	0.083951414
	0.241378598	0.151697724	0.086566603
	0.247533869	0.153731799	0.089259692
	0.253709490	0.155804072	0.092000776
	0.259912827	0.157832660	0.094763909
	0.266142571	0.159860412	0.097519589
	0.272374016	0.161968939	0.100317811
	0.278670013	0.164035507	0.103209050
	0.284955193	0.166066638	0.106100692
	0.291300567	0.168139868	0.108996214
	0.297641729	0.170234126	0.111956563
	0.304013090	0.172305168	0.114879704
	0.310431058	0.174410925	0.117925495
	0.316844119	0.176475375	0.120914890
	0.323292867	0.178607635	0.123971787
	0.329770768	0.180679010	0.127045645
	0.336248091	0.182782485	0.130207534
	0.342780244	0.184917444	0.133291611
	0.349311896	0.187021136	0.136394429
	0.355878825	0.189132937	0.139537120
	0.362454678	0.191237725	0.142740245
	0.369062747	0.193367069	0.145929728
	0.375682360	0.195474318	0.149098278
	0.382326211	0.197596594	0.152278328
	0.389004674	0.199695582	0.155501482
	0.395693282	0.201817890	0.158717037
	0.402387152	0.203967947	0.161932001
	0.409121179	0.206083066	0.165093754
	0.415865126	0.208175972	0.168311629
	0.422622165	0.210282243	0.171513187
	0.429411773	0.212396693	0.174725170
	0.436212961	0.214489903	0.177922538
	0.443028400	0.216604218	0.181049316
	0.449857694	0.218684282	0.184220456
	0.456701109	0.220787889	0.187383090
	0.463562150	0.222858591	0.190481310
	0.470445945	0.224903133	0.193599064
	0.477332126	0.226998642	0.196690059
	0.484231796	0.229060068	0.199703107
	0.491166144	0.231121849	0.202743768
	0.498094694	0.233151819	0.205757040
	0.505025166	0.235232578	0.208714777
	0.511976602	0.237280284	0.211665211
	0.518950159	0.239300775	0.214547761
	0.525921116	0.241340210	0.217418270
	0.532905789	0.243359720	0.220254465
	0.539894090	0.245395628	0.223035962
	0.546904088	0.247453687	0.225780379
	0.553913987	0.249483390	0.228486866
	0.560933613	0.251554001	0.231137927
	0.567965036	0.253603610	0.233731608
	0.574999593	0.255667918	0.236326635
	0.582044338	0.257746691	0.238831070
	0.589092987	0.259865648	0.241320345
	0.596156424	0.261986787	0.243733659
	0.603221850	0.264149483	0.246122328
	0.610287256	0.266331601	0.248484803
	0.617360228	0.268553292	0.250755571
	0.624438060	0.270822723	0.253003158
	0.631513942	0.273124977	0.255206396
	0.638588508	0.275495675	0.257342159
	0.645659675	0.277907173	0.259453149
	0.652728757	0.280374693	0.261494462
	0.659797442	0.282950264	0.263515055
	0.666845732	0.285556532	0.265463082
	0.673888902	0.288275530	0.267363127
	0.680906207	0.291082665	0.269266240
	0.687912795	0.293959702	0.271084639
	0.694882302	0.296965341	0.272861823
	0.701821243	0.300045120	0.274597443
	0.708732248	0.303234622	0.276314276
	0.715588459	0.306560884	0.277960038
	0.722382988	0.309983329	0.279577909
	0.729129247	0.313514504	0.281126959
	0.735800868	0.317162815	0.282680357
	0.742403621	0.320939745	0.284148483
	0.748910383	0.324812886	0.285587350
	0.755331532	0.328832400	0.286993499
	0.761639954	0.332954478	0.288365905
	0.767838716	0.337176341	0.289693629
	0.773917752	0.341509353	0.290977705
	0.779868834	0.345934961	0.292217641
	0.785683211	0.350488068	0.293413208
	0.791345700	0.355117310	0.294574987
	0.796857158	0.359813122	0.295701773
	0.802212374	0.364594675	0.296799596
	0.807405841	0.369452480	0.297832349
	0.812424633	0.374377641	0.298849995
	0.817275021	0.379340646	0.299820607
	0.821953961	0.384355602	0.300746198
	0.826450363	0.389415237	0.301643581
	0.830772571	0.394499534	0.302508506
	0.834915952	0.399603487	0.303343452
	0.838883013	0.404734814	0.304148147
	0.842682348	0.409885902	0.304924258
	0.846302373	0.415022780	0.305674895
	0.849765582	0.420166442	0.306384487
	0.853059013	0.425309681	0.307054663
	0.856198342	0.430435792	0.307703508
	0.859184102	0.435556259	0.308347910
	0.862028818	0.440642742	0.308972368
	0.864725319	0.445721030	0.309558933
	0.867291603	0.450788394	0.310125655
	0.869731563	0.455821715	0.310676282
	0.872057100	0.460829282	0.311197665
	0.874260231	0.465813209	0.311697668
	0.876360058	0.470784289	0.312193319
	0.878362752	0.475721376	0.312685188
	0.880268116	0.480621778	0.313166598
	0.882089687	0.485504572	0.313631624
	0.883832005	0.490371528	0.314076064
	0.885494433	0.495204776	0.314507087
	0.887088498	0.500007370	0.314937624
	0.888621927	0.504805973	0.315369583
	0.890091398	0.509569473	0.315792603
	0.891510688	0.514321768	0.316200632
	0.892880011	0.519048702	0.316599083
	0.894205781	0.523753379	0.316994402
	0.895488441	0.528446346	0.317388438
	0.896735642	0.533118736	0.317780536
	0.897944828	0.537786049	0.318170497
	0.899128649	0.542430784	0.318559040
	0.900281644	0.547063447	0.318947085
	0.901410620	0.551690829	0.319336316
	0.902519882	0.556296020	0.319728892
	0.903607256	0.560903887	0.320125189
	0.904677318	0.565497710	0.320521431
	0.905735057	0.570089954	0.320914031
	0.906774659	0.574674047	0.321308361
	0.907806424	0.579264855	0.321715291
	0.908821273	0.583836478	0.322139787
	0.909834099	0.588408260	0.322573836
	0.910836552	0.592993627	0.323009845
	0.911831833	0.597565121	0.323452950
	0.912823868	0.602139200	0.323912165
	0.913813919	0.606722380	0.324390745
	0.914795544	0.611306428	0.324888723
	0.915774492	0.615891205	0.325408146
	0.916761820	0.620494070	0.325952596
	0.917745193	0.625091705	0.326525410
	0.918721197	0.629703514	0.327129797
	0.919707518	0.634335952	0.327768816
	0.920690767	0.638968381	0.328448078
	0.921685265	0.643617467	0.329172718
	0.922678727	0.648286314	0.329930846
	0.923677852	0.652970571	0.330727730
	0.924676099	0.657687856	0.331596260
	0.925689327	0.662415226	0.332545235
	0.926703515	0.667161038	0.333537020
	0.927726774	0.671938490	0.334612814
	0.928759741	0.676745565	0.335754784
	0.929803598	0.681569817	0.336993276
	0.930856785	0.686437596	0.338315989
	0.931914700	0.691330044	0.339766675
	0.932985964	0.696264335	0.341304149
	0.934069985	0.701224128	0.342972943
	0.935167268	0.706227285	0.344749642
	0.936279269	0.711263782	0.346674040
	0.937397375	0.716337254	0.348738214
	0.938528849	0.721439664	0.350959583
	0.939675353	0.726590469	0.353323137
	0.940831863	0.731775153	0.355870869
	0.942003049	0.736993494	0.358569785
	0.943185735	0.742247240	0.361471999
	0.944379374	0.747533260	0.364549211
	0.945583488	0.752838350	0.367823439
	0.946797333	0.758183463	0.371294769
	0.948021664	0.763539153	0.374976941
	0.949252388	0.768914934	0.378860255
	0.950492693	0.774304503	0.382955131
	0.951734379	0.779702688	0.387244417
	0.952984888	0.785102880	0.391761066
	0.954232740	0.790490586	0.396470206
	0.955483409	0.795868066	0.401394374
	0.956726870	0.801227740	0.406514955
	0.957973362	0.806563797	0.411826212
	0.959208161	0.811858827	0.417337219
	0.960438572	0.817113804	0.423008507
	0.961653264	0.822324026	0.428873652
	0.962863505	0.827471293	0.434900591
	0.964054325	0.832559657	0.441065331
	0.965232150	0.837582475	0.447382634
	0.966394231	0.842526099	0.453838007
	0.967540495	0.847384180	0.460403401
	0.968660953	0.852168775	0.467097673
	0.969761158	0.856853370	0.473868522
	0.970841116	0.861451220	0.480734721
	0.971900458	0.865954463	0.487690523
	0.972935832	0.870355182	0.494698197
	0.973942970	0.874664818	0.501763715
	0.974928779	0.878872724	0.508877524
	0.975891632	0.882982281	0.516015587
	0.976832884	0.886997064	0.523209051
	0.977749248	0.890912186	0.530410528
	0.978639722	0.894738218	0.537636384
	0.979514525	0.898463354	0.544863882
	0.980361831	0.902106172	0.552105756
	0.981188177	0.905664522	0.559340113
	0.981996083	0.909132372	0.566580620
	0.982780056	0.912527714	0.573807714
	0.983544145	0.915842161	0.581031345
	0.984295174	0.919090326	0.588240997
	0.985024053	0.922275548	0.595447879
	0.985734363	0.925389683	0.602638378
	0.986430044	0.928445083	0.609814132
	0.987109988	0.931449426	0.616981026
	0.987770352	0.934398567	0.624131311
	0.988416569	0.937305935	0.631264892
	0.989052800	0.940165943	0.638383129
	0.989672360	0.942983778	0.645487384
	0.990275810	0.945762082	0.652582969
	0.990866921	0.948508279	0.659669579
	0.991445259	0.951226130	0.666735802
	0.992010702	0.953913666	0.673800575
	0.992564079	0.956573592	0.680846090
	0.993104050	0.959212459	0.687893927
	0.993628770	0.961826421	0.694923798
	0.994139561	0.964425815	0.701947801
	0.994638042	0.967011220	0.708976208
	0.995123911	0.969576858	0.715989309
	0.995596563	0.972134088	0.722988659
	0.996055800	0.974672980	0.729998215
	0.996501432	0.977208351	0.736994954
	0.996933092	0.979734208	0.743990989
	0.997350363	0.982251966	0.750989141
	0.997752949	0.984762752	0.757976833
	0.998140591	0.987267870	0.764967418
	0.998512787	0.989767949	0.771954000
	0.998868692	0.992264835	0.778939940
	0.999207519	0.994756733	0.785930819
	0.999528586	0.997249112	0.792917518
	0.999831313	0.999744586	0.799907260
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
