
function cm = internet(n, varargin)
% Colormap: internet

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.023500000	0.011800000	0.423500000
	0.031400000	0.000000000	0.462700000
	0.051000000	0.000000000	0.454900000
	0.066700000	0.007800000	0.458800000
	0.082400000	0.007800000	0.462700000
	0.090200000	0.011800000	0.466700000
	0.105900000	0.015700000	0.462700000
	0.121600000	0.023500000	0.470600000
	0.133300000	0.019600000	0.470600000
	0.145100000	0.027500000	0.486300000
	0.164700000	0.031400000	0.478400000
	0.172500000	0.039200000	0.482400000
	0.192200000	0.039200000	0.490200000
	0.200000000	0.047100000	0.486300000
	0.215700000	0.051000000	0.490200000
	0.235300000	0.051000000	0.502000000
	0.243100000	0.054900000	0.486300000
	0.258800000	0.062700000	0.498000000
	0.278400000	0.066700000	0.494100000
	0.286300000	0.066700000	0.498000000
	0.305900000	0.074500000	0.505900000
	0.309800000	0.078400000	0.509800000
	0.325500000	0.082400000	0.502000000
	0.337300000	0.086300000	0.517600000
	0.352900000	0.094100000	0.521600000
	0.360800000	0.098000000	0.513700000
	0.376500000	0.105900000	0.521600000
	0.388200000	0.105900000	0.525500000
	0.400000000	0.109800000	0.525500000
	0.419600000	0.117600000	0.533300000
	0.435300000	0.113700000	0.533300000
	0.443100000	0.121600000	0.525500000
	0.462700000	0.129400000	0.533300000
	0.470600000	0.129400000	0.529400000
	0.486300000	0.133300000	0.537300000
	0.505900000	0.137300000	0.541200000
	0.517600000	0.137300000	0.541200000
	0.529400000	0.145100000	0.541200000
	0.545100000	0.149000000	0.549000000
	0.556900000	0.156900000	0.552900000
	0.568600000	0.160800000	0.552900000
	0.580400000	0.164700000	0.552900000
	0.603900000	0.164700000	0.564700000
	0.619600000	0.168600000	0.560800000
	0.627500000	0.172500000	0.560800000
	0.647100000	0.180400000	0.560800000
	0.658800000	0.180400000	0.564700000
	0.662700000	0.188200000	0.560800000
	0.682400000	0.188200000	0.564700000
	0.702000000	0.192200000	0.572500000
	0.713700000	0.200000000	0.572500000
	0.725500000	0.200000000	0.576500000
	0.745100000	0.207800000	0.580400000
	0.749000000	0.215700000	0.576500000
	0.760800000	0.223500000	0.584300000
	0.772500000	0.227500000	0.588200000
	0.788200000	0.223500000	0.596100000
	0.800000000	0.231400000	0.600000000
	0.815700000	0.235300000	0.600000000
	0.823500000	0.239200000	0.600000000
	0.843100000	0.239200000	0.615700000
	0.854900000	0.247100000	0.607800000
	0.870600000	0.251000000	0.619600000
	0.890200000	0.247100000	0.619600000
	0.902000000	0.254900000	0.623500000
	0.917600000	0.258800000	0.623500000
	0.925500000	0.262700000	0.627500000
	0.937300000	0.266700000	0.627500000
	0.956900000	0.274500000	0.631400000
	0.968600000	0.278400000	0.639200000
	0.964700000	0.286300000	0.639200000
	0.972500000	0.298000000	0.627500000
	0.976500000	0.309800000	0.615700000
	0.968600000	0.313700000	0.615700000
	0.972500000	0.329400000	0.615700000
	0.976500000	0.333300000	0.611800000
	0.988200000	0.345100000	0.607800000
	0.980400000	0.352900000	0.607800000
	0.984300000	0.360800000	0.588200000
	0.980400000	0.372500000	0.584300000
	0.980400000	0.384300000	0.584300000
	0.980400000	0.392200000	0.588200000
	0.984300000	0.400000000	0.580400000
	0.980400000	0.411800000	0.572500000
	0.972500000	0.423500000	0.560800000
	0.980400000	0.427500000	0.560800000
	0.988200000	0.435300000	0.552900000
	0.984300000	0.447100000	0.556900000
	0.976500000	0.454900000	0.545100000
	0.980400000	0.470600000	0.541200000
	0.980400000	0.478400000	0.529400000
	0.980400000	0.494100000	0.533300000
	0.984300000	0.498000000	0.525500000
	0.988200000	0.505900000	0.525500000
	0.988200000	0.509800000	0.521600000
	0.988200000	0.517600000	0.517600000
	0.992200000	0.529400000	0.521600000
	0.996100000	0.533300000	0.513700000
	0.992200000	0.549000000	0.513700000
	0.992200000	0.560800000	0.509800000
	0.992200000	0.568600000	0.509800000
	0.992200000	0.580400000	0.502000000
	0.988200000	0.592200000	0.494100000
	0.992200000	0.596100000	0.482400000
	0.996100000	0.611800000	0.486300000
	1.000000000	0.615700000	0.482400000
	0.992200000	0.623500000	0.474500000
	0.996100000	0.635300000	0.474500000
	1.000000000	0.643100000	0.466700000
	0.992200000	0.654900000	0.454900000
	0.992200000	0.666700000	0.454900000
	0.988200000	0.670600000	0.454900000
	0.996100000	0.690200000	0.447100000
	0.992200000	0.694100000	0.439200000
	0.996100000	0.702000000	0.443100000
	0.996100000	0.709800000	0.435300000
	0.992200000	0.725500000	0.427500000
	0.996100000	0.733300000	0.423500000
	1.000000000	0.745100000	0.423500000
	1.000000000	0.745100000	0.411800000
	0.988200000	0.764700000	0.411800000
	0.992200000	0.776500000	0.403900000
	0.996100000	0.784300000	0.396100000
	1.000000000	0.780400000	0.360800000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
