
function cm = imola(n, varargin)
% Colormap: imola

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.101440641	0.200110019	0.700193800
	0.103275325	0.203013884	0.698805700
	0.104955112	0.205895841	0.697423005
	0.106726550	0.208726138	0.696046370
	0.108298981	0.211566879	0.694658811
	0.109977458	0.214365510	0.693287156
	0.111521497	0.217161051	0.691912630
	0.113069881	0.219940286	0.690533238
	0.114496009	0.222699225	0.689171716
	0.116032120	0.225437855	0.687800035
	0.117442725	0.228185265	0.686434880
	0.118906261	0.230894008	0.685075221
	0.120279100	0.233585469	0.683714074
	0.121658091	0.236312145	0.682359033
	0.123038031	0.238984432	0.681005730
	0.124418603	0.241674808	0.679659291
	0.125812917	0.244322067	0.678319776
	0.127111342	0.246997460	0.676982763
	0.128473865	0.249641129	0.675640348
	0.129827292	0.252304379	0.674305613
	0.131137059	0.254954885	0.672978893
	0.132446084	0.257567970	0.671645386
	0.133757173	0.260200524	0.670327747
	0.135070133	0.262823226	0.669001586
	0.136327224	0.265434491	0.667684328
	0.137678997	0.268034880	0.666360093
	0.138935083	0.270667560	0.665046310
	0.140231086	0.273262867	0.663742165
	0.141542938	0.275871885	0.662432462
	0.142819910	0.278453909	0.661118677
	0.144107290	0.281027577	0.659815950
	0.145415158	0.283628209	0.658509523
	0.146647686	0.286201371	0.657213524
	0.147946614	0.288802113	0.655913186
	0.149228718	0.291388002	0.654606122
	0.150502503	0.293949086	0.653307971
	0.151764055	0.296538856	0.652018480
	0.153034954	0.299117309	0.650720899
	0.154317645	0.301672782	0.649429981
	0.155612510	0.304252105	0.648128097
	0.156880494	0.306831035	0.646840761
	0.158163933	0.309411862	0.645542201
	0.159415898	0.311952482	0.644249083
	0.160694690	0.314529314	0.642959584
	0.162001586	0.317105628	0.641664494
	0.163273777	0.319677705	0.640375910
	0.164543383	0.322244310	0.639079079
	0.165794035	0.324798665	0.637783762
	0.167114882	0.327367003	0.636491460
	0.168375342	0.329947170	0.635185958
	0.169688451	0.332516793	0.633890485
	0.170957419	0.335083382	0.632582724
	0.172247558	0.337632582	0.631276711
	0.173551284	0.340199099	0.629961816
	0.174877278	0.342764853	0.628648297
	0.176151042	0.345314288	0.627321571
	0.177520085	0.347876077	0.625991604
	0.178838343	0.350434768	0.624657004
	0.180160404	0.352981165	0.623314638
	0.181504088	0.355535962	0.621949363
	0.182871682	0.358073107	0.620594177
	0.184262881	0.360596067	0.619216419
	0.185685369	0.363136146	0.617815228
	0.187075888	0.365668008	0.616412792
	0.188513097	0.368188387	0.614982393
	0.189944003	0.370692419	0.613540175
	0.191408529	0.373199728	0.612082814
	0.192907457	0.375694552	0.610605821
	0.194447165	0.378180183	0.609107939
	0.195966911	0.380660816	0.607582099
	0.197527415	0.383122361	0.606021050
	0.199102139	0.385559543	0.604455676
	0.200716872	0.388001465	0.602849651
	0.202374398	0.390426155	0.601219347
	0.204080256	0.392837386	0.599568262
	0.205771979	0.395241038	0.597878398
	0.207500929	0.397623405	0.596167258
	0.209252918	0.399988415	0.594425408
	0.211047535	0.402340742	0.592662366
	0.212850704	0.404685015	0.590854971
	0.214696728	0.407020646	0.589024265
	0.216590081	0.409339358	0.587173095
	0.218472324	0.411640377	0.585301060
	0.220405071	0.413936388	0.583386002
	0.222326485	0.416218641	0.581454953
	0.224272901	0.418485068	0.579507479
	0.226292117	0.420749233	0.577520955
	0.228297827	0.423002684	0.575529429
	0.230291722	0.425262361	0.573508851
	0.232353523	0.427507204	0.571468365
	0.234418194	0.429737506	0.569412357
	0.236493960	0.431980961	0.567351352
	0.238559099	0.434194719	0.565258413
	0.240658729	0.436432834	0.563176112
	0.242781927	0.438654817	0.561063107
	0.244908477	0.440883450	0.558948214
	0.247068234	0.443125989	0.556835673
	0.249227583	0.445357088	0.554707077
	0.251413852	0.447594926	0.552578274
	0.253591284	0.449853594	0.550446900
	0.255782469	0.452118220	0.548321832
	0.257991853	0.454384722	0.546194320
	0.260237769	0.456657009	0.544064093
	0.262486865	0.458956373	0.541943516
	0.264746196	0.461264120	0.539834185
	0.267030957	0.463587577	0.537747137
	0.269364616	0.465931226	0.535652810
	0.271669914	0.468302429	0.533584136
	0.274044954	0.470701231	0.531541205
	0.276436829	0.473108604	0.529516980
	0.278846172	0.475568820	0.527507322
	0.281273001	0.478037337	0.525529081
	0.283754618	0.480544702	0.523580029
	0.286253579	0.483086880	0.521651676
	0.288817473	0.485665248	0.519766172
	0.291406272	0.488291677	0.517922847
	0.294011779	0.490954728	0.516096066
	0.296691175	0.493640507	0.514333633
	0.299398698	0.496375778	0.512590411
	0.302128861	0.499165462	0.510895301
	0.304936453	0.502000651	0.509249458
	0.307761747	0.504874496	0.507642919
	0.310668337	0.507797446	0.506068509
	0.313589614	0.510755439	0.504562474
	0.316562136	0.513774660	0.503070925
	0.319578616	0.516828329	0.501649032
	0.322646172	0.519921462	0.500247495
	0.325730637	0.523075288	0.498902339
	0.328896160	0.526263185	0.497596688
	0.332081290	0.529491005	0.496307261
	0.335315603	0.532757378	0.495079937
	0.338564732	0.536058010	0.493873093
	0.341871645	0.539397747	0.492693494
	0.345205901	0.542782568	0.491566764
	0.348575499	0.546194815	0.490446025
	0.351966057	0.549630387	0.489344718
	0.355415160	0.553094106	0.488287154
	0.358851896	0.556595692	0.487238750
	0.362345187	0.560122615	0.486201836
	0.365854121	0.563672509	0.485185345
	0.369381397	0.567239980	0.484185292
	0.372929348	0.570823108	0.483199118
	0.376515272	0.574431421	0.482228830
	0.380098107	0.578060619	0.481252690
	0.383710399	0.581709306	0.480296042
	0.387326130	0.585380348	0.479342373
	0.390980160	0.589046052	0.478386649
	0.394629081	0.592750554	0.477439329
	0.398305878	0.596451312	0.476495688
	0.401978122	0.600169136	0.475558441
	0.405692358	0.603906390	0.474615175
	0.409397761	0.607650577	0.473661501
	0.413125975	0.611402835	0.472722848
	0.416859835	0.615163464	0.471789806
	0.420597223	0.618952924	0.470842629
	0.424359334	0.622734769	0.469901541
	0.428132673	0.626533625	0.468953532
	0.431922116	0.630349348	0.467997199
	0.435709243	0.634172210	0.467055287
	0.439505462	0.637998696	0.466093814
	0.443323427	0.641839764	0.465140122
	0.447142612	0.645690084	0.464196704
	0.450983114	0.649560121	0.463220036
	0.454835266	0.653426329	0.462264805
	0.458686507	0.657318203	0.461305346
	0.462547964	0.661207002	0.460330503
	0.466433472	0.665109764	0.459373261
	0.470327912	0.669029209	0.458397028
	0.474225918	0.672956857	0.457421906
	0.478135834	0.676893243	0.456446458
	0.482064186	0.680830558	0.455471437
	0.485991400	0.684791699	0.454495300
	0.489936629	0.688765736	0.453501833
	0.493897454	0.692746025	0.452526716
	0.497874270	0.696730102	0.451531964
	0.501847460	0.700731468	0.450538384
	0.505825217	0.704740679	0.449545198
	0.509834478	0.708768212	0.448549073
	0.513853969	0.712792418	0.447538096
	0.517878078	0.716845310	0.446542933
	0.521902709	0.720892844	0.445532334
	0.525961281	0.724965921	0.444537959
	0.530020827	0.729038714	0.443522745
	0.534087847	0.733130007	0.442513074
	0.538185343	0.737228527	0.441492871
	0.542278516	0.741335850	0.440468543
	0.546397070	0.745461429	0.439449516
	0.550518652	0.749592151	0.438427038
	0.554661795	0.753742614	0.437409295
	0.558814015	0.757901610	0.436376245
	0.563001162	0.762066686	0.435350412
	0.567195590	0.766250332	0.434305664
	0.571405546	0.770442726	0.433271874
	0.575652460	0.774643794	0.432249067
	0.579917218	0.778862050	0.431206600
	0.584204731	0.783088824	0.430163135
	0.588525105	0.787331063	0.429122506
	0.592897735	0.791579686	0.428084990
	0.597297344	0.795840614	0.427048196
	0.601739284	0.800118382	0.425998898
	0.606235252	0.804401045	0.424971349
	0.610796858	0.808694645	0.423927487
	0.615409501	0.812992812	0.422893655
	0.620108417	0.817305403	0.421866848
	0.624872072	0.821626825	0.420848362
	0.629725364	0.825948034	0.419843617
	0.634681303	0.830278920	0.418834181
	0.639735190	0.834609700	0.417842470
	0.644895271	0.838937323	0.416866026
	0.650187000	0.843264238	0.415892409
	0.655602656	0.847585127	0.414941328
	0.661150837	0.851901085	0.414009395
	0.666841707	0.856199611	0.413103983
	0.672691564	0.860483104	0.412213097
	0.678680209	0.864742087	0.411341388
	0.684831183	0.868981733	0.410515420
	0.691137410	0.873182431	0.409702301
	0.697607426	0.877350308	0.408921595
	0.704235792	0.881482760	0.408177728
	0.711021993	0.885566891	0.407469013
	0.717954752	0.889601431	0.406798276
	0.725038472	0.893582528	0.406169124
	0.732259688	0.897512688	0.405572464
	0.739616309	0.901376175	0.405005487
	0.747089784	0.905183754	0.404484727
	0.754685914	0.908919204	0.404011672
	0.762377684	0.912595045	0.403574260
	0.770173380	0.916200907	0.403168102
	0.778055189	0.919745644	0.402795781
	0.786011899	0.923226207	0.402458725
	0.794033903	0.926636846	0.402157227
	0.802105526	0.929991884	0.401890408
	0.810229911	0.933282310	0.401656397
	0.818395288	0.936527394	0.401451748
	0.826598639	0.939710661	0.401272461
	0.834822863	0.942847314	0.401115425
	0.843067115	0.945933187	0.400978154
	0.851324534	0.948981204	0.400858548
	0.859601450	0.951989376	0.400754745
	0.867882734	0.954967120	0.400665109
	0.876163305	0.957911314	0.400588154
	0.884451055	0.960825455	0.400522359
	0.892735918	0.963712120	0.400466220
	0.901017680	0.966580306	0.400418293
	0.909296864	0.969428364	0.400377223
	0.917577386	0.972262678	0.400341763
	0.925844716	0.975074199	0.400310771
	0.934106178	0.977878610	0.400283217
	0.942371351	0.980671585	0.400258175
	0.950622715	0.983451657	0.400234819
	0.958869726	0.986227069	0.400212413
	0.967110397	0.988992067	0.400190302
	0.975341664	0.991749250	0.400167910
	0.983572285	0.994499564	0.400144725
	0.991796675	0.997244891	0.400120297
	1.000000000	0.999988516	0.400094234
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
