
function cm = ice(n, varargin)
% Colormap: ice

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.015312000	0.022521000	0.072729000
	0.018005000	0.025446000	0.078419000
	0.020901000	0.028527000	0.084078000
	0.023998000	0.031763000	0.089708000
	0.027298000	0.035149000	0.095326000
	0.030804000	0.038677000	0.100966000
	0.034510000	0.042300000	0.106583000
	0.038414000	0.045874000	0.112178000
	0.042458000	0.049400000	0.117796000
	0.046458000	0.052885000	0.123418000
	0.050416000	0.056338000	0.129022000
	0.054338000	0.059757000	0.134624000
	0.058230000	0.063136000	0.140265000
	0.062086000	0.066489000	0.145892000
	0.065909000	0.069818000	0.151506000
	0.069707000	0.073109000	0.157170000
	0.073474000	0.076378000	0.162831000
	0.077210000	0.079628000	0.168480000
	0.080922000	0.082849000	0.174170000
	0.084607000	0.086047000	0.179873000
	0.088264000	0.089231000	0.185565000
	0.091897000	0.092390000	0.191295000
	0.095506000	0.095529000	0.197047000
	0.099088000	0.098657000	0.202789000
	0.102646000	0.101763000	0.208573000
	0.106181000	0.104853000	0.214377000
	0.109689000	0.107935000	0.220172000
	0.113175000	0.110995000	0.226024000
	0.116636000	0.114045000	0.231884000
	0.120071000	0.117088000	0.237737000
	0.123483000	0.120110000	0.243664000
	0.126869000	0.123127000	0.249581000
	0.130231000	0.126135000	0.255522000
	0.133567000	0.129129000	0.261506000
	0.136877000	0.132123000	0.267479000
	0.140161000	0.135101000	0.273516000
	0.143418000	0.138076000	0.279556000
	0.146647000	0.141047000	0.285618000
	0.149849000	0.144008000	0.291725000
	0.153023000	0.146973000	0.297817000
	0.156166000	0.149924000	0.303988000
	0.159280000	0.152880000	0.310144000
	0.162363000	0.155829000	0.316351000
	0.165414000	0.158780000	0.322568000
	0.168433000	0.161729000	0.328815000
	0.171417000	0.164679000	0.335090000
	0.174368000	0.167632000	0.341380000
	0.177282000	0.170585000	0.347709000
	0.180160000	0.173544000	0.354045000
	0.182998000	0.176503000	0.360423000
	0.185799000	0.179472000	0.366806000
	0.188557000	0.182443000	0.373228000
	0.191275000	0.185424000	0.379658000
	0.193947000	0.188412000	0.386116000
	0.196575000	0.191409000	0.392592000
	0.199157000	0.194419000	0.399079000
	0.201687000	0.197437000	0.405598000
	0.204173000	0.200472000	0.412103000
	0.206599000	0.203516000	0.418661000
	0.208977000	0.206579000	0.425203000
	0.211297000	0.209658000	0.431765000
	0.213558000	0.212753000	0.438337000
	0.215765000	0.215871000	0.444895000
	0.217903000	0.219006000	0.451482000
	0.219980000	0.222164000	0.458057000
	0.221997000	0.225347000	0.464613000
	0.223936000	0.228553000	0.471190000
	0.225809000	0.231786000	0.477745000
	0.227615000	0.235047000	0.484275000
	0.229341000	0.238338000	0.490800000
	0.230991000	0.241658000	0.497304000
	0.232565000	0.245012000	0.503773000
	0.234063000	0.248399000	0.510206000
	0.235474000	0.251821000	0.516613000
	0.236801000	0.255279000	0.522979000
	0.238046000	0.258774000	0.529293000
	0.239207000	0.262309000	0.535552000
	0.240283000	0.265882000	0.541750000
	0.241269000	0.269497000	0.547887000
	0.242165000	0.273154000	0.553957000
	0.242974000	0.276852000	0.559948000
	0.243696000	0.280593000	0.565855000
	0.244333000	0.284378000	0.571672000
	0.244885000	0.288205000	0.577394000
	0.245353000	0.292075000	0.583015000
	0.245740000	0.295988000	0.588530000
	0.246048000	0.299943000	0.593933000
	0.246281000	0.303940000	0.599218000
	0.246442000	0.307977000	0.604383000
	0.246535000	0.312054000	0.609422000
	0.246565000	0.316169000	0.614332000
	0.246538000	0.320320000	0.619109000
	0.246460000	0.324505000	0.623752000
	0.246336000	0.328723000	0.628259000
	0.246173000	0.332971000	0.632628000
	0.245977000	0.337248000	0.636860000
	0.245757000	0.341550000	0.640953000
	0.245519000	0.345876000	0.644910000
	0.245270000	0.350222000	0.648731000
	0.245018000	0.354588000	0.652419000
	0.244770000	0.358969000	0.655976000
	0.244533000	0.363365000	0.659406000
	0.244314000	0.367772000	0.662711000
	0.244120000	0.372189000	0.665896000
	0.243958000	0.376613000	0.668965000
	0.243833000	0.381042000	0.671922000
	0.243753000	0.385475000	0.674771000
	0.243722000	0.389910000	0.677518000
	0.243745000	0.394345000	0.680167000
	0.243828000	0.398779000	0.682723000
	0.243974000	0.403210000	0.685191000
	0.244187000	0.407637000	0.687575000
	0.244472000	0.412060000	0.689881000
	0.244831000	0.416478000	0.692113000
	0.245266000	0.420889000	0.694276000
	0.245781000	0.425293000	0.696373000
	0.246376000	0.429689000	0.698409000
	0.247054000	0.434078000	0.700389000
	0.247815000	0.438458000	0.702316000
	0.248661000	0.442829000	0.704194000
	0.249593000	0.447191000	0.706027000
	0.250609000	0.451544000	0.707817000
	0.251711000	0.455888000	0.709569000
	0.252899000	0.460223000	0.711285000
	0.254171000	0.464548000	0.712969000
	0.255527000	0.468865000	0.714622000
	0.256967000	0.473172000	0.716249000
	0.258489000	0.477471000	0.717850000
	0.260092000	0.481760000	0.719429000
	0.261776000	0.486042000	0.720987000
	0.263538000	0.490315000	0.722528000
	0.265377000	0.494579000	0.724052000
	0.267292000	0.498837000	0.725561000
	0.269281000	0.503086000	0.727058000
	0.271343000	0.507328000	0.728544000
	0.273476000	0.511564000	0.730020000
	0.275678000	0.515792000	0.731487000
	0.277948000	0.520014000	0.732948000
	0.280284000	0.524231000	0.734403000
	0.282684000	0.528441000	0.735853000
	0.285146000	0.532646000	0.737300000
	0.287670000	0.536846000	0.738744000
	0.290253000	0.541040000	0.740187000
	0.292894000	0.545231000	0.741629000
	0.295592000	0.549417000	0.743070000
	0.298344000	0.553599000	0.744513000
	0.301150000	0.557777000	0.745957000
	0.304009000	0.561952000	0.747402000
	0.306918000	0.566124000	0.748851000
	0.309877000	0.570293000	0.750302000
	0.312885000	0.574460000	0.751757000
	0.315940000	0.578624000	0.753216000
	0.319042000	0.582785000	0.754680000
	0.322190000	0.586945000	0.756148000
	0.325382000	0.591104000	0.757621000
	0.328618000	0.595261000	0.759099000
	0.331898000	0.599416000	0.760583000
	0.335220000	0.603571000	0.762072000
	0.338584000	0.607724000	0.763567000
	0.341990000	0.611877000	0.765068000
	0.345437000	0.616029000	0.766575000
	0.348925000	0.620181000	0.768089000
	0.352454000	0.624332000	0.769608000
	0.356023000	0.628483000	0.771134000
	0.359633000	0.632634000	0.772666000
	0.363284000	0.636785000	0.774203000
	0.366976000	0.640936000	0.775747000
	0.370709000	0.645086000	0.777298000
	0.374483000	0.649237000	0.778854000
	0.378300000	0.653387000	0.780415000
	0.382159000	0.657538000	0.781983000
	0.386061000	0.661688000	0.783556000
	0.390007000	0.665838000	0.785134000
	0.393999000	0.669988000	0.786717000
	0.398036000	0.674138000	0.788304000
	0.402121000	0.678286000	0.789896000
	0.406254000	0.682434000	0.791493000
	0.410437000	0.686581000	0.793094000
	0.414671000	0.690726000	0.794700000
	0.418958000	0.694870000	0.796310000
	0.423301000	0.699012000	0.797922000
	0.427700000	0.703151000	0.799537000
	0.432159000	0.707288000	0.801155000
	0.436679000	0.711421000	0.802777000
	0.441262000	0.715551000	0.804403000
	0.445912000	0.719676000	0.806030000
	0.450631000	0.723796000	0.807659000
	0.455422000	0.727910000	0.809291000
	0.460287000	0.732017000	0.810927000
	0.465231000	0.736118000	0.812565000
	0.470257000	0.740210000	0.814206000
	0.475366000	0.744293000	0.815852000
	0.480563000	0.748366000	0.817501000
	0.485852000	0.752428000	0.819155000
	0.491234000	0.756478000	0.820816000
	0.496715000	0.760515000	0.822483000
	0.502296000	0.764538000	0.824159000
	0.507980000	0.768545000	0.825846000
	0.513770000	0.772535000	0.827544000
	0.519667000	0.776509000	0.829258000
	0.525675000	0.780464000	0.830987000
	0.531791000	0.784399000	0.832739000
	0.538018000	0.788315000	0.834512000
	0.544354000	0.792210000	0.836313000
	0.550798000	0.796084000	0.838144000
	0.557346000	0.799937000	0.840010000
	0.563996000	0.803769000	0.841914000
	0.570744000	0.807580000	0.843860000
	0.577583000	0.811372000	0.845852000
	0.584508000	0.815144000	0.847893000
	0.591512000	0.818898000	0.849987000
	0.598589000	0.822635000	0.852137000
	0.605731000	0.826357000	0.854345000
	0.612931000	0.830065000	0.856614000
	0.620181000	0.833761000	0.858944000
	0.627475000	0.837446000	0.861337000
	0.634805000	0.841124000	0.863794000
	0.642166000	0.844794000	0.866315000
	0.649551000	0.848460000	0.868899000
	0.656956000	0.852122000	0.871546000
	0.664375000	0.855783000	0.874255000
	0.671803000	0.859444000	0.877026000
	0.679238000	0.863107000	0.879856000
	0.686674000	0.866773000	0.882745000
	0.694112000	0.870443000	0.885690000
	0.701546000	0.874119000	0.888691000
	0.708975000	0.877802000	0.891744000
	0.716398000	0.881492000	0.894849000
	0.723813000	0.885192000	0.898003000
	0.731218000	0.888901000	0.901205000
	0.738613000	0.892621000	0.904453000
	0.745997000	0.896353000	0.907744000
	0.753369000	0.900097000	0.911077000
	0.760728000	0.903855000	0.914449000
	0.768075000	0.907626000	0.917859000
	0.775409000	0.911413000	0.921305000
	0.782730000	0.915214000	0.924784000
	0.790036000	0.919033000	0.928294000
	0.797331000	0.922867000	0.931832000
	0.804609000	0.926720000	0.935397000
	0.811876000	0.930590000	0.938985000
	0.819126000	0.934480000	0.942595000
	0.826365000	0.938389000	0.946222000
	0.833586000	0.942320000	0.949863000
	0.840793000	0.946272000	0.953515000
	0.847982000	0.950247000	0.957174000
	0.855151000	0.954248000	0.960835000
	0.862303000	0.958274000	0.964492000
	0.869430000	0.962328000	0.968140000
	0.876528000	0.966413000	0.971773000
	0.883593000	0.970533000	0.975384000
	0.890617000	0.974691000	0.978964000
	0.897592000	0.978891000	0.982505000
	0.904501000	0.983140000	0.986001000
	0.911330000	0.987445000	0.989444000
	0.918059000	0.991814000	0.992833000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
