
function cm = fpurple(n, varargin)
% Colormap: fpurple

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.0813054	0.0000000	0.0744262
    0.1208725	0.0000000	0.1123961
    0.1532457	0.0088460	0.1494909
    0.1912873	0.0035483	0.1886776
    0.2320745	0.0000000	0.2293698
    0.2631349	0.0000000	0.2599051
    0.2948125	0.0000000	0.2910446
    0.3270731	0.0000000	0.3227550
    0.3598868	0.0000000	0.3550070
    0.3932271	0.0000000	0.3877747
    0.4270701	0.0000000	0.4210348
    0.4613945	0.0000000	0.4547663
    0.4961808	0.0000000	0.4889504
    0.5152368	0.0603809	0.5070674
    0.5341647	0.1145657	0.5252567
    0.5529697	0.1563280	0.5435175
    0.5716568	0.1930251	0.5618492
    0.5902304	0.2269956	0.5802510
    0.6086950	0.2593081	0.5987222
    0.6270544	0.2905434	0.6172623
    0.6453123	0.3210523	0.6358706
    0.6634721	0.3510618	0.6545466
    0.6815372	0.3807269	0.6732897
    0.6995106	0.4101572	0.6920993
    0.7173950	0.4394326	0.7109749
    0.7351933	0.4686130	0.7299160
    0.7529080	0.4977437	0.7489220
    0.7686167	0.5284497	0.7639516
    0.7841635	0.5590855	0.7789908
    0.7995511	0.5896870	0.7940397
    0.8147815	0.6202825	0.8090985
    0.8298570	0.6508949	0.8241673
    0.8447796	0.6815426	0.8392463
    0.8595510	0.7122406	0.8543357
    0.8741731	0.7430012	0.8694356
    0.8886475	0.7738344	0.8845461
    0.9029758	0.8047486	0.8996675
    0.9171594	0.8357505	0.9147999
    0.9311997	0.8668458	0.9299433
    0.9450980	0.8980392	0.9450980
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
