
function cm = fmviz(n, varargin)
% Colormap: fmviz

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.3988359	0.0965844	0.2991087
    0.4156836	0.1022756	0.2977053
    0.4324363	0.1080722	0.2962570
    0.4491114	0.1139668	0.2947619
    0.4657237	0.1199527	0.2932183
    0.4822860	0.1260238	0.2916241
    0.4988092	0.1321748	0.2899774
    0.5153027	0.1384011	0.2882760
    0.5317748	0.1446983	0.2865179
    0.5482326	0.1510627	0.2847006
    0.5646823	0.1574909	0.2828218
    0.5811295	0.1639797	0.2808791
    0.5975789	0.1705265	0.2788697
    0.6140350	0.1771286	0.2767909
    0.6305013	0.1837838	0.2746399
    0.6469814	0.1904900	0.2724134
    0.6634781	0.1972453	0.2701083
    0.6799941	0.2040480	0.2677211
    0.6965317	0.2108965	0.2652482
    0.7130930	0.2177893	0.2626855
    0.7296800	0.2247251	0.2600291
    0.7462942	0.2317025	0.2572743
    0.7629372	0.2387205	0.2544164
    0.7796103	0.2457779	0.2514502
    0.7963147	0.2528738	0.2483703
    0.8130514	0.2600072	0.2451704
    0.8298214	0.2671772	0.2418441
    0.8466254	0.2743830	0.2383843
    0.8634644	0.2816239	0.2347832
    0.8803389	0.2888990	0.2310321
    0.8972495	0.2962078	0.2271216
    0.9141967	0.3035495	0.2230412
    0.9311810	0.3109236	0.2187793
    0.9482029	0.3183295	0.2143227
    0.9652626	0.3257666	0.2096568
    0.9823604	0.3332344	0.2047648
    0.9994967	0.3407323	0.1996278
    1.0000000	0.3662378	0.1960826
    1.0000000	0.3905016	0.1922961
    1.0000000	0.4137569	0.1882502
    1.0000000	0.4361772	0.1839244
    1.0000000	0.4578955	0.1792947
    1.0000000	0.4790160	0.1743332
    1.0000000	0.4996223	0.1690070
    1.0000000	0.5197821	0.1632770
    1.0000000	0.5395514	0.1570957
    1.0000000	0.5589769	0.1504048
    1.0000000	0.5780981	0.1431311
    1.0000000	0.5969485	0.1351811
    1.0000000	0.6155570	0.1264311
    1.0000000	0.6339485	0.1167128
    1.0000000	0.6521447	0.1057857
    1.0000000	0.6701648	0.0932852
    0.9989465	0.6880255	0.0786100
    0.9975716	0.7057418	0.0606283
    0.9960298	0.7233267	0.0366923
    0.9943177	0.7407921	0.0084595
    0.9924319	0.7581487	0.0000000
    0.9865394	0.7758770	0.1219271
    0.9798806	0.7935477	0.1951184
    0.9723974	0.8111695	0.2529651
    0.9640267	0.8287502	0.3041915
    0.9546998	0.8462966	0.3517827
    0.9443404	0.8638151	0.3971461
    0.9328643	0.8813114	0.4410604
    0.9201764	0.8987907	0.4840016
    0.9061694	0.9162578	0.5262800
    0.8907203	0.9337171	0.5681087
    0.8736868	0.9511724	0.6096387
    0.8549020	0.9686275	0.6509804
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
