
function cm = flare(n, varargin)
% Colormap: flare

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.278431000	0.121569000	0.372549000
	0.309804000	0.141176000	0.388235000
	0.325490000	0.145098000	0.392157000
	0.341176000	0.149020000	0.400000000
	0.356863000	0.152941000	0.403922000
	0.372549000	0.156863000	0.407843000
	0.388235000	0.160784000	0.415686000
	0.403922000	0.164706000	0.419608000
	0.423529000	0.168627000	0.423529000
	0.435294000	0.168627000	0.427451000
	0.450980000	0.172549000	0.431373000
	0.466667000	0.176471000	0.435294000
	0.482353000	0.180392000	0.435294000
	0.498039000	0.184314000	0.439216000
	0.513725000	0.188235000	0.439216000
	0.533333000	0.188235000	0.439216000
	0.549020000	0.192157000	0.439216000
	0.560784000	0.196078000	0.439216000
	0.576471000	0.200000000	0.439216000
	0.592157000	0.203922000	0.439216000
	0.607843000	0.211765000	0.435294000
	0.623529000	0.215686000	0.435294000
	0.639216000	0.219608000	0.431373000
	0.658824000	0.223529000	0.431373000
	0.670588000	0.227451000	0.427451000
	0.686275000	0.231373000	0.423529000
	0.705882000	0.235294000	0.419608000
	0.721569000	0.239216000	0.415686000
	0.733333000	0.243137000	0.411765000
	0.749020000	0.247059000	0.407843000
	0.764706000	0.254902000	0.400000000
	0.780392000	0.262745000	0.396078000
	0.796078000	0.270588000	0.388235000
	0.807843000	0.278431000	0.384314000
	0.815686000	0.286275000	0.376471000
	0.831373000	0.301961000	0.372549000
	0.839216000	0.309804000	0.368627000
	0.850980000	0.325490000	0.364706000
	0.858824000	0.341176000	0.360784000
	0.866667000	0.349020000	0.356863000
	0.874510000	0.368627000	0.356863000
	0.878431000	0.384314000	0.356863000
	0.882353000	0.400000000	0.360784000
	0.890196000	0.419608000	0.360784000
	0.894118000	0.435294000	0.364706000
	0.898039000	0.454902000	0.372549000
	0.901961000	0.466667000	0.376471000
	0.905882000	0.482353000	0.384314000
	0.905882000	0.498039000	0.392157000
	0.909804000	0.517647000	0.400000000
	0.909804000	0.533333000	0.411765000
	0.913725000	0.549020000	0.419608000
	0.913725000	0.564706000	0.427451000
	0.917647000	0.584314000	0.439216000
	0.917647000	0.600000000	0.447059000
	0.921569000	0.615686000	0.458824000
	0.921569000	0.635294000	0.470588000
	0.925490000	0.650980000	0.478431000
	0.925490000	0.662745000	0.486275000
	0.925490000	0.678431000	0.498039000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
