
function cm = fblue(n, varargin)
% Colormap: fblue

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.000000000	0.063884000	0.331000000
	0.056699000	0.175945000	0.404130000
	0.000000000	0.202036000	0.478380000
	0.053521000	0.293868000	0.551760000
	0.052861000	0.351405000	0.625444000
	0.053808000	0.408988000	0.697508000
	0.000000000	0.443984000	0.768384000
	0.000000000	0.495669000	0.827150000
	0.128140000	0.586878000	0.872936000
	0.200116000	0.645932000	0.905294000
	0.291909000	0.700976000	0.925776000
	0.399050000	0.750753000	0.933726000
	0.505102000	0.795950000	0.940622000
	0.607839000	0.838115000	0.947526000
	0.708924000	0.877595000	0.954436000
	0.808261000	0.915060000	0.961350000
	0.907231000	0.950356000	0.968270000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
