
function cm = dusk(n, varargin)
% Colormap: dusk

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.023792970	0.011318790	0.020011350
	0.026115700	0.013917830	0.024100490
	0.028504550	0.016747890	0.028512700
	0.030951370	0.019807610	0.033271990
	0.033447600	0.023095570	0.038408920
	0.036030400	0.026597030	0.043772780
	0.038638240	0.030326970	0.049143020
	0.041285290	0.034273320	0.054498720
	0.043846890	0.038445740	0.059873220
	0.046316240	0.042769880	0.065278530
	0.048709070	0.047043410	0.070695040
	0.050971810	0.051290540	0.076169980
	0.053160590	0.055500780	0.081642320
	0.055190770	0.059699330	0.087189110
	0.057142770	0.063869210	0.092726900
	0.058927870	0.068034230	0.098334990
	0.060627710	0.072177370	0.103932040
	0.062145950	0.076322170	0.109600720
	0.063570230	0.080450530	0.115257720
	0.064809330	0.084583260	0.120976410
	0.065928270	0.088707400	0.126695920
	0.066879930	0.092833390	0.132448730
	0.067662240	0.096961900	0.138228620
	0.068309460	0.101086670	0.144003330
	0.068724150	0.105226180	0.149833920
	0.068971800	0.109367880	0.155664040
	0.069043340	0.113513400	0.161491210
	0.068860450	0.117675900	0.167352180
	0.068447990	0.121850040	0.173216590
	0.067800270	0.126035860	0.179072960
	0.066890540	0.130236510	0.184919080
	0.065687770	0.134455300	0.190750780
	0.064156290	0.138695630	0.196561260
	0.062255670	0.142960850	0.202339910
	0.059941020	0.147254130	0.208071040
	0.057164330	0.151578140	0.213732030
	0.053877500	0.155934650	0.219291020
	0.050038970	0.160323840	0.224704030
	0.045517280	0.164755440	0.229930480
	0.040292950	0.169225280	0.234881100
	0.034462290	0.173738630	0.239444530
	0.028743660	0.178271840	0.243423730
	0.023854470	0.182784400	0.246547910
	0.021275020	0.187159370	0.248546990
	0.022425080	0.191260040	0.249440690
	0.027530100	0.195032460	0.249641070
	0.035787770	0.198529560	0.249543940
	0.046010800	0.201823110	0.249388970
	0.056409180	0.204968480	0.249259260
	0.066560430	0.208003450	0.249200290
	0.076342170	0.210954940	0.249236310
	0.085777690	0.213837780	0.249347120
	0.094833200	0.216669230	0.249561870
	0.103583940	0.219454450	0.249849240
	0.112021070	0.222205070	0.250229170
	0.120188700	0.224925450	0.250688540
	0.128119620	0.227619430	0.251219280
	0.135833010	0.230291390	0.251820180
	0.143346810	0.232945000	0.252489390
	0.150674050	0.235583910	0.253226920
	0.157831210	0.238210510	0.254029390
	0.164836450	0.240826170	0.254891220
	0.171701120	0.243432880	0.255810390
	0.178435380	0.246032390	0.256784910
	0.185048220	0.248626270	0.257812930
	0.191547620	0.251215990	0.258892670
	0.197935980	0.253803930	0.260025670
	0.204222960	0.256390650	0.261208030
	0.210414720	0.258977210	0.262437720
	0.216515990	0.261564820	0.263713260
	0.222530730	0.264154700	0.265033180
	0.228462160	0.266748150	0.266395970
	0.234312750	0.269346570	0.267799930
	0.240083530	0.271951710	0.269243550
	0.245769420	0.274567000	0.270728540
	0.251378380	0.277192430	0.272245530
	0.256910240	0.279830330	0.273788570
	0.262364670	0.282483330	0.275348390
	0.267741600	0.285154400	0.276910730
	0.273038840	0.287847640	0.278457140
	0.278273460	0.290562130	0.279946880
	0.283469580	0.293294900	0.281329340
	0.288674390	0.296034930	0.282541390
	0.293956950	0.298760970	0.283529390
	0.299407060	0.301440130	0.284263430
	0.305089660	0.304042080	0.284770160
	0.311018110	0.306551580	0.285118880
	0.317153380	0.308973100	0.285389700
	0.323451960	0.311317380	0.285625230
	0.329869050	0.313598480	0.285848460
	0.336369630	0.315828750	0.286067650
	0.342929130	0.318017580	0.286283690
	0.349539920	0.320168610	0.286486590
	0.356193610	0.322285460	0.286671700
	0.362881080	0.324371900	0.286838460
	0.369602420	0.326428290	0.286980410
	0.376356710	0.328455170	0.287093780
	0.383140970	0.330453780	0.287177940
	0.389953280	0.332424930	0.287232100
	0.396795420	0.334367950	0.287252710
	0.403666190	0.336283280	0.287239350
	0.410563740	0.338171630	0.287192530
	0.417489520	0.340032340	0.287109920
	0.424442700	0.341865680	0.286991450
	0.431422990	0.343671660	0.286836700
	0.438430860	0.345449990	0.286644590
	0.445465410	0.347200920	0.286415440
	0.452526420	0.348924440	0.286148940
	0.459616090	0.350619430	0.285842490
	0.466732010	0.352286810	0.285497990
	0.473873460	0.353926790	0.285115760
	0.481044410	0.355537350	0.284691410
	0.488242400	0.357119460	0.284226990
	0.495465800	0.358673740	0.283723760
	0.502716500	0.360199090	0.283179390
	0.509997740	0.361693710	0.282590160
	0.517304480	0.363159880	0.281960820
	0.524636210	0.364597710	0.281291510
	0.531999870	0.366003390	0.280574530
	0.539391660	0.367378620	0.279813380
	0.546808810	0.368724650	0.279010540
	0.554250970	0.370041480	0.278165950
	0.561729380	0.371322680	0.277266950
	0.569234010	0.372573450	0.276323800
	0.576764320	0.373793870	0.275336590
	0.584320140	0.374983820	0.274304980
	0.591913140	0.376136230	0.273215290
	0.599533750	0.377256280	0.272077470
	0.607180790	0.378344380	0.270892210
	0.614854300	0.379400270	0.269658770
	0.622558420	0.380421090	0.268371610
	0.630298490	0.381403110	0.267023550
	0.638066080	0.382351180	0.265623460
	0.645861380	0.383264840	0.264170190
	0.653684670	0.384143580	0.262662400
	0.661536290	0.384986820	0.261098610
	0.669421250	0.385790850	0.259471440
	0.677341010	0.386554160	0.257777620
	0.685289960	0.387280070	0.256022580
	0.693268420	0.387967940	0.254204360
	0.701276740	0.388617100	0.252320780
	0.709315270	0.389226860	0.250369530
	0.717384310	0.389796530	0.248348100
	0.725484090	0.390325490	0.246253860
	0.733614730	0.390813150	0.244084030
	0.741776180	0.391259060	0.241835780
	0.749968160	0.391662970	0.239506210
	0.758190040	0.392024870	0.237092480
	0.766440770	0.392345130	0.234591880
	0.774718750	0.392624650	0.232001960
	0.783029330	0.392858750	0.229309410
	0.791378390	0.393042140	0.226498610
	0.799749260	0.393188040	0.223586180
	0.808136110	0.393301340	0.220572150
	0.816572050	0.393354100	0.217393590
	0.825012750	0.393383910	0.214105100
	0.833493860	0.393360590	0.210630960
	0.841982580	0.393313300	0.206999780
	0.850484920	0.393238390	0.203168550
	0.859000300	0.393138690	0.199089440
	0.867513920	0.393031560	0.194714960
	0.875987090	0.392959650	0.190001330
	0.884399370	0.392955570	0.184776800
	0.892631610	0.393157990	0.178864610
	0.900383040	0.393911190	0.171993350
	0.906871680	0.396054970	0.164499890
	0.911663750	0.399983370	0.157976580
	0.915618950	0.404757710	0.152432650
	0.919388260	0.409713770	0.146997600
	0.923180520	0.414646510	0.141265710
	0.926994600	0.419557760	0.135214280
	0.930701730	0.424570340	0.129079370
	0.934051550	0.429913320	0.123495010
	0.936654970	0.435920860	0.119875080
	0.938185720	0.442817310	0.120479850
	0.938865160	0.450312710	0.126175870
	0.939236410	0.457902110	0.135247600
	0.939516390	0.465423980	0.145995450
	0.939795280	0.472826330	0.157475490
	0.940085540	0.480117520	0.169258140
	0.940369200	0.487324830	0.181172030
	0.940712140	0.494405410	0.192982220
	0.941047790	0.501419980	0.204761930
	0.941373540	0.508375580	0.216487370
	0.941720770	0.515253480	0.228084220
	0.942095800	0.522054150	0.239536070
	0.942445630	0.528819490	0.250942860
	0.942744870	0.535569090	0.262352080
	0.943097030	0.542233960	0.273574660
	0.943441510	0.548858960	0.284727650
	0.943695140	0.555500430	0.295964370
	0.944079780	0.562015560	0.306890520
	0.944324870	0.568581010	0.317993370
	0.944683760	0.575037690	0.328828960
	0.944913500	0.581538660	0.339826190
	0.945261270	0.587934140	0.350560470
	0.945448040	0.594393230	0.361513490
	0.945808000	0.600719830	0.372120650
	0.946017760	0.607104170	0.382930880
	0.946310820	0.613412990	0.393555610
	0.946566320	0.619716460	0.404198930
	0.946750500	0.626033200	0.414916710
	0.947065110	0.632255110	0.425383980
	0.947256250	0.638520010	0.436013570
	0.947487700	0.644741370	0.446543490
	0.947761290	0.650920340	0.456974400
	0.947923100	0.657136260	0.467550030
	0.948168340	0.663291120	0.477965790
	0.948431420	0.669419730	0.488327140
	0.948594140	0.675580210	0.498816860
	0.948814400	0.681696670	0.509193690
	0.949093310	0.687770660	0.519459180
	0.949282900	0.693872330	0.529837990
	0.949436820	0.699976430	0.540248880
	0.949754230	0.705993970	0.550397960
	0.949992850	0.712035730	0.560646570
	0.950152530	0.718101110	0.570993760
	0.950414100	0.724111750	0.581176470
	0.950720750	0.730094220	0.591280270
	0.950958770	0.736097550	0.601469910
	0.951128390	0.742121170	0.611744100
	0.951459430	0.748070950	0.621777340
	0.951791580	0.754014580	0.631799640
	0.952065340	0.759976340	0.641894830
	0.952281280	0.765955700	0.652061330
	0.952640390	0.771874490	0.662021350
	0.953031470	0.777777910	0.671931440
	0.953374390	0.783697260	0.681902190
	0.953670050	0.789632050	0.691931760
	0.954016220	0.795546050	0.701887960
	0.954497390	0.801409620	0.711659380
	0.954940630	0.807287340	0.721479810
	0.955347170	0.813178760	0.731347170
	0.955718390	0.819083400	0.741259210
	0.956244120	0.824935140	0.750967140
	0.956817490	0.830773070	0.760613780
	0.957364830	0.836623270	0.770295690
	0.957887900	0.842485280	0.780010260
	0.958388620	0.848358610	0.789754610
	0.959064070	0.854178380	0.799277760
	0.959782330	0.859989920	0.808750270
	0.960487840	0.865812040	0.818242760
	0.961183010	0.871644240	0.827751660
	0.961870540	0.877486000	0.837272910
	0.962676280	0.883298140	0.846650360
	0.963597860	0.889082910	0.855888680
	0.964522420	0.894876600	0.865126740
	0.965453460	0.900678700	0.874358450
	0.966394900	0.906488680	0.883576490
	0.967351090	0.912306080	0.892771690
	0.968532320	0.918068990	0.901690920
	0.969752520	0.923835400	0.910549510
	0.971000460	0.929610710	0.919346830
	0.972281100	0.935396720	0.928051320
	0.973601660	0.941197320	0.936603180
	0.974990940	0.947015770	0.944865600
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
