
function cm = dense(n, varargin)
% Colormap: dense

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.212984000	0.055892000	0.142210000
	0.217807000	0.057000000	0.146656000
	0.222612000	0.058088000	0.151159000
	0.227398000	0.059156000	0.155722000
	0.232165000	0.060201000	0.160350000
	0.236917000	0.061219000	0.165050000
	0.241647000	0.062222000	0.169816000
	0.246352000	0.063211000	0.174651000
	0.251031000	0.064189000	0.179556000
	0.255687000	0.065152000	0.184539000
	0.260316000	0.066106000	0.189597000
	0.264913000	0.067059000	0.194730000
	0.269477000	0.068011000	0.199938000
	0.274007000	0.068968000	0.205223000
	0.278500000	0.069932000	0.210583000
	0.282955000	0.070906000	0.216022000
	0.287370000	0.071893000	0.221539000
	0.291742000	0.072901000	0.227131000
	0.296069000	0.073933000	0.232796000
	0.300348000	0.074995000	0.238533000
	0.304579000	0.076089000	0.244340000
	0.308758000	0.077221000	0.250215000
	0.312885000	0.078395000	0.256156000
	0.316958000	0.079615000	0.262158000
	0.320976000	0.080884000	0.268220000
	0.324936000	0.082207000	0.274338000
	0.328839000	0.083586000	0.280508000
	0.332682000	0.085026000	0.286726000
	0.336467000	0.086528000	0.292989000
	0.340190000	0.088095000	0.299293000
	0.343854000	0.089728000	0.305634000
	0.347456000	0.091430000	0.312008000
	0.350997000	0.093201000	0.318412000
	0.354477000	0.095043000	0.324840000
	0.357897000	0.096955000	0.331291000
	0.361255000	0.098938000	0.337760000
	0.364554000	0.100992000	0.344244000
	0.367792000	0.103116000	0.350740000
	0.370971000	0.105309000	0.357245000
	0.374091000	0.107570000	0.363757000
	0.377153000	0.109899000	0.370271000
	0.380157000	0.112293000	0.376786000
	0.383104000	0.114752000	0.383300000
	0.385995000	0.117274000	0.389811000
	0.388830000	0.119857000	0.396315000
	0.391610000	0.122500000	0.402812000
	0.394337000	0.125200000	0.409300000
	0.397009000	0.127957000	0.415776000
	0.399629000	0.130768000	0.422240000
	0.402197000	0.133632000	0.428690000
	0.404714000	0.136546000	0.435125000
	0.407180000	0.139510000	0.441543000
	0.409596000	0.142521000	0.447943000
	0.411962000	0.145578000	0.454325000
	0.414280000	0.148679000	0.460687000
	0.416549000	0.151824000	0.467030000
	0.418771000	0.155009000	0.473351000
	0.420945000	0.158234000	0.479651000
	0.423073000	0.161498000	0.485928000
	0.425155000	0.164799000	0.492182000
	0.427190000	0.168136000	0.498413000
	0.429181000	0.171508000	0.504619000
	0.431127000	0.174913000	0.510800000
	0.433028000	0.178351000	0.516956000
	0.434886000	0.181821000	0.523087000
	0.436699000	0.185321000	0.529192000
	0.438469000	0.188851000	0.535270000
	0.440196000	0.192410000	0.541321000
	0.441880000	0.195996000	0.547346000
	0.443521000	0.199610000	0.553342000
	0.445120000	0.203251000	0.559311000
	0.446677000	0.206917000	0.565251000
	0.448192000	0.210609000	0.571162000
	0.449665000	0.214325000	0.577045000
	0.451097000	0.218065000	0.582898000
	0.452487000	0.221828000	0.588722000
	0.453835000	0.225615000	0.594515000
	0.455143000	0.229424000	0.600278000
	0.456409000	0.233256000	0.606010000
	0.457634000	0.237109000	0.611711000
	0.458818000	0.240983000	0.617381000
	0.459961000	0.244878000	0.623018000
	0.461063000	0.248794000	0.628623000
	0.462124000	0.252731000	0.634195000
	0.463145000	0.256687000	0.639733000
	0.464124000	0.260663000	0.645238000
	0.465063000	0.264659000	0.650708000
	0.465960000	0.268674000	0.656143000
	0.466817000	0.272708000	0.661544000
	0.467632000	0.276761000	0.666908000
	0.468406000	0.280833000	0.672235000
	0.469140000	0.284924000	0.677525000
	0.469832000	0.289033000	0.682777000
	0.470483000	0.293160000	0.687991000
	0.471093000	0.297305000	0.693165000
	0.471661000	0.301468000	0.698299000
	0.472189000	0.305650000	0.703392000
	0.472674000	0.309849000	0.708444000
	0.473118000	0.314065000	0.713454000
	0.473521000	0.318299000	0.718420000
	0.473882000	0.322551000	0.723342000
	0.474202000	0.326820000	0.728219000
	0.474480000	0.331106000	0.733050000
	0.474717000	0.335409000	0.737834000
	0.474913000	0.339729000	0.742569000
	0.475067000	0.344065000	0.747256000
	0.475181000	0.348419000	0.751892000
	0.475253000	0.352789000	0.756477000
	0.475285000	0.357175000	0.761010000
	0.475275000	0.361578000	0.765489000
	0.475225000	0.365997000	0.769914000
	0.475134000	0.370431000	0.774282000
	0.475004000	0.374882000	0.778593000
	0.474834000	0.379348000	0.782845000
	0.474625000	0.383830000	0.787038000
	0.474378000	0.388327000	0.791169000
	0.474093000	0.392838000	0.795237000
	0.473770000	0.397364000	0.799241000
	0.473411000	0.401905000	0.803180000
	0.473016000	0.406459000	0.807052000
	0.472586000	0.411027000	0.810856000
	0.472122000	0.415609000	0.814590000
	0.471625000	0.420203000	0.818253000
	0.471096000	0.424810000	0.821843000
	0.470538000	0.429429000	0.825359000
	0.469950000	0.434060000	0.828799000
	0.469335000	0.438701000	0.832163000
	0.468694000	0.443354000	0.835449000
	0.468029000	0.448016000	0.838654000
	0.467343000	0.452688000	0.841779000
	0.466636000	0.457369000	0.844821000
	0.465913000	0.462057000	0.847780000
	0.465174000	0.466754000	0.850654000
	0.464423000	0.471457000	0.853443000
	0.463662000	0.476166000	0.856144000
	0.462895000	0.480880000	0.858757000
	0.462123000	0.485598000	0.861281000
	0.461351000	0.490321000	0.863716000
	0.460582000	0.495045000	0.866059000
	0.459820000	0.499772000	0.868312000
	0.459069000	0.504499000	0.870473000
	0.458333000	0.509225000	0.872543000
	0.457615000	0.513951000	0.874519000
	0.456920000	0.518674000	0.876404000
	0.456253000	0.523394000	0.878196000
	0.455619000	0.528109000	0.879897000
	0.455020000	0.532819000	0.881505000
	0.454463000	0.537522000	0.883022000
	0.453952000	0.542218000	0.884448000
	0.453492000	0.546905000	0.885785000
	0.453088000	0.551582000	0.887032000
	0.452746000	0.556249000	0.888192000
	0.452469000	0.560903000	0.889266000
	0.452264000	0.565544000	0.890255000
	0.452134000	0.570172000	0.891161000
	0.452085000	0.574785000	0.891985000
	0.452120000	0.579381000	0.892730000
	0.452246000	0.583961000	0.893397000
	0.452466000	0.588524000	0.893990000
	0.452785000	0.593067000	0.894510000
	0.453205000	0.597592000	0.894959000
	0.453732000	0.602096000	0.895341000
	0.454368000	0.606580000	0.895658000
	0.455118000	0.611042000	0.895913000
	0.455983000	0.615482000	0.896109000
	0.456966000	0.619900000	0.896248000
	0.458070000	0.624295000	0.896334000
	0.459297000	0.628666000	0.896369000
	0.460649000	0.633014000	0.896357000
	0.462126000	0.637338000	0.896300000
	0.463731000	0.641637000	0.896202000
	0.465463000	0.645912000	0.896066000
	0.467323000	0.650162000	0.895894000
	0.469312000	0.654388000	0.895690000
	0.471429000	0.658589000	0.895456000
	0.473674000	0.662765000	0.895196000
	0.476045000	0.666917000	0.894912000
	0.478543000	0.671044000	0.894607000
	0.481166000	0.675147000	0.894284000
	0.483913000	0.679225000	0.893946000
	0.486781000	0.683280000	0.893594000
	0.489770000	0.687310000	0.893232000
	0.492877000	0.691317000	0.892862000
	0.496101000	0.695301000	0.892486000
	0.499438000	0.699262000	0.892107000
	0.502888000	0.703200000	0.891728000
	0.506447000	0.707116000	0.891349000
	0.510112000	0.711011000	0.890974000
	0.513883000	0.714883000	0.890604000
	0.517755000	0.718735000	0.890241000
	0.521727000	0.722566000	0.889886000
	0.525796000	0.726376000	0.889543000
	0.529959000	0.730167000	0.889212000
	0.534214000	0.733938000	0.888894000
	0.538558000	0.737691000	0.888593000
	0.542988000	0.741424000	0.888308000
	0.547503000	0.745140000	0.888042000
	0.552099000	0.748838000	0.887797000
	0.556774000	0.752518000	0.887573000
	0.561526000	0.756181000	0.887371000
	0.566353000	0.759828000	0.887193000
	0.571252000	0.763459000	0.887040000
	0.576221000	0.767074000	0.886913000
	0.581258000	0.770674000	0.886813000
	0.586361000	0.774259000	0.886742000
	0.591528000	0.777829000	0.886700000
	0.596757000	0.781386000	0.886689000
	0.602046000	0.784928000	0.886709000
	0.607394000	0.788457000	0.886761000
	0.612798000	0.791972000	0.886847000
	0.618257000	0.795475000	0.886967000
	0.623770000	0.798966000	0.887122000
	0.629334000	0.802444000	0.887313000
	0.634949000	0.805911000	0.887541000
	0.640613000	0.809366000	0.887807000
	0.646325000	0.812809000	0.888112000
	0.652083000	0.816242000	0.888456000
	0.657887000	0.819664000	0.888840000
	0.663734000	0.823075000	0.889266000
	0.669625000	0.826476000	0.889734000
	0.675558000	0.829868000	0.890244000
	0.681531000	0.833249000	0.890799000
	0.687544000	0.836621000	0.891399000
	0.693597000	0.839984000	0.892045000
	0.699687000	0.843337000	0.892737000
	0.705814000	0.846682000	0.893477000
	0.711978000	0.850018000	0.894266000
	0.718177000	0.853345000	0.895105000
	0.724411000	0.856665000	0.895994000
	0.730678000	0.859976000	0.896936000
	0.736978000	0.863279000	0.897930000
	0.743310000	0.866575000	0.898979000
	0.749674000	0.869863000	0.900083000
	0.756068000	0.873144000	0.901244000
	0.762491000	0.876418000	0.902462000
	0.768943000	0.879685000	0.903740000
	0.775423000	0.882946000	0.905078000
	0.781929000	0.886200000	0.906478000
	0.788462000	0.889448000	0.907941000
	0.795019000	0.892691000	0.909469000
	0.801600000	0.895929000	0.911063000
	0.808203000	0.899161000	0.912724000
	0.814828000	0.902389000	0.914454000
	0.821472000	0.905612000	0.916254000
	0.828135000	0.908832000	0.918126000
	0.834816000	0.912049000	0.920071000
	0.841512000	0.915263000	0.922090000
	0.848223000	0.918475000	0.924185000
	0.854946000	0.921685000	0.926357000
	0.861680000	0.924895000	0.928607000
	0.868423000	0.928104000	0.930937000
	0.875172000	0.931315000	0.933347000
	0.881928000	0.934526000	0.935837000
	0.888686000	0.937740000	0.938410000
	0.895445000	0.940958000	0.941065000
	0.902202000	0.944180000	0.943803000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
