
function cm = deep(n, varargin)
% Colormap: deep

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.156102000	0.102608000	0.172722000
	0.158800000	0.105628000	0.178082000
	0.161488000	0.108633000	0.183442000
	0.164157000	0.111623000	0.188840000
	0.166812000	0.114599000	0.194259000
	0.169451000	0.117563000	0.199702000
	0.172070000	0.120513000	0.205186000
	0.174677000	0.123452000	0.210680000
	0.177260000	0.126379000	0.216231000
	0.179831000	0.129297000	0.221783000
	0.182375000	0.132204000	0.227402000
	0.184907000	0.135103000	0.233023000
	0.187413000	0.137992000	0.238706000
	0.189903000	0.140874000	0.244398000
	0.192367000	0.143747000	0.250149000
	0.194814000	0.146616000	0.255911000
	0.197232000	0.149476000	0.261734000
	0.199633000	0.152333000	0.267566000
	0.202003000	0.155183000	0.273466000
	0.204355000	0.158030000	0.279369000
	0.206673000	0.160872000	0.285344000
	0.208970000	0.163712000	0.291329000
	0.211235000	0.166549000	0.297369000
	0.213473000	0.169385000	0.303438000
	0.215682000	0.172220000	0.309540000
	0.217855000	0.175053000	0.315693000
	0.220003000	0.177889000	0.321859000
	0.222108000	0.180724000	0.328090000
	0.224182000	0.183563000	0.334343000
	0.226222000	0.186405000	0.340620000
	0.228216000	0.189249000	0.346959000
	0.230173000	0.192100000	0.353313000
	0.232091000	0.194957000	0.359692000
	0.233957000	0.197821000	0.366128000
	0.235779000	0.200694000	0.372581000
	0.237556000	0.203577000	0.379051000
	0.239276000	0.206471000	0.385562000
	0.240939000	0.209379000	0.392100000
	0.242547000	0.212301000	0.398653000
	0.244096000	0.215241000	0.405219000
	0.245582000	0.218199000	0.411796000
	0.246993000	0.221179000	0.418397000
	0.248331000	0.224182000	0.425003000
	0.249592000	0.227211000	0.431607000
	0.250772000	0.230270000	0.438204000
	0.251865000	0.233361000	0.444785000
	0.252866000	0.236488000	0.451345000
	0.253769000	0.239655000	0.457872000
	0.254568000	0.242864000	0.464356000
	0.255257000	0.246121000	0.470783000
	0.255832000	0.249430000	0.477140000
	0.256288000	0.252794000	0.483409000
	0.256615000	0.256220000	0.489577000
	0.256809000	0.259710000	0.495625000
	0.256873000	0.263268000	0.501525000
	0.256807000	0.266897000	0.507254000
	0.256605000	0.270601000	0.512796000
	0.256274000	0.274380000	0.518126000
	0.255825000	0.278233000	0.523219000
	0.255260000	0.282160000	0.528062000
	0.254598000	0.286156000	0.532637000
	0.253851000	0.290217000	0.536935000
	0.253038000	0.294336000	0.540950000
	0.252175000	0.298505000	0.544684000
	0.251282000	0.302717000	0.548142000
	0.250373000	0.306963000	0.551335000
	0.249468000	0.311235000	0.554277000
	0.248576000	0.315527000	0.556982000
	0.247716000	0.319830000	0.559470000
	0.246891000	0.324139000	0.561759000
	0.246112000	0.328450000	0.563865000
	0.245390000	0.332755000	0.565808000
	0.244722000	0.337055000	0.567603000
	0.244116000	0.341344000	0.569266000
	0.243579000	0.345620000	0.570813000
	0.243106000	0.349883000	0.572254000
	0.242698000	0.354131000	0.573602000
	0.242362000	0.358361000	0.574869000
	0.242095000	0.362574000	0.576065000
	0.241894000	0.366770000	0.577197000
	0.241760000	0.370949000	0.578273000
	0.241691000	0.375111000	0.579300000
	0.241690000	0.379255000	0.580286000
	0.241753000	0.383381000	0.581236000
	0.241878000	0.387491000	0.582154000
	0.242064000	0.391585000	0.583045000
	0.242309000	0.395663000	0.583913000
	0.242611000	0.399726000	0.584762000
	0.242970000	0.403774000	0.585594000
	0.243382000	0.407808000	0.586413000
	0.243846000	0.411829000	0.587222000
	0.244361000	0.415837000	0.588022000
	0.244926000	0.419832000	0.588818000
	0.245537000	0.423816000	0.589609000
	0.246193000	0.427789000	0.590397000
	0.246891000	0.431752000	0.591184000
	0.247631000	0.435705000	0.591971000
	0.248411000	0.439649000	0.592759000
	0.249228000	0.443585000	0.593549000
	0.250080000	0.447513000	0.594342000
	0.250967000	0.451434000	0.595140000
	0.251885000	0.455348000	0.595941000
	0.252835000	0.459257000	0.596747000
	0.253813000	0.463160000	0.597559000
	0.254818000	0.467058000	0.598376000
	0.255850000	0.470952000	0.599199000
	0.256905000	0.474842000	0.600029000
	0.257983000	0.478729000	0.600864000
	0.259083000	0.482613000	0.601706000
	0.260202000	0.486495000	0.602553000
	0.261340000	0.490375000	0.603407000
	0.262495000	0.494254000	0.604267000
	0.263666000	0.498132000	0.605133000
	0.264852000	0.502009000	0.606004000
	0.266052000	0.505887000	0.606881000
	0.267264000	0.509764000	0.607762000
	0.268488000	0.513643000	0.608647000
	0.269723000	0.517523000	0.609537000
	0.270968000	0.521404000	0.610429000
	0.272223000	0.525287000	0.611325000
	0.273486000	0.529172000	0.612224000
	0.274757000	0.533060000	0.613124000
	0.276035000	0.536950000	0.614026000
	0.277321000	0.540844000	0.614928000
	0.278614000	0.544740000	0.615830000
	0.279913000	0.548641000	0.616732000
	0.281219000	0.552545000	0.617632000
	0.282531000	0.556453000	0.618529000
	0.283850000	0.560365000	0.619424000
	0.285175000	0.564281000	0.620315000
	0.286507000	0.568202000	0.621202000
	0.287847000	0.572128000	0.622083000
	0.289194000	0.576059000	0.622958000
	0.290549000	0.579994000	0.623825000
	0.291913000	0.583934000	0.624685000
	0.293288000	0.587879000	0.625535000
	0.294673000	0.591829000	0.626376000
	0.296070000	0.595784000	0.627206000
	0.297480000	0.599744000	0.628025000
	0.298904000	0.603709000	0.628831000
	0.300345000	0.607679000	0.629624000
	0.301803000	0.611653000	0.630402000
	0.303280000	0.615633000	0.631165000
	0.304778000	0.619617000	0.631912000
	0.306300000	0.623605000	0.632641000
	0.307847000	0.627598000	0.633353000
	0.309421000	0.631594000	0.634045000
	0.311026000	0.635595000	0.634718000
	0.312664000	0.639599000	0.635370000
	0.314337000	0.643606000	0.636000000
	0.316048000	0.647616000	0.636607000
	0.317801000	0.651629000	0.637192000
	0.319599000	0.655645000	0.637752000
	0.321445000	0.659662000	0.638287000
	0.323343000	0.663680000	0.638796000
	0.325297000	0.667700000	0.639279000
	0.327310000	0.671720000	0.639734000
	0.329386000	0.675740000	0.640162000
	0.331529000	0.679760000	0.640561000
	0.333744000	0.683778000	0.640930000
	0.336035000	0.687795000	0.641270000
	0.338407000	0.691809000	0.641579000
	0.340864000	0.695820000	0.641857000
	0.343411000	0.699827000	0.642104000
	0.346054000	0.703829000	0.642321000
	0.348797000	0.707826000	0.642505000
	0.351645000	0.711816000	0.642659000
	0.354603000	0.715799000	0.642781000
	0.357676000	0.719774000	0.642872000
	0.360870000	0.723740000	0.642929000
	0.364189000	0.727695000	0.642956000
	0.367640000	0.731639000	0.642952000
	0.371227000	0.735570000	0.642919000
	0.374954000	0.739488000	0.642857000
	0.378828000	0.743390000	0.642768000
	0.382852000	0.747277000	0.642649000
	0.387032000	0.751146000	0.642506000
	0.391372000	0.754997000	0.642339000
	0.395875000	0.758827000	0.642151000
	0.400546000	0.762636000	0.641942000
	0.405388000	0.766422000	0.641715000
	0.410405000	0.770184000	0.641474000
	0.415597000	0.773921000	0.641223000
	0.420968000	0.777631000	0.640962000
	0.426520000	0.781312000	0.640696000
	0.432251000	0.784965000	0.640430000
	0.438163000	0.788586000	0.640169000
	0.444257000	0.792176000	0.639915000
	0.450529000	0.795733000	0.639674000
	0.456977000	0.799257000	0.639453000
	0.463599000	0.802746000	0.639255000
	0.470390000	0.806199000	0.639086000
	0.477347000	0.809617000	0.638954000
	0.484463000	0.812999000	0.638862000
	0.491733000	0.816345000	0.638818000
	0.499150000	0.819655000	0.638828000
	0.506705000	0.822928000	0.638896000
	0.514391000	0.826167000	0.639030000
	0.522200000	0.829370000	0.639235000
	0.530123000	0.832539000	0.639514000
	0.538148000	0.835675000	0.639876000
	0.546270000	0.838779000	0.640323000
	0.554478000	0.841852000	0.640859000
	0.562761000	0.844895000	0.641489000
	0.571112000	0.847911000	0.642217000
	0.579522000	0.850901000	0.643044000
	0.587984000	0.853865000	0.643971000
	0.596485000	0.856806000	0.645005000
	0.605019000	0.859727000	0.646144000
	0.613583000	0.862628000	0.647389000
	0.622168000	0.865510000	0.648740000
	0.630769000	0.868376000	0.650199000
	0.639376000	0.871228000	0.651766000
	0.647984000	0.874067000	0.653441000
	0.656593000	0.876895000	0.655221000
	0.665197000	0.879712000	0.657107000
	0.673793000	0.882521000	0.659096000
	0.682378000	0.885323000	0.661189000
	0.690948000	0.888119000	0.663382000
	0.699501000	0.890911000	0.665676000
	0.708034000	0.893699000	0.668068000
	0.716546000	0.896484000	0.670556000
	0.725036000	0.899269000	0.673139000
	0.733501000	0.902054000	0.675815000
	0.741942000	0.904839000	0.678582000
	0.750357000	0.907626000	0.681438000
	0.758747000	0.910416000	0.684380000
	0.767110000	0.913208000	0.687408000
	0.775447000	0.916005000	0.690518000
	0.783758000	0.918806000	0.693710000
	0.792044000	0.921612000	0.696981000
	0.800304000	0.924423000	0.700329000
	0.808541000	0.927240000	0.703754000
	0.816754000	0.930063000	0.707252000
	0.824944000	0.932893000	0.710822000
	0.833106000	0.935732000	0.714463000
	0.841242000	0.938579000	0.718173000
	0.849359000	0.941434000	0.721951000
	0.857456000	0.944297000	0.725795000
	0.865536000	0.947167000	0.729703000
	0.873599000	0.950045000	0.733675000
	0.881633000	0.952935000	0.737708000
	0.889651000	0.955834000	0.741802000
	0.897657000	0.958742000	0.745956000
	0.905651000	0.961657000	0.750169000
	0.913627000	0.964583000	0.754439000
	0.921585000	0.967521000	0.758765000
	0.929535000	0.970466000	0.763147000
	0.937480000	0.973419000	0.767584000
	0.945407000	0.976385000	0.772075000
	0.953323000	0.979361000	0.776620000
	0.961238000	0.982344000	0.781218000
	0.969149000	0.985336000	0.785870000
	0.977042000	0.988342000	0.790572000
	0.984937000	0.991355000	0.795327000
	0.992837000	0.994373000	0.800136000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
