
function cm = curl(n, varargin)
% Colormap: curl

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.082256000	0.114924000	0.264790000
	0.084005000	0.123123000	0.268961000
	0.085751000	0.131164000	0.273186000
	0.087485000	0.139072000	0.277459000
	0.089203000	0.146865000	0.281774000
	0.090899000	0.154560000	0.286128000
	0.092565000	0.162170000	0.290516000
	0.094195000	0.169708000	0.294935000
	0.095781000	0.177183000	0.299381000
	0.097320000	0.184603000	0.303854000
	0.098807000	0.191977000	0.308349000
	0.100235000	0.199309000	0.312866000
	0.101593000	0.206609000	0.317399000
	0.102878000	0.213879000	0.321949000
	0.104087000	0.221124000	0.326512000
	0.105212000	0.228350000	0.331088000
	0.106240000	0.235560000	0.335670000
	0.107171000	0.242758000	0.340259000
	0.108002000	0.249946000	0.344853000
	0.108715000	0.257130000	0.349446000
	0.109313000	0.264310000	0.354038000
	0.109790000	0.271488000	0.358625000
	0.110131000	0.278670000	0.363204000
	0.110341000	0.285853000	0.367773000
	0.110403000	0.293043000	0.372326000
	0.110320000	0.300240000	0.376863000
	0.110081000	0.307446000	0.381379000
	0.109682000	0.314662000	0.385871000
	0.109119000	0.321888000	0.390335000
	0.108385000	0.329127000	0.394768000
	0.107475000	0.336379000	0.399165000
	0.106393000	0.343644000	0.403525000
	0.105119000	0.350925000	0.407839000
	0.103671000	0.358218000	0.412108000
	0.102034000	0.365527000	0.416326000
	0.100209000	0.372850000	0.420488000
	0.098208000	0.380187000	0.424591000
	0.096033000	0.387538000	0.428631000
	0.093679000	0.394903000	0.432601000
	0.091170000	0.402280000	0.436498000
	0.088524000	0.409669000	0.440318000
	0.085762000	0.417068000	0.444057000
	0.082915000	0.424476000	0.447709000
	0.080027000	0.431891000	0.451269000
	0.077150000	0.439312000	0.454733000
	0.074357000	0.446735000	0.458097000
	0.071737000	0.454159000	0.461354000
	0.069402000	0.461580000	0.464502000
	0.067485000	0.468995000	0.467535000
	0.066140000	0.476400000	0.470451000
	0.065520000	0.483792000	0.473243000
	0.065812000	0.491165000	0.475910000
	0.067178000	0.498514000	0.478452000
	0.069734000	0.505835000	0.480861000
	0.073593000	0.513119000	0.483144000
	0.078778000	0.520363000	0.485296000
	0.085293000	0.527557000	0.487323000
	0.093082000	0.534696000	0.489230000
	0.102066000	0.541771000	0.491022000
	0.112148000	0.548775000	0.492710000
	0.123221000	0.555701000	0.494307000
	0.135179000	0.562542000	0.495829000
	0.147916000	0.569290000	0.497294000
	0.161331000	0.575941000	0.498723000
	0.175326000	0.582491000	0.500141000
	0.189809000	0.588936000	0.501575000
	0.204694000	0.595275000	0.503050000
	0.219898000	0.601509000	0.504595000
	0.235346000	0.607639000	0.506237000
	0.250969000	0.613669000	0.508001000
	0.266704000	0.619604000	0.509912000
	0.282497000	0.625449000	0.511990000
	0.298300000	0.631211000	0.514254000
	0.314074000	0.636897000	0.516719000
	0.329787000	0.642516000	0.519400000
	0.345412000	0.648073000	0.522305000
	0.360928000	0.653577000	0.525442000
	0.376319000	0.659035000	0.528819000
	0.391573000	0.664454000	0.532438000
	0.406682000	0.669840000	0.536303000
	0.421640000	0.675200000	0.540414000
	0.436445000	0.680540000	0.544772000
	0.451096000	0.685865000	0.549376000
	0.465590000	0.691181000	0.554226000
	0.479931000	0.696491000	0.559318000
	0.494120000	0.701802000	0.564651000
	0.508160000	0.707117000	0.570223000
	0.522052000	0.712440000	0.576030000
	0.535803000	0.717775000	0.582069000
	0.549412000	0.723126000	0.588338000
	0.562887000	0.728495000	0.594831000
	0.576227000	0.733887000	0.601547000
	0.589438000	0.739305000	0.608480000
	0.602526000	0.744750000	0.615627000
	0.615492000	0.750226000	0.622984000
	0.628340000	0.755736000	0.630546000
	0.641071000	0.761283000	0.638311000
	0.653692000	0.766868000	0.646272000
	0.666206000	0.772494000	0.654427000
	0.678615000	0.778163000	0.662770000
	0.690923000	0.783877000	0.671297000
	0.703133000	0.789639000	0.680003000
	0.715249000	0.795451000	0.688885000
	0.727273000	0.801314000	0.697936000
	0.739209000	0.807230000	0.707154000
	0.751058000	0.813201000	0.716532000
	0.762823000	0.819230000	0.726065000
	0.774509000	0.825317000	0.735750000
	0.786119000	0.831464000	0.745581000
	0.797655000	0.837673000	0.755555000
	0.809118000	0.843946000	0.765663000
	0.820513000	0.850283000	0.775903000
	0.831843000	0.856687000	0.786270000
	0.843109000	0.863159000	0.796756000
	0.854315000	0.869700000	0.807358000
	0.865465000	0.876311000	0.818071000
	0.876560000	0.882994000	0.828885000
	0.887607000	0.889749000	0.839799000
	0.898607000	0.896579000	0.850801000
	0.909571000	0.903480000	0.861890000
	0.920501000	0.910455000	0.873055000
	0.931413000	0.917499000	0.884296000
	0.942317000	0.924610000	0.895613000
	0.953232000	0.931779000	0.907026000
	0.964157000	0.939003000	0.918588000
	0.975030000	0.946300000	0.930393000
	0.985693000	0.953728000	0.942499000
	0.996024000	0.961359000	0.954732000
	0.992947000	0.962495000	0.955943000
	0.987975000	0.952741000	0.942976000
	0.983173000	0.943003000	0.929886000
	0.978530000	0.933275000	0.916727000
	0.974037000	0.923555000	0.903531000
	0.969687000	0.913844000	0.890314000
	0.965471000	0.904139000	0.877095000
	0.961379000	0.894441000	0.863887000
	0.957409000	0.884748000	0.850698000
	0.953554000	0.875059000	0.837536000
	0.949810000	0.865374000	0.824409000
	0.946170000	0.855691000	0.811325000
	0.942627000	0.846010000	0.798293000
	0.939181000	0.836329000	0.785318000
	0.935829000	0.826647000	0.772402000
	0.932560000	0.816963000	0.759559000
	0.929373000	0.807277000	0.746792000
	0.926268000	0.797585000	0.734104000
	0.923231000	0.787890000	0.721509000
	0.920267000	0.778187000	0.709007000
	0.917368000	0.768477000	0.696608000
	0.914526000	0.758759000	0.684322000
	0.911745000	0.749031000	0.672149000
	0.909009000	0.739294000	0.660107000
	0.906326000	0.729543000	0.648192000
	0.903680000	0.719783000	0.636424000
	0.901073000	0.710009000	0.624804000
	0.898498000	0.700222000	0.613344000
	0.895945000	0.690423000	0.602055000
	0.893417000	0.680608000	0.590943000
	0.890901000	0.670780000	0.580022000
	0.888390000	0.660940000	0.569303000
	0.885886000	0.651085000	0.558793000
	0.883376000	0.641217000	0.548506000
	0.880853000	0.631338000	0.538455000
	0.878310000	0.621448000	0.528650000
	0.875740000	0.611550000	0.519103000
	0.873135000	0.601644000	0.509827000
	0.870490000	0.591733000	0.500832000
	0.867793000	0.581819000	0.492130000
	0.865037000	0.571906000	0.483734000
	0.862213000	0.561997000	0.475652000
	0.859313000	0.552096000	0.467895000
	0.856328000	0.542207000	0.460470000
	0.853249000	0.532335000	0.453387000
	0.850068000	0.522485000	0.446650000
	0.846777000	0.512661000	0.440265000
	0.843369000	0.502870000	0.434233000
	0.839835000	0.493116000	0.428556000
	0.836172000	0.483405000	0.423232000
	0.832372000	0.473743000	0.418260000
	0.828429000	0.464134000	0.413633000
	0.824341000	0.454585000	0.409346000
	0.820104000	0.445099000	0.405391000
	0.815715000	0.435682000	0.401757000
	0.811172000	0.426337000	0.398433000
	0.806476000	0.417069000	0.395408000
	0.801625000	0.407880000	0.392667000
	0.796620000	0.398773000	0.390198000
	0.791463000	0.389752000	0.387986000
	0.786154000	0.380817000	0.386017000
	0.780698000	0.371971000	0.384275000
	0.775095000	0.363214000	0.382746000
	0.769348000	0.354548000	0.381416000
	0.763462000	0.345973000	0.380270000
	0.757439000	0.337489000	0.379295000
	0.751282000	0.329097000	0.378478000
	0.744994000	0.320796000	0.377804000
	0.738580000	0.312585000	0.377262000
	0.732043000	0.304465000	0.376841000
	0.725384000	0.296435000	0.376528000
	0.718609000	0.288495000	0.376312000
	0.711719000	0.280644000	0.376184000
	0.704718000	0.272882000	0.376133000
	0.697608000	0.265208000	0.376149000
	0.690391000	0.257622000	0.376223000
	0.683069000	0.250125000	0.376347000
	0.675645000	0.242717000	0.376511000
	0.668120000	0.235397000	0.376707000
	0.660495000	0.228168000	0.376926000
	0.652773000	0.221030000	0.377161000
	0.644952000	0.213984000	0.377402000
	0.637036000	0.207034000	0.377641000
	0.629023000	0.200182000	0.377870000
	0.620914000	0.193430000	0.378080000
	0.612709000	0.186784000	0.378260000
	0.604409000	0.180248000	0.378404000
	0.596011000	0.173827000	0.378499000
	0.587516000	0.167529000	0.378536000
	0.578924000	0.161361000	0.378504000
	0.570232000	0.155332000	0.378390000
	0.561440000	0.149452000	0.378181000
	0.552547000	0.143732000	0.377866000
	0.543551000	0.138183000	0.377427000
	0.534452000	0.132821000	0.376851000
	0.525249000	0.127657000	0.376121000
	0.515941000	0.122708000	0.375218000
	0.506528000	0.117987000	0.374126000
	0.497009000	0.113510000	0.372824000
	0.487388000	0.109290000	0.371294000
	0.477664000	0.105338000	0.369515000
	0.467841000	0.101664000	0.367468000
	0.457922000	0.098273000	0.365134000
	0.447914000	0.095165000	0.362495000
	0.437822000	0.092337000	0.359536000
	0.427654000	0.089778000	0.356242000
	0.417418000	0.087475000	0.352605000
	0.407126000	0.085405000	0.348615000
	0.396786000	0.083544000	0.344270000
	0.386409000	0.081864000	0.339570000
	0.376009000	0.080328000	0.334517000
	0.365596000	0.078909000	0.329121000
	0.355179000	0.077573000	0.323392000
	0.344770000	0.076285000	0.317343000
	0.334381000	0.075015000	0.310988000
	0.324017000	0.073736000	0.304346000
	0.313687000	0.072424000	0.297433000
	0.303397000	0.071056000	0.290270000
	0.293152000	0.069612000	0.282873000
	0.282957000	0.068078000	0.275260000
	0.272815000	0.066439000	0.267451000
	0.262728000	0.064683000	0.259460000
	0.252701000	0.062796000	0.251307000
	0.242730000	0.060776000	0.243003000
	0.232814000	0.058620000	0.234561000
	0.222957000	0.056316000	0.225997000
	0.213154000	0.053860000	0.217320000
	0.203400000	0.051257000	0.208537000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
