
function cm = crest(n, varargin)
% Colormap: crest

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.168627000	0.200000000	0.447059000
	0.168627000	0.211765000	0.450980000
	0.164706000	0.223529000	0.458824000
	0.164706000	0.235294000	0.466667000
	0.160784000	0.243137000	0.470588000
	0.156863000	0.258824000	0.478431000
	0.152941000	0.270588000	0.486275000
	0.149020000	0.282353000	0.494118000
	0.141176000	0.290196000	0.498039000
	0.137255000	0.305882000	0.501961000
	0.133333000	0.317647000	0.509804000
	0.125490000	0.325490000	0.513725000
	0.121569000	0.341176000	0.517647000
	0.117647000	0.349020000	0.521569000
	0.113725000	0.360784000	0.525490000
	0.113725000	0.372549000	0.529412000
	0.109804000	0.388235000	0.529412000
	0.109804000	0.396078000	0.533333000
	0.109804000	0.403922000	0.537255000
	0.109804000	0.415686000	0.537255000
	0.117647000	0.427451000	0.541176000
	0.121569000	0.439216000	0.541176000
	0.129412000	0.450980000	0.545098000
	0.137255000	0.458824000	0.545098000
	0.149020000	0.470588000	0.545098000
	0.152941000	0.478431000	0.545098000
	0.164706000	0.490196000	0.549020000
	0.176471000	0.501961000	0.549020000
	0.188235000	0.509804000	0.549020000
	0.200000000	0.517647000	0.552941000
	0.211765000	0.529412000	0.552941000
	0.223529000	0.541176000	0.552941000
	0.231373000	0.545098000	0.556863000
	0.243137000	0.556863000	0.556863000
	0.254902000	0.568627000	0.556863000
	0.266667000	0.580392000	0.556863000
	0.274510000	0.584314000	0.560784000
	0.286275000	0.596078000	0.560784000
	0.298039000	0.607843000	0.560784000
	0.309804000	0.619608000	0.560784000
	0.321569000	0.631373000	0.560784000
	0.333333000	0.635294000	0.564706000
	0.345098000	0.647059000	0.564706000
	0.364706000	0.658824000	0.564706000
	0.372549000	0.662745000	0.564706000
	0.392157000	0.674510000	0.564706000
	0.407843000	0.686275000	0.564706000
	0.423529000	0.694118000	0.564706000
	0.439216000	0.701961000	0.564706000
	0.462745000	0.713725000	0.564706000
	0.474510000	0.721569000	0.564706000
	0.498039000	0.729412000	0.564706000
	0.517647000	0.741176000	0.568627000
	0.537255000	0.745098000	0.568627000
	0.552941000	0.756863000	0.568627000
	0.576471000	0.768627000	0.568627000
	0.592157000	0.776471000	0.568627000
	0.611765000	0.784314000	0.564706000
	0.631373000	0.796078000	0.564706000
	0.682353000	0.819608000	0.607843000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
