
function cm = corko(n, varargin)
% Colormap: corko

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.246513659	0.243518023	0.229200164
	0.246074413	0.242432951	0.232323201
	0.245642504	0.241446949	0.235541853
	0.245219512	0.240524255	0.238831354
	0.244807017	0.239744418	0.242251370
	0.244406532	0.239052234	0.245763848
	0.244019590	0.238466840	0.249403145
	0.243647496	0.238019286	0.253161683
	0.243291688	0.237693414	0.257029884
	0.242954502	0.237487697	0.261017223
	0.242639259	0.237411231	0.265129608
	0.242349051	0.237472339	0.269403094
	0.242085585	0.237674711	0.273788285
	0.241849243	0.238019927	0.278314370
	0.241641739	0.238522418	0.282994768
	0.241466184	0.239213971	0.287800518
	0.241326880	0.240053440	0.292779031
	0.241229028	0.241085717	0.297907483
	0.241177478	0.242293530	0.303192405
	0.241176730	0.243678560	0.308657751
	0.241231201	0.245267012	0.314253207
	0.241345107	0.247067578	0.320033119
	0.241521727	0.249063120	0.325941539
	0.241763323	0.251268166	0.332045282
	0.242073609	0.253668098	0.338279633
	0.242460005	0.256274427	0.344685839
	0.242934098	0.259134369	0.351244595
	0.243501942	0.262175116	0.357947932
	0.244166971	0.265444594	0.364777689
	0.244937716	0.268947936	0.371749359
	0.245822946	0.272630646	0.378858362
	0.246829029	0.276565261	0.386072937
	0.247970363	0.280668537	0.393409129
	0.249209154	0.285008878	0.400855741
	0.250593270	0.289560916	0.408361812
	0.252143336	0.294281308	0.415958723
	0.253829431	0.299221337	0.423617194
	0.255667956	0.304315281	0.431346733
	0.257671467	0.309611419	0.439092447
	0.259861678	0.315041005	0.446885872
	0.262206997	0.320661800	0.454698033
	0.264728520	0.326392154	0.462494397
	0.267428985	0.332303016	0.470306684
	0.270356700	0.338305078	0.478085278
	0.273434499	0.344443662	0.485837907
	0.276703856	0.350707537	0.493554473
	0.280149731	0.357053597	0.501228308
	0.283800122	0.363475614	0.508837969
	0.287628728	0.369991730	0.516369856
	0.291666640	0.376594284	0.523844802
	0.295857369	0.383243039	0.531232892
	0.300240163	0.389935992	0.538543027
	0.304804063	0.396689693	0.545753459
	0.309546192	0.403494389	0.552865257
	0.314424499	0.410324210	0.559891490
	0.319491426	0.417174037	0.566812206
	0.324694206	0.424036474	0.573625734
	0.330071684	0.430932345	0.580341286
	0.335580561	0.437835488	0.586945519
	0.341220812	0.444739314	0.593453841
	0.347002516	0.451643194	0.599853214
	0.352900072	0.458544593	0.606142046
	0.358908171	0.465438309	0.612334830
	0.365045936	0.472343135	0.618431092
	0.371280726	0.479225907	0.624418180
	0.377628019	0.486092777	0.630307642
	0.384061392	0.492947093	0.636097566
	0.390584239	0.499789765	0.641787032
	0.397183931	0.506620236	0.647387932
	0.403874322	0.513433771	0.652887619
	0.410632481	0.520214251	0.658307208
	0.417448637	0.526994788	0.663634903
	0.424320274	0.533729836	0.668865466
	0.431261480	0.540462493	0.674008795
	0.438241103	0.547164414	0.679065151
	0.445264151	0.553843143	0.684035131
	0.452340186	0.560501028	0.688930576
	0.459434365	0.567135453	0.693722724
	0.466560017	0.573735535	0.698436231
	0.473703432	0.580317165	0.703069393
	0.480871581	0.586863587	0.707605320
	0.488064053	0.593390331	0.712058584
	0.495245697	0.599882735	0.716425631
	0.502429825	0.606340608	0.720690159
	0.509613033	0.612768337	0.724873488
	0.516785041	0.619174958	0.728950633
	0.523936951	0.625526604	0.732936909
	0.531064907	0.631849957	0.736814664
	0.538168637	0.638130106	0.740588674
	0.545221840	0.644364292	0.744254459
	0.552237786	0.650560896	0.747809155
	0.559190815	0.656707678	0.751242403
	0.566088998	0.662798691	0.754547948
	0.572921967	0.668831308	0.757721212
	0.579670109	0.674802935	0.760762521
	0.586324923	0.680707630	0.763657217
	0.592889464	0.686552168	0.766407288
	0.599339432	0.692322804	0.768996779
	0.605663068	0.697997712	0.771431939
	0.611869273	0.703598250	0.773682977
	0.617929028	0.709105648	0.775763330
	0.623842749	0.714500434	0.777658884
	0.629575784	0.719802013	0.779351012
	0.635140408	0.724984510	0.780844780
	0.640515407	0.730041348	0.782129998
	0.645680088	0.734968230	0.783189392
	0.650637032	0.739758367	0.784031505
	0.655359590	0.744390866	0.784633070
	0.659845137	0.748871926	0.784992869
	0.664074754	0.753186782	0.785105745
	0.668040666	0.757332527	0.784965229
	0.671720400	0.761291348	0.784566266
	0.675118133	0.765062721	0.783901580
	0.678217880	0.768623685	0.782962871
	0.681000291	0.771988058	0.781763274
	0.683476608	0.775129587	0.780280796
	0.685625863	0.778055495	0.778528337
	0.687438170	0.780747139	0.776501873
	0.688919895	0.783205857	0.774192483
	0.690050561	0.785428474	0.771621199
	0.690836675	0.787402997	0.768767219
	0.691282746	0.789133770	0.765659098
	0.691381831	0.790608252	0.762275609
	0.691132945	0.791835606	0.758645197
	0.690543476	0.792812199	0.754761976
	0.689620883	0.793537344	0.750630799
	0.688356007	0.794007577	0.746260622
	0.686760698	0.794227295	0.741664352
	0.684846255	0.794200710	0.736852313
	0.682618800	0.793930883	0.731828968
	0.680084186	0.793419451	0.726601148
	0.677268856	0.792669255	0.721179665
	0.674152912	0.791689968	0.715587201
	0.670774633	0.790486791	0.709810876
	0.667124670	0.789068629	0.703871865
	0.663236223	0.787430427	0.697778314
	0.659095251	0.785589519	0.691544019
	0.654735080	0.783546143	0.685174159
	0.650167830	0.781309720	0.678670568
	0.645388422	0.778884221	0.672052150
	0.640429488	0.776282091	0.665317228
	0.635282710	0.773500246	0.658478633
	0.629975344	0.770558576	0.651546036
	0.624512364	0.767447875	0.644509567
	0.618908361	0.764187585	0.637398489
	0.613153303	0.760777458	0.630202346
	0.607297901	0.757218887	0.622927709
	0.601309512	0.753521206	0.615577592
	0.595225858	0.749687398	0.608172508
	0.589041579	0.745729776	0.600687726
	0.582778646	0.741641191	0.593154945
	0.576447508	0.737433558	0.585561690
	0.570021599	0.733108061	0.577899643
	0.563557735	0.728661228	0.570198232
	0.557029182	0.724105625	0.562458063
	0.550447791	0.719442910	0.554652245
	0.543830910	0.714663423	0.546808758
	0.537188153	0.709789653	0.538920081
	0.530505965	0.704804758	0.530987813
	0.523810032	0.699718713	0.523021867
	0.517103290	0.694532397	0.515011939
	0.510377263	0.689260001	0.506969057
	0.503656659	0.683872074	0.498898139
	0.496940050	0.678400941	0.490801632
	0.490237327	0.672836018	0.482659893
	0.483540860	0.667169057	0.474507640
	0.476876467	0.661418218	0.466323366
	0.470240271	0.655574416	0.458125761
	0.463625942	0.649645170	0.449918399
	0.457056945	0.643620313	0.441701678
	0.450537775	0.637521945	0.433463175
	0.444070328	0.631338858	0.425246025
	0.437657737	0.625071408	0.417024397
	0.431303927	0.618736357	0.408805156
	0.425019491	0.612310690	0.400621400
	0.418803804	0.605821795	0.392434889
	0.412688933	0.599277320	0.384292589
	0.406640995	0.592663982	0.376198748
	0.400704815	0.585986439	0.368135065
	0.394842523	0.579257746	0.360127930
	0.389103074	0.572480630	0.352186650
	0.383469162	0.565651453	0.344316399
	0.377941720	0.558793865	0.336534346
	0.372536087	0.551915948	0.328851250
	0.367260772	0.545000234	0.321249062
	0.362122193	0.538076340	0.313772413
	0.357114277	0.531130101	0.306416516
	0.352221369	0.524186957	0.299182257
	0.347497311	0.517254606	0.292086590
	0.342904247	0.510320312	0.285134793
	0.338440168	0.503409979	0.278372232
	0.334151699	0.496529863	0.271743852
	0.329998243	0.489687547	0.265325150
	0.325977441	0.482890226	0.259098871
	0.322137445	0.476143532	0.253041966
	0.318433588	0.469457108	0.247192280
	0.314872853	0.462810161	0.241561457
	0.311471239	0.456258603	0.236143598
	0.308216824	0.449780997	0.230934362
	0.305113655	0.443384580	0.225970497
	0.302128466	0.437077837	0.221220298
	0.299319717	0.430860569	0.216708028
	0.296625583	0.424743605	0.212418945
	0.294052971	0.418722256	0.208367232
	0.291641355	0.412827064	0.204572565
	0.289337279	0.407019055	0.200965440
	0.287136537	0.401336463	0.197646284
	0.285071420	0.395767337	0.194568036
	0.283136318	0.390300185	0.191665459
	0.281275244	0.384960300	0.189031541
	0.279550832	0.379744998	0.186605545
	0.277899800	0.374647424	0.184407072
	0.276355597	0.369656859	0.182405314
	0.274874897	0.364791039	0.180634226
	0.273507443	0.360044193	0.179081578
	0.272179526	0.355427035	0.177733439
	0.270974943	0.350908177	0.176510598
	0.269817939	0.346493223	0.175526950
	0.268723357	0.342209750	0.174739163
	0.267660243	0.338018078	0.174088796
	0.266698829	0.333958646	0.173610950
	0.265782155	0.329992040	0.173298992
	0.264889533	0.326110845	0.173142363
	0.264077218	0.322365846	0.173133968
	0.263285050	0.318696778	0.173267631
	0.262522640	0.315126444	0.173537882
	0.261802417	0.311646822	0.173941498
	0.261114311	0.308274886	0.174476823
	0.260455246	0.304988509	0.175118024
	0.259828051	0.301770422	0.175843440
	0.259224271	0.298661201	0.176722912
	0.258621546	0.295620867	0.177731003
	0.258037403	0.292666358	0.178787524
	0.257492817	0.289793623	0.179938988
	0.256958069	0.286984247	0.181191963
	0.256418693	0.284265799	0.182544952
	0.255901255	0.281622764	0.183996358
	0.255409776	0.279056097	0.185551999
	0.254919293	0.276550304	0.187140642
	0.254422078	0.274107901	0.188825243
	0.253930128	0.271725551	0.190576332
	0.253447603	0.269457018	0.192421461
	0.252969768	0.267202387	0.194366390
	0.252495467	0.265049178	0.196351574
	0.252027855	0.262972393	0.198389354
	0.251563946	0.260945120	0.200519567
	0.251092197	0.259003541	0.202748809
	0.250610829	0.257113416	0.205043757
	0.250136166	0.255306561	0.207416468
	0.249677939	0.253559405	0.209848305
	0.249229275	0.251896831	0.212377199
	0.248782262	0.250278524	0.214953745
	0.248331284	0.248789557	0.217647733
	0.247873111	0.247344396	0.220422384
	0.247413396	0.245975373	0.223257737
	0.246959701	0.244699036	0.226195206
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
