
function cm = cividis(n, varargin)
% Colormap: cividis

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.000000000	0.135112000	0.304751000
	0.000000000	0.138068000	0.311105000
	0.000000000	0.141013000	0.317579000
	0.000000000	0.143951000	0.323982000
	0.000000000	0.146877000	0.330479000
	0.000000000	0.149791000	0.337065000
	0.000000000	0.152673000	0.343704000
	0.000000000	0.155377000	0.350500000
	0.000000000	0.157932000	0.357521000
	0.000000000	0.160495000	0.364534000
	0.000000000	0.163058000	0.371608000
	0.000000000	0.165621000	0.378769000
	0.000000000	0.168204000	0.385902000
	0.000000000	0.170800000	0.393100000
	0.000000000	0.173420000	0.400353000
	0.000000000	0.176082000	0.407577000
	0.000000000	0.178802000	0.414764000
	0.000000000	0.181610000	0.421859000
	0.000000000	0.184550000	0.428802000
	0.000000000	0.186915000	0.435532000
	0.000000000	0.188769000	0.439563000
	0.000000000	0.190950000	0.441085000
	0.000000000	0.193366000	0.441561000
	0.003602000	0.195911000	0.441564000
	0.017852000	0.198528000	0.441248000
	0.032110000	0.201199000	0.440785000
	0.046205000	0.203903000	0.440196000
	0.058378000	0.206629000	0.439531000
	0.068968000	0.209372000	0.438863000
	0.078624000	0.212122000	0.438105000
	0.087465000	0.214879000	0.437342000
	0.095645000	0.217643000	0.436593000
	0.103401000	0.220406000	0.435790000
	0.110658000	0.223170000	0.435067000
	0.117612000	0.225935000	0.434308000
	0.124291000	0.228697000	0.433547000
	0.130669000	0.231458000	0.432840000
	0.136830000	0.234216000	0.432148000
	0.142852000	0.236972000	0.431404000
	0.148638000	0.239724000	0.430752000
	0.154261000	0.242475000	0.430120000
	0.159733000	0.245221000	0.429528000
	0.165113000	0.247965000	0.428908000
	0.170362000	0.250707000	0.428325000
	0.175490000	0.253444000	0.427790000
	0.180503000	0.256180000	0.427299000
	0.185453000	0.258914000	0.426788000
	0.190303000	0.261644000	0.426329000
	0.195057000	0.264372000	0.425924000
	0.199764000	0.267099000	0.425497000
	0.204385000	0.269823000	0.425126000
	0.208926000	0.272546000	0.424809000
	0.213431000	0.275266000	0.424480000
	0.217863000	0.277985000	0.424206000
	0.222264000	0.280702000	0.423914000
	0.226598000	0.283419000	0.423678000
	0.230871000	0.286134000	0.423498000
	0.235120000	0.288848000	0.423304000
	0.239312000	0.291562000	0.423167000
	0.243485000	0.294274000	0.423014000
	0.247605000	0.296986000	0.422917000
	0.251675000	0.299698000	0.422873000
	0.255731000	0.302409000	0.422814000
	0.259740000	0.305120000	0.422810000
	0.263738000	0.307831000	0.422789000
	0.267693000	0.310542000	0.422821000
	0.271639000	0.313253000	0.422837000
	0.275513000	0.315965000	0.422979000
	0.279411000	0.318677000	0.423031000
	0.283240000	0.321390000	0.423211000
	0.287065000	0.324103000	0.423373000
	0.290884000	0.326816000	0.423517000
	0.294669000	0.329531000	0.423716000
	0.298421000	0.332247000	0.423973000
	0.302169000	0.334963000	0.424213000
	0.305886000	0.337681000	0.424512000
	0.309601000	0.340399000	0.424790000
	0.313287000	0.343120000	0.425120000
	0.316941000	0.345842000	0.425512000
	0.320595000	0.348565000	0.425889000
	0.324250000	0.351289000	0.426250000
	0.327875000	0.354016000	0.426670000
	0.331474000	0.356744000	0.427144000
	0.335073000	0.359474000	0.427605000
	0.338673000	0.362206000	0.428053000
	0.342246000	0.364939000	0.428559000
	0.345793000	0.367676000	0.429127000
	0.349341000	0.370414000	0.429685000
	0.352892000	0.373153000	0.430226000
	0.356418000	0.375896000	0.430823000
	0.359916000	0.378641000	0.431501000
	0.363446000	0.381388000	0.432075000
	0.366923000	0.384139000	0.432796000
	0.370430000	0.386890000	0.433428000
	0.373884000	0.389646000	0.434209000
	0.377371000	0.392404000	0.434890000
	0.380830000	0.395164000	0.435653000
	0.384268000	0.397928000	0.436475000
	0.387705000	0.400694000	0.437305000
	0.391151000	0.403464000	0.438096000
	0.394568000	0.406236000	0.438986000
	0.397991000	0.409011000	0.439848000
	0.401418000	0.411790000	0.440708000
	0.404820000	0.414572000	0.441642000
	0.408226000	0.417357000	0.442570000
	0.411607000	0.420145000	0.443577000
	0.414992000	0.422937000	0.444578000
	0.418383000	0.425733000	0.445560000
	0.421748000	0.428531000	0.446640000
	0.425120000	0.431334000	0.447692000
	0.428462000	0.434140000	0.448864000
	0.431817000	0.436950000	0.449982000
	0.435168000	0.439763000	0.451134000
	0.438504000	0.442580000	0.452341000
	0.441810000	0.445402000	0.453659000
	0.445148000	0.448226000	0.454885000
	0.448447000	0.451053000	0.456264000
	0.451759000	0.453887000	0.457582000
	0.455072000	0.456718000	0.458976000
	0.458366000	0.459552000	0.460457000
	0.461616000	0.462405000	0.461969000
	0.464947000	0.465241000	0.463395000
	0.468254000	0.468083000	0.464908000
	0.471501000	0.470960000	0.466357000
	0.474812000	0.473832000	0.467681000
	0.478186000	0.476699000	0.468845000
	0.481622000	0.479573000	0.469767000
	0.485141000	0.482451000	0.470384000
	0.488697000	0.485318000	0.471008000
	0.492278000	0.488198000	0.471453000
	0.495913000	0.491076000	0.471751000
	0.499552000	0.493960000	0.472032000
	0.503185000	0.496851000	0.472305000
	0.506866000	0.499743000	0.472432000
	0.510540000	0.502643000	0.472550000
	0.514226000	0.505546000	0.472640000
	0.517920000	0.508454000	0.472707000
	0.521643000	0.511367000	0.472639000
	0.525348000	0.514285000	0.472660000
	0.529086000	0.517207000	0.472543000
	0.532829000	0.520135000	0.472401000
	0.536553000	0.523067000	0.472352000
	0.540307000	0.526005000	0.472163000
	0.544069000	0.528948000	0.471947000
	0.547840000	0.531895000	0.471704000
	0.551612000	0.534849000	0.471439000
	0.555393000	0.537807000	0.471147000
	0.559181000	0.540771000	0.470829000
	0.562972000	0.543741000	0.470488000
	0.566802000	0.546715000	0.469988000
	0.570607000	0.549695000	0.469593000
	0.574417000	0.552682000	0.469172000
	0.578236000	0.555673000	0.468724000
	0.582087000	0.558670000	0.468118000
	0.585916000	0.561674000	0.467618000
	0.589753000	0.564682000	0.467090000
	0.593622000	0.567697000	0.466401000
	0.597469000	0.570718000	0.465821000
	0.601354000	0.573743000	0.465074000
	0.605211000	0.576777000	0.464441000
	0.609105000	0.579816000	0.463638000
	0.612977000	0.582861000	0.462950000
	0.616852000	0.585913000	0.462237000
	0.620765000	0.588970000	0.461351000
	0.624654000	0.592034000	0.460583000
	0.628576000	0.595104000	0.459641000
	0.632506000	0.598180000	0.458668000
	0.636412000	0.601264000	0.457818000
	0.640352000	0.604354000	0.456791000
	0.644270000	0.607450000	0.455886000
	0.648222000	0.610553000	0.454801000
	0.652178000	0.613664000	0.453689000
	0.656114000	0.616780000	0.452702000
	0.660082000	0.619904000	0.451534000
	0.664055000	0.623034000	0.450338000
	0.668008000	0.626171000	0.449270000
	0.671991000	0.629316000	0.448018000
	0.675981000	0.632468000	0.446736000
	0.679979000	0.635626000	0.445424000
	0.683950000	0.638793000	0.444251000
	0.687957000	0.641966000	0.442886000
	0.691971000	0.645145000	0.441491000
	0.695985000	0.648334000	0.440072000
	0.700008000	0.651529000	0.438624000
	0.704037000	0.654731000	0.437147000
	0.708067000	0.657942000	0.435647000
	0.712105000	0.661160000	0.434117000
	0.716177000	0.664384000	0.432386000
	0.720222000	0.667618000	0.430805000
	0.724274000	0.670859000	0.429194000
	0.728334000	0.674107000	0.427554000
	0.732422000	0.677364000	0.425717000
	0.736488000	0.680629000	0.424028000
	0.740589000	0.683900000	0.422131000
	0.744664000	0.687181000	0.420393000
	0.748772000	0.690470000	0.418448000
	0.752886000	0.693766000	0.416472000
	0.756975000	0.697071000	0.414659000
	0.761096000	0.700384000	0.412638000
	0.765223000	0.703705000	0.410587000
	0.769353000	0.707035000	0.408516000
	0.773486000	0.710373000	0.406422000
	0.777651000	0.713719000	0.404112000
	0.781795000	0.717074000	0.401966000
	0.785965000	0.720438000	0.399613000
	0.790116000	0.723810000	0.397423000
	0.794298000	0.727190000	0.395016000
	0.798480000	0.730580000	0.392597000
	0.802667000	0.733978000	0.390153000
	0.806859000	0.737385000	0.387684000
	0.811054000	0.740801000	0.385198000
	0.815274000	0.744226000	0.382504000
	0.819499000	0.747659000	0.379785000
	0.823729000	0.751101000	0.377043000
	0.827959000	0.754553000	0.374292000
	0.832192000	0.758014000	0.371529000
	0.836429000	0.761483000	0.368747000
	0.840693000	0.764962000	0.365746000
	0.844957000	0.768450000	0.362741000
	0.849223000	0.771947000	0.359729000
	0.853515000	0.775454000	0.356500000
	0.857809000	0.778969000	0.353259000
	0.862105000	0.782494000	0.350011000
	0.866421000	0.786028000	0.346571000
	0.870717000	0.789572000	0.343333000
	0.875057000	0.793125000	0.339685000
	0.879378000	0.796687000	0.336241000
	0.883720000	0.800258000	0.332599000
	0.888081000	0.803839000	0.328770000
	0.892440000	0.807430000	0.324968000
	0.896818000	0.811030000	0.320982000
	0.901195000	0.814639000	0.317021000
	0.905589000	0.818257000	0.312889000
	0.910000000	0.821885000	0.308594000
	0.914407000	0.825522000	0.304348000
	0.918828000	0.829168000	0.299960000
	0.923279000	0.832822000	0.295244000
	0.927724000	0.836486000	0.290611000
	0.932180000	0.840159000	0.285880000
	0.936660000	0.843841000	0.280876000
	0.941147000	0.847530000	0.275815000
	0.945654000	0.851228000	0.270532000
	0.950178000	0.854933000	0.265085000
	0.954725000	0.858646000	0.259365000
	0.959284000	0.862365000	0.253563000
	0.963872000	0.866089000	0.247445000
	0.968469000	0.869819000	0.241310000
	0.973114000	0.873550000	0.234677000
	0.977780000	0.877281000	0.227954000
	0.982497000	0.881008000	0.220878000
	0.987293000	0.884718000	0.213336000
	0.992218000	0.888385000	0.205468000
	0.994847000	0.892954000	0.203445000
	0.995249000	0.898384000	0.207561000
	0.995503000	0.903866000	0.212370000
	0.995737000	0.909344000	0.217772000
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
