
function cm = buda(n, varargin)
% Colormap: buda

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.700151013	0.002744521	0.700612384
	0.700191439	0.010832587	0.697186185
	0.700225944	0.019196459	0.693784112
	0.700255042	0.027497170	0.690410322
	0.700279268	0.036129024	0.687067010
	0.700299178	0.044534586	0.683749887
	0.700315347	0.052200875	0.680466829
	0.700328370	0.059479068	0.677233895
	0.700338866	0.066137694	0.674023569
	0.700347484	0.072500448	0.670864562
	0.700354911	0.078556938	0.667746525
	0.700361886	0.084489178	0.664664974
	0.700369216	0.090118139	0.661646651
	0.700377793	0.095601577	0.658661978
	0.700388612	0.100918912	0.655739861
	0.700402797	0.106179574	0.652854263
	0.700421617	0.111272387	0.650034737
	0.700446514	0.116281084	0.647259934
	0.700479114	0.121141221	0.644531822
	0.700521247	0.126029246	0.641864059
	0.700574953	0.130794442	0.639246354
	0.700642483	0.135455048	0.636683655
	0.700726283	0.140078640	0.634168789
	0.700828966	0.144685047	0.631700611
	0.700953268	0.149192641	0.629284496
	0.701102108	0.153640611	0.626923309
	0.701278667	0.158084251	0.624614531
	0.701486414	0.162466064	0.622348584
	0.701729236	0.166801046	0.620146631
	0.702011587	0.171075869	0.617978545
	0.702337103	0.175335526	0.615866677
	0.702707257	0.179554849	0.613799719
	0.703121751	0.183740840	0.611790488
	0.703582256	0.187936079	0.609823327
	0.704093357	0.192033408	0.607911309
	0.704657760	0.196154358	0.606028706
	0.705274925	0.200200351	0.604212968
	0.705946456	0.204297580	0.602424435
	0.706670830	0.208310413	0.600685100
	0.707439241	0.212331692	0.598991764
	0.708264997	0.216333439	0.597336718
	0.709139656	0.220301830	0.595714428
	0.710053325	0.224219253	0.594134185
	0.711014687	0.228185934	0.592594773
	0.712010813	0.232099179	0.591072898
	0.713043840	0.235997254	0.589585257
	0.714112591	0.239863945	0.588130553
	0.715213806	0.243717366	0.586706354
	0.716339227	0.247586235	0.585309185
	0.717485370	0.251421395	0.583920023
	0.718641769	0.255233036	0.582556859
	0.719825027	0.259027870	0.581215872
	0.721011590	0.262797679	0.579897055
	0.722212253	0.266557405	0.578579638
	0.723422608	0.270315053	0.577284199
	0.724641428	0.274033740	0.576009287
	0.725860234	0.277746759	0.574722877
	0.727075223	0.281433199	0.573468376
	0.728294155	0.285106719	0.572216149
	0.729515557	0.288786035	0.570966521
	0.730730727	0.292428197	0.569729230
	0.731948327	0.296062573	0.568502382
	0.733158997	0.299688600	0.567287263
	0.734367621	0.303279959	0.566066965
	0.735568497	0.306882708	0.564853436
	0.736769355	0.310470725	0.563660870
	0.737963013	0.314024305	0.562463539
	0.739164204	0.317573639	0.561260545
	0.740347438	0.321114922	0.560077302
	0.741526797	0.324631881	0.558884654
	0.742713554	0.328153446	0.557710881
	0.743886254	0.331653632	0.556532371
	0.745056320	0.335166345	0.555357440
	0.746224729	0.338633015	0.554195813
	0.747393029	0.342110583	0.553026415
	0.748551516	0.345564696	0.551874233
	0.749704073	0.349024258	0.550713632
	0.750867574	0.352465070	0.549561116
	0.752015301	0.355908338	0.548415587
	0.753158270	0.359324454	0.547260020
	0.754310569	0.362742887	0.546123715
	0.755451334	0.366161869	0.544976598
	0.756588819	0.369555853	0.543837116
	0.757726441	0.372949035	0.542705136
	0.758860241	0.376350147	0.541560977
	0.759989937	0.379722344	0.540436824
	0.761121555	0.383103422	0.539305192
	0.762245942	0.386458838	0.538188781
	0.763371459	0.389823312	0.537064898
	0.764496938	0.393183243	0.535932616
	0.765620837	0.396533237	0.534816301
	0.766734663	0.399877564	0.533691451
	0.767849882	0.403228326	0.532586353
	0.768965109	0.406562923	0.531468271
	0.770080395	0.409898349	0.530356675
	0.771196648	0.413224884	0.529251783
	0.772302295	0.416544745	0.528136118
	0.773408062	0.419864446	0.527035563
	0.774513933	0.423170861	0.525927585
	0.775619790	0.426486792	0.524822293
	0.776726890	0.429799973	0.523722870
	0.777825926	0.433104863	0.522621277
	0.778920707	0.436412651	0.521521238
	0.780015711	0.439712990	0.520426777
	0.781110054	0.443015523	0.519342067
	0.782201630	0.446308424	0.518255758
	0.783285304	0.449611337	0.517171476
	0.784373316	0.452911208	0.516076605
	0.785449511	0.456202107	0.515006706
	0.786526379	0.459504676	0.513939445
	0.787590422	0.462791812	0.512864672
	0.788656952	0.466095924	0.511800007
	0.789713176	0.469411010	0.510743810
	0.790762519	0.472703389	0.509696467
	0.791806844	0.476015310	0.508661192
	0.792845399	0.479325149	0.507622319
	0.793876568	0.482635485	0.506588942
	0.794891577	0.485948974	0.505565081
	0.795900143	0.489268322	0.504571904
	0.796900845	0.492593582	0.503560487
	0.797893528	0.495924178	0.502571066
	0.798878640	0.499260524	0.501598554
	0.799853069	0.502601294	0.500622001
	0.800811367	0.505941671	0.499654106
	0.801762660	0.509300887	0.498714895
	0.802705532	0.512651889	0.497777702
	0.803641172	0.516004775	0.496831520
	0.804568353	0.519378042	0.495906582
	0.805480760	0.522744861	0.495000227
	0.806395309	0.526119592	0.494091534
	0.807296123	0.529496086	0.493182634
	0.808190190	0.532872947	0.492293572
	0.809081443	0.536254162	0.491418801
	0.809960459	0.539632789	0.490532317
	0.810838933	0.543029396	0.489643439
	0.811715601	0.546423037	0.488776502
	0.812582728	0.549810565	0.487915623
	0.813449439	0.553198935	0.487045680
	0.814314192	0.556600672	0.486177647
	0.815177871	0.560003215	0.485315028
	0.816041561	0.563405364	0.484455985
	0.816898108	0.566805982	0.483599961
	0.817752441	0.570200394	0.482748274
	0.818607884	0.573610501	0.481897763
	0.819463597	0.577019176	0.481034735
	0.820319958	0.580425930	0.480189282
	0.821177446	0.583831506	0.479336620
	0.822035970	0.587241081	0.478479061
	0.822888463	0.590654243	0.477626044
	0.823741265	0.594071128	0.476773682
	0.824596100	0.597489071	0.475924058
	0.825451764	0.600903014	0.475075196
	0.826310133	0.604329670	0.474213480
	0.827167160	0.607751532	0.473350280
	0.828020379	0.611173120	0.472504477
	0.828883053	0.614590401	0.471654766
	0.829740204	0.618022243	0.470795731
	0.830597541	0.621450516	0.469942944
	0.831458831	0.624886098	0.469086582
	0.832315381	0.628324965	0.468218456
	0.833173875	0.631759392	0.467368245
	0.834038448	0.635196823	0.466506477
	0.834897045	0.638641005	0.465638472
	0.835758543	0.642087709	0.464790485
	0.836621658	0.645531563	0.463930919
	0.837487803	0.648989657	0.463055373
	0.838348285	0.652439276	0.462200779
	0.839214363	0.655902376	0.461341712
	0.840083096	0.659357316	0.460468918
	0.840947111	0.662826381	0.459614069
	0.841815305	0.666286496	0.458748550
	0.842683951	0.669763615	0.457878421
	0.843547647	0.673236183	0.457011974
	0.844421151	0.676714389	0.456145221
	0.845290880	0.680187332	0.455281917
	0.846160352	0.683675092	0.454415171
	0.847032959	0.687165684	0.453535947
	0.847907121	0.690653922	0.452675257
	0.848784223	0.694148788	0.451800450
	0.849661568	0.697651942	0.450923900
	0.850534035	0.701158481	0.450049094
	0.851409915	0.704666667	0.449178221
	0.852295920	0.708180443	0.448296444
	0.853169752	0.711699368	0.447413240
	0.854049400	0.715219618	0.446541207
	0.854935837	0.718741713	0.445655265
	0.855818275	0.722269206	0.444788188
	0.856699298	0.725811246	0.443905092
	0.857583686	0.729347051	0.443020982
	0.858469961	0.732893095	0.442142283
	0.859359141	0.736435846	0.441246727
	0.860249966	0.739996537	0.440360594
	0.861135896	0.743552207	0.439474238
	0.862031995	0.747114548	0.438583844
	0.862924198	0.750684081	0.437706008
	0.863818309	0.754256636	0.436810409
	0.864708437	0.757832514	0.435919126
	0.865604132	0.761413246	0.435028243
	0.866502003	0.765005591	0.434119850
	0.867400359	0.768592552	0.433228098
	0.868306608	0.772194835	0.432343245
	0.869205589	0.775798455	0.431443049
	0.870103287	0.779408259	0.430537598
	0.871011744	0.783023085	0.429635385
	0.871922989	0.786650867	0.428732897
	0.872830656	0.790272607	0.427834485
	0.873742200	0.793911381	0.426929183
	0.874658462	0.797544714	0.426015001
	0.875581546	0.801192290	0.425118989
	0.876503708	0.804847018	0.424204756
	0.877438171	0.808509744	0.423294029
	0.878380656	0.812176980	0.422385734
	0.879330256	0.815858585	0.421480453
	0.880295011	0.819540845	0.420577874
	0.881278229	0.823242709	0.419683066
	0.882275900	0.826956232	0.418775070
	0.883301564	0.830680301	0.417880253
	0.884356085	0.834420222	0.416994539
	0.885442276	0.838174251	0.416101355
	0.886572620	0.841950316	0.415221803
	0.887744250	0.845740931	0.414352451
	0.888980586	0.849563495	0.413496843
	0.890274881	0.853401143	0.412657880
	0.891646579	0.857273929	0.411816986
	0.893098498	0.861175666	0.411007731
	0.894649098	0.865109107	0.410220673
	0.896296085	0.869084294	0.409442807
	0.898054955	0.873088382	0.408694646
	0.899940537	0.877132226	0.407975532
	0.901952440	0.881224130	0.407286201
	0.904103178	0.885354754	0.406631198
	0.906403812	0.889528959	0.406012691
	0.908850272	0.893747249	0.405420453
	0.911455309	0.898011617	0.404859124
	0.914219930	0.902321594	0.404345618
	0.917142247	0.906674845	0.403875819
	0.920216784	0.911069632	0.403438872
	0.923456971	0.915502258	0.403034171
	0.926840665	0.919981737	0.402664910
	0.930380282	0.924494474	0.402332590
	0.934052255	0.929044127	0.402037404
	0.937865507	0.933626295	0.401778141
	0.941799183	0.938243961	0.401552233
	0.945848105	0.942888259	0.401355259
	0.950004252	0.947555336	0.401183238
	0.954258294	0.952243458	0.401032963
	0.958598805	0.956957038	0.400901679
	0.963014176	0.961688113	0.400786876
	0.967501504	0.966439470	0.400686228
	0.972046105	0.971205457	0.400597625
	0.976640888	0.975983393	0.400518934
	0.981285683	0.980778721	0.400448017
	0.985967144	0.985583652	0.400382803
	0.990679623	0.990397047	0.400321341
	0.995417678	0.995217948	0.400261826
	1.000000000	1.000000000	0.400202620
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
