
function cm = bamo(n, varargin)
% Colormap: bamo

%-- Parse inputs ---------------------------------------------------------%
if ~exist('n', 'var'); n = []; end
if isempty(n)
   f = get(groot,'CurrentFigure');
   if isempty(f)
      n = size(get(groot,'DefaultFigureColormap'),1);
   else
      n = size(f.Colormap,1);
   end
end
%-------------------------------------------------------------------------%

% Data for colormap:
cm = [
	0.309457442	0.186350860	0.263735362
	0.314189537	0.186088032	0.268799435
	0.319431853	0.186148419	0.274282255
	0.325146589	0.186550882	0.280197007
	0.331347259	0.187351916	0.286517737
	0.338005054	0.188506761	0.293232575
	0.345086204	0.190023882	0.300292272
	0.352538921	0.191932523	0.307655044
	0.360320735	0.194241161	0.315302173
	0.368410768	0.196870500	0.323163995
	0.376730465	0.199805331	0.331180896
	0.385221743	0.203117449	0.339369411
	0.393875353	0.206731734	0.347622421
	0.402625505	0.210573181	0.355934538
	0.411441317	0.214681338	0.364257774
	0.420286205	0.219032664	0.372586270
	0.429134252	0.223572036	0.380902979
	0.437963769	0.228309389	0.389156796
	0.446737975	0.233163600	0.397347784
	0.455461362	0.238202465	0.405482313
	0.464119101	0.243347853	0.413527461
	0.472678649	0.248640158	0.421479775
	0.481156283	0.253993856	0.429358441
	0.489539998	0.259447831	0.437141082
	0.497840573	0.264947299	0.444823064
	0.506004000	0.270557191	0.452410211
	0.514091135	0.276199580	0.459885518
	0.522042106	0.281880702	0.467280561
	0.529905289	0.287596738	0.474570934
	0.537650778	0.293365414	0.481759927
	0.545276644	0.299176444	0.488850766
	0.552790605	0.304992029	0.495844902
	0.560198774	0.310840793	0.502745993
	0.567489280	0.316689754	0.509557126
	0.574660019	0.322565166	0.516262796
	0.581731161	0.328437736	0.522891014
	0.588686867	0.334334348	0.529422846
	0.595543887	0.340226383	0.535855006
	0.602292720	0.346118138	0.542216602
	0.608951025	0.352035993	0.548501272
	0.615497615	0.357979597	0.554699636
	0.621966174	0.363917142	0.560833758
	0.628368680	0.369890623	0.566919623
	0.634691676	0.375904326	0.572949505
	0.640950723	0.381949234	0.578935608
	0.647171491	0.388053424	0.584896836
	0.653341110	0.394218138	0.590830244
	0.659488544	0.400466831	0.596761597
	0.665607784	0.406775667	0.602679084
	0.671704254	0.413185879	0.608607945
	0.677791860	0.419683031	0.614521133
	0.683851131	0.426271304	0.620463996
	0.689908212	0.432977582	0.626395970
	0.695946680	0.439782669	0.632344575
	0.701957813	0.446692670	0.638295612
	0.707958545	0.453707969	0.644246975
	0.713931324	0.460831633	0.650207212
	0.719877098	0.468065831	0.656163156
	0.725787535	0.475416081	0.662107562
	0.731652453	0.482851230	0.668037527
	0.737474271	0.490404869	0.673945613
	0.743249471	0.498060032	0.679830417
	0.748955092	0.505788323	0.685695332
	0.754607261	0.513642900	0.691512575
	0.760174175	0.521566876	0.697287422
	0.765668195	0.529593993	0.703014007
	0.771068356	0.537693885	0.708675941
	0.776368550	0.545865497	0.714256899
	0.781563807	0.554098517	0.719768888
	0.786643506	0.562399762	0.725185801
	0.791589128	0.570729359	0.730493341
	0.796402475	0.579112645	0.735685693
	0.801073214	0.587504815	0.740753628
	0.805584511	0.595915737	0.745683146
	0.809933538	0.604322874	0.750460689
	0.814104614	0.612690663	0.755071506
	0.818091780	0.621032464	0.759493580
	0.821892090	0.629302115	0.763733193
	0.825480529	0.637498093	0.767764898
	0.828870736	0.645585130	0.771588605
	0.832041901	0.653555122	0.775175154
	0.834991811	0.661384835	0.778533498
	0.837724975	0.669048823	0.781650031
	0.840232195	0.676531629	0.784516294
	0.842515504	0.683810924	0.787127317
	0.844575276	0.690880905	0.789483697
	0.846414001	0.697728567	0.791583813
	0.848043030	0.704339716	0.793438478
	0.849466783	0.710706934	0.795033818
	0.850679122	0.716823427	0.796387189
	0.851703672	0.722674509	0.797504812
	0.852545366	0.728280434	0.798392918
	0.853198891	0.733630582	0.799060260
	0.853687988	0.738726237	0.799513214
	0.854020894	0.743569323	0.799761226
	0.854203775	0.748166726	0.799816004
	0.854245055	0.752516445	0.799688259
	0.854153654	0.756640123	0.799387510
	0.853938502	0.760533552	0.798922951
	0.853608944	0.764201852	0.798306055
	0.853175551	0.767655545	0.797548690
	0.852646104	0.770910749	0.796660077
	0.852018868	0.773955108	0.795650532
	0.851302063	0.776820794	0.794530071
	0.850515412	0.779490414	0.793303670
	0.849658447	0.781992597	0.791974454
	0.848728948	0.784323274	0.790559952
	0.847737366	0.786490790	0.789067776
	0.846690398	0.788501175	0.787491642
	0.845590755	0.790366406	0.785848898
	0.844440462	0.792095458	0.784136885
	0.843234676	0.793697810	0.782351628
	0.841983835	0.795165561	0.780499504
	0.840675435	0.796520159	0.778580065
	0.839311306	0.797766890	0.776588130
	0.837887796	0.798911575	0.774505969
	0.836393773	0.799954474	0.772341929
	0.834827610	0.800894968	0.770074583
	0.833175190	0.801743530	0.767692824
	0.831433427	0.802498405	0.765192415
	0.829579295	0.803157715	0.762535764
	0.827601338	0.803718820	0.759723740
	0.825492736	0.804174720	0.756736965
	0.823236131	0.804515782	0.753547004
	0.820811272	0.804732874	0.750139805
	0.818203457	0.804815456	0.746495001
	0.815400338	0.804749819	0.742592904
	0.812374073	0.804519491	0.738401705
	0.809118011	0.804104303	0.733914599
	0.805596466	0.803483152	0.729100973
	0.801807425	0.802638213	0.723944368
	0.797723896	0.801546331	0.718424298
	0.793334522	0.800185364	0.712520597
	0.788608641	0.798520780	0.706228158
	0.783540056	0.796534911	0.699511541
	0.778115368	0.794212925	0.692390842
	0.772324701	0.791515281	0.684832205
	0.766169794	0.788440088	0.676868506
	0.759644172	0.784968333	0.668493430
	0.752767505	0.781087468	0.659733024
	0.745556298	0.776805432	0.650618639
	0.738025521	0.772114006	0.641182343
	0.730218468	0.767032905	0.631484480
	0.722150389	0.761581875	0.621552610
	0.713883976	0.755783681	0.611464686
	0.705448313	0.749656434	0.601255701
	0.696888691	0.743253979	0.590995144
	0.688250769	0.736582806	0.580732974
	0.679563477	0.729700811	0.570511797
	0.670884545	0.722622919	0.560390586
	0.662228970	0.715405241	0.550390621
	0.653620010	0.708053557	0.540550122
	0.645095880	0.700613283	0.530894801
	0.636681203	0.693104495	0.521440092
	0.628371666	0.685545182	0.512208764
	0.620190299	0.677960376	0.503201258
	0.612134185	0.670367014	0.494446007
	0.604235657	0.662773168	0.485909139
	0.596470078	0.655190126	0.477622846
	0.588849288	0.647642318	0.469582714
	0.581388577	0.640133558	0.461761736
	0.574071591	0.632659982	0.454180975
	0.566912342	0.625236294	0.446823894
	0.559890525	0.617866971	0.439692893
	0.553007131	0.610560595	0.432781470
	0.546284330	0.603314546	0.426068661
	0.539679040	0.596129759	0.419580452
	0.533226389	0.589009632	0.413282093
	0.526914039	0.581967704	0.407171524
	0.520717004	0.574993790	0.401260419
	0.514662500	0.568094778	0.395524986
	0.508731673	0.561266732	0.389952775
	0.502908345	0.554516845	0.384565576
	0.497226475	0.547836463	0.379344225
	0.491659198	0.541224686	0.374286291
	0.486187319	0.534697656	0.369365494
	0.480833331	0.528236478	0.364595214
	0.475598935	0.521837480	0.359971541
	0.470450264	0.515513434	0.355491942
	0.465387861	0.509258006	0.351121545
	0.460424480	0.503042495	0.346875391
	0.455551855	0.496890477	0.342744840
	0.450745892	0.490791185	0.338705739
	0.445998731	0.484699945	0.334785305
	0.441324683	0.478657243	0.330916774
	0.436702668	0.472630590	0.327155242
	0.432131266	0.466622095	0.323474352
	0.427590717	0.460610240	0.319862415
	0.423078356	0.454626936	0.316310440
	0.418617495	0.448629033	0.312805165
	0.414193970	0.442636367	0.309394573
	0.409805652	0.436642012	0.306024205
	0.405445786	0.430652994	0.302684523
	0.401128150	0.424670920	0.299448620
	0.396828385	0.418691661	0.296245632
	0.392590995	0.412746510	0.293104110
	0.388397550	0.406797564	0.290029886
	0.384243956	0.400893377	0.287014091
	0.380149401	0.394994129	0.284073576
	0.376110837	0.389145546	0.281187746
	0.372115170	0.383336353	0.278389198
	0.368202922	0.377565717	0.275656955
	0.364343958	0.371846707	0.272968851
	0.360554736	0.366208600	0.270381866
	0.356866604	0.360604244	0.267825005
	0.353231046	0.355114350	0.265389784
	0.349687098	0.349666587	0.263025864
	0.346217198	0.344302777	0.260726562
	0.342865832	0.339056290	0.258510676
	0.339590706	0.333887071	0.256373176
	0.336393797	0.328819625	0.254342060
	0.333326135	0.323845955	0.252370166
	0.330337282	0.318997069	0.250471358
	0.327451644	0.314252296	0.248696337
	0.324673949	0.309639945	0.246964553
	0.322009222	0.305122806	0.245319595
	0.319444308	0.300716288	0.243768652
	0.316977436	0.296449650	0.242309484
	0.314604324	0.292282586	0.240914234
	0.312334370	0.288227378	0.239613179
	0.310192882	0.284282084	0.238365642
	0.308102732	0.280434661	0.237234214
	0.306142252	0.276711695	0.236133133
	0.304230255	0.273053688	0.235120931
	0.302414473	0.269493857	0.234151707
	0.300691970	0.265997707	0.233247947
	0.299059115	0.262568247	0.232447495
	0.297484033	0.259220290	0.231704144
	0.295981975	0.255893777	0.231002434
	0.294554200	0.252649755	0.230358211
	0.293206128	0.249426133	0.229791178
	0.291940761	0.246247415	0.229310829
	0.290730558	0.243099525	0.228903057
	0.289612306	0.239988491	0.228559152
	0.288564352	0.236925615	0.228285804
	0.287594965	0.233831269	0.228093735
	0.286722694	0.230800670	0.227991265
	0.285950448	0.227796430	0.227986035
	0.285286944	0.224779800	0.228086218
	0.284740372	0.221840976	0.228300445
	0.284320357	0.218938372	0.228635461
	0.284038907	0.216081040	0.229092319
	0.283909443	0.213228342	0.229687934
	0.283946571	0.210479746	0.230472477
	0.284167072	0.207792682	0.231448357
	0.284589775	0.205175580	0.232578155
	0.285234897	0.202653380	0.233925270
	0.286126447	0.200228124	0.235528829
	0.287291434	0.197952070	0.237368917
	0.288761248	0.195806063	0.239455115
	0.290526045	0.193825948	0.241855926
	0.292653561	0.191986313	0.244552401
	0.295151679	0.190365675	0.247637254
	0.298053426	0.188976853	0.251061581
	0.301386340	0.187847996	0.254881553
	0.305189860	0.186937381	0.259095903
];

% Modify the colormap by interpolation to match number of waypoints.
cm = tools.interpolate(cm, n, varargin{:});

end
