function diagnostics = info(iteration)
    % INFO  Formats diagnostics information for tests based on random trials.

    arguments% (Input)
        iteration (1, 1) {mustBeNumeric} = nan;
    end
    % arguments (Output)
    %     diagnostics (1, :) string;
    % end

    diagnostics = [];

    if ~isnan(iteration); diagnostics = [diagnostics, sprintf("Iteration: %s", int2str(iteration))]; end
    diagnostics = [diagnostics, sprintf("Seed: %s", int2str(rng().Seed))];
end
