classdef LaboratoryConfigTest < matlab.unittest.TestCase
    % LABORATORYCONFIGTEST  Unit tests for [LaboratoryConfig].

    methods (Test) % cache_cull
        function cache_cull_deep_copy(testCase)
            conf = LaboratoryConfig(struct(exp_confs = [ExperimentConfig(struct(node_count = [1, 2]))]));

            culled = conf.cache_cull();
            culled.exp_confs(1).node_count = [2, 3];

            testCase.verifyEqual(conf.exp_confs(1).node_count, [1, 2]);
        end

        function cache_cull_recursive_cull(testCase)
            conf = LaboratoryConfig(struct(exp_confs = [ExperimentConfig(struct(network_watts_strogatz_k = 8))]));

            fn = fieldnames(conf.cache_cull().exp_confs(1));

            testCase.verifyTrue(ismember('network_layout', fn));
            testCase.verifyFalse(ismember('network_watts_strogatz_k', fn));
        end
    end
end
