function values = randf(range, size)
    % RANDF  Generates [size] uniformly random real numbers in the closed [range].

    arguments% (Input)
        range (1, 2) {mustBeNumeric};
        size (1, :) {mustBeInteger, mustBePositive} = 1;
    end
    % arguments (Output)
    %     values {mustBeNumeric};
    % end

    values = range(1) + (range(2) - range(1)) * rand(size);
end
