% # Question
% Why does most-cycles stretching cause a sawtooth pattern, especially in
% Barabási–Albert graphs?
%
% # Setup
% Iteratively stretch an ER graph and a BA graph, and after each iteration,
% create a histogram of cycle lengths. Compare to see if Barabási–Albert are
% indeed affected more. To find out why this happens, use the debugger and
% inspect the inner workings of the `Graphs.stretch` method.
%
% # Conclusion
% Stretching to even girth disproportionately removes odd-length cycles of any
% length, even those longer than the desired girth. Exact reason is not clear.

clear;
% rng(17, "twister");


g_list = 3:8;

G_BA = Graphs.generate_barabasi_albert(25, 10);
G_ER = Graphs.generate_erdos_renyi(25, 0.5);

cyc_BA = nan([max(g_list), max(g_list)]);
cyc_ER = nan([max(g_list), max(g_list)]);

for g = g_list
    G_BA_STR = Graphs.stretch(G_BA, girth = g, method = "most_cycles_steps");
    G_ER_STR = Graphs.stretch(G_ER, girth = g, method = "most_cycles_steps");

    for cyc_len = g_list
        fprintf("%d / %d\n", g, cyc_len);
        cyc_BA(g, cyc_len) = height(allcycles(G_BA_STR, MinCycleLength = cyc_len, MaxCycleLength = cyc_len));
        cyc_ER(g, cyc_len) = height(allcycles(G_ER_STR, MinCycleLength = cyc_len, MaxCycleLength = cyc_len));
    end
end

cyc_ER
cyc_BA
