function mustContainSubstring(string, substring)
    % MUSTCONTAINSUBSTRING  Validates that [string] contains [substring].
    %
    % This function throws an error if [substring] does not occur in [string], and
    % returns nothing otherwise.

    arguments% (Input)
        string (1, 1) {mustBeText};
        substring (1, 1) {mustBeText};
    end

    if ~contains(string, substring)
        error("Input '%s' must contain substring '%s'.", string, substring);
    end
end
