function [value, idx] = min_rng(values)
    % MIN_RNG  Outputs the lowest [value] in [values] and a random [idx] of [values]
    % at which that [value] is found.
    %
    % Differs from the regular [min] function only if [value] is found in [values]
    % at multiple indices. From that set of indices, [min] returns the lowest index,
    % but [min_rng] returns a random [idx].

    if isempty(values)
        value = [];
        idx = [];
        return;
    end
    if all(isnan(values))
        value = NaN;
        idx = 0;
        return;
    end

    idxs = 1:numel(values);
    value = min(values, [], "all");
    idx = randelem(idxs(values == value));  % This is faster than first doing randsample and then doing `min`
end
